/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.webservice.AttendeeAvailability;
import coldfusion.exchange.webservice.CFTimeZone;
import coldfusion.exchange.webservice.CFUserAvailability;
import coldfusion.exchange.webservice.CalendarEvent;
import coldfusion.exchange.webservice.CalendarEventDetails;
import coldfusion.exchange.webservice.Conflict;
import coldfusion.exchange.webservice.Suggestion;
import coldfusion.exchange.webservice.TimeSuggestion;
import coldfusion.exchange.webservice.WorkingHours;
import coldfusion.runtime.CFPage;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.exchange.CalendarConstants;
import coldfusion.tagext.net.exchange.UserAvailabilityQueryMetaData;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class UserAvailabilityQuery
extends QueryTable
implements CalendarConstants {
    public void populate(CFUserAvailability availability) {
        this.meta = new UserAvailabilityQueryMetaData(availability);
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (null == availability) {
            this.row_count = 0;
            return;
        }
        this.ensureCapacity(1);
        Object[] colData = new Object[this.col_count];
        if (null != availability.getAttendeesAvailability() && null != availability.getSuggestions()) {
            colData[0] = this.getAttendeeAvailabilityList(availability.getAttendeesAvailability());
            colData[1] = this.getSuggestions(availability.getSuggestions());
        }
        colData[0] = null != availability.getAttendeesAvailability() ? this.getAttendeeAvailabilityList(availability.getAttendeesAvailability()) : this.getSuggestions(availability.getSuggestions());
        this.addRow(colData);
    }

    private List<CaseInsensitiveMap> getAttendeeAvailabilityList(Collection<AttendeeAvailability> attendeesAvailability) {
        ArrayList<CaseInsensitiveMap> attendeeAvailabilityList = new ArrayList<CaseInsensitiveMap>();
        for (AttendeeAvailability attendeeAvailability : attendeesAvailability) {
            CaseInsensitiveMap availabilityStruct = new CaseInsensitiveMap();
            Collection<CalendarEvent> calendarEvents = attendeeAvailability.getCalendarEvents();
            availabilityStruct.put(Key.getInstance((String)"CalendarEvents"), this.getCalendarEvents(calendarEvents));
            Collection<String> mergedFreeBusyStatus = attendeeAvailability.getMergedFreeBusyStatus();
            availabilityStruct.put(Key.getInstance((String)"MergedFreeBusyStatus"), this.getFreeBusyStatus(mergedFreeBusyStatus));
            String viewType = attendeeAvailability.getViewType();
            availabilityStruct.put(Key.getInstance((String)"ViewType"), (Object)viewType);
            WorkingHours workingHours = attendeeAvailability.getWorkingHours();
            availabilityStruct.put(Key.getInstance((String)"WorkingHours"), (Object)this.getWorkingHours(workingHours));
            attendeeAvailabilityList.add(availabilityStruct);
        }
        return attendeeAvailabilityList;
    }

    private List<CaseInsensitiveMap> getCalendarEvents(Collection<CalendarEvent> calendarEvents) {
        ArrayList<CaseInsensitiveMap> calendarEventsList = new ArrayList<CaseInsensitiveMap>();
        for (CalendarEvent calendarEvent : calendarEvents) {
            CaseInsensitiveMap calendarEventStruct = new CaseInsensitiveMap();
            Date startTime = calendarEvent.getStartTime();
            calendarEventStruct.put(Key.getInstance((String)"StartTime"), (Object)CFPage.CreateODBCDateTime((Object)startTime));
            Date endTime = calendarEvent.getEndTime();
            calendarEventStruct.put(Key.getInstance((String)"EndTime"), (Object)CFPage.CreateODBCDateTime((Object)endTime));
            String freeBusyStatus = calendarEvent.getFreeBusyStatus();
            calendarEventStruct.put(Key.getInstance((String)"FreeBusyStatus"), (Object)freeBusyStatus);
            CalendarEventDetails details = calendarEvent.getDetails();
            if (null != details) {
                calendarEventStruct.put(Key.getInstance((String)"Location"), (Object)details.getLocation());
                calendarEventStruct.put(Key.getInstance((String)"StoreId"), (Object)details.getStoreId());
                calendarEventStruct.put(Key.getInstance((String)"Subject"), (Object)details.getSubject());
                calendarEventStruct.put(Key.getInstance((String)"isException"), (Object)details.isException());
                calendarEventStruct.put(Key.getInstance((String)"isMeeting"), (Object)details.isMeeting());
                calendarEventStruct.put(Key.getInstance((String)"isPrivate"), (Object)details.isPrivate());
                calendarEventStruct.put(Key.getInstance((String)"isRecurring"), (Object)details.isRecurring());
                calendarEventStruct.put(Key.getInstance((String)"isReminderSet"), (Object)details.isReminderSet());
            }
            calendarEventsList.add(calendarEventStruct);
        }
        return calendarEventsList;
    }

    private List<CaseInsensitiveMap> getFreeBusyStatus(Collection<String> mergedFreeBusyStatus) {
        ArrayList<CaseInsensitiveMap> statusList = new ArrayList<CaseInsensitiveMap>();
        for (String legacyFreeBusyStatus : mergedFreeBusyStatus) {
            CaseInsensitiveMap statusStruct = new CaseInsensitiveMap();
            statusStruct.put(Key.getInstance((String)"Status"), (Object)legacyFreeBusyStatus);
            statusList.add(statusStruct);
        }
        return statusList;
    }

    private CaseInsensitiveMap getWorkingHours(WorkingHours workingHours) {
        CaseInsensitiveMap workingHoursStruct = new CaseInsensitiveMap();
        if (null != workingHours) {
            long startTime = workingHours.getStartTime();
            workingHoursStruct.put(Key.getInstance((String)"StartTime"), (Object)startTime);
            long endTime = workingHours.getEndTime();
            workingHoursStruct.put(Key.getInstance((String)"EndTime"), (Object)endTime);
            Collection<String> daysOfTheWeek = workingHours.getDaysOfTheWeek();
            workingHoursStruct.put(Key.getInstance((String)"DaysOfTheWeek"), this.getDaysOfTheWeek(daysOfTheWeek));
            CFTimeZone timeZone = workingHours.getTimeZone();
            if (null != timeZone) {
                workingHoursStruct.put(Key.getInstance((String)"TimeZoneDefinition"), this.getTimeZone(timeZone));
            }
        }
        return workingHoursStruct;
    }

    private Object getTimeZone(CFTimeZone timeZone) {
        CaseInsensitiveMap timeZoneStruct = new CaseInsensitiveMap();
        String id = timeZone.getId();
        timeZoneStruct.put(Key.getInstance((String)"id"), (Object)id);
        String name = timeZone.getName();
        timeZoneStruct.put(Key.getInstance((String)"Name"), (Object)name);
        return timeZoneStruct;
    }

    private List<CaseInsensitiveMap> getDaysOfTheWeek(Collection<String> daysOfTheWeek) {
        ArrayList<CaseInsensitiveMap> daysOfTheWeekList = new ArrayList<CaseInsensitiveMap>();
        for (String dayOfTheWeek : daysOfTheWeek) {
            CaseInsensitiveMap dayOfTheWeekStruct = new CaseInsensitiveMap();
            dayOfTheWeekStruct.put(Key.getInstance((String)"DayOfTheWeek"), (Object)dayOfTheWeek);
            daysOfTheWeekList.add(dayOfTheWeekStruct);
        }
        return daysOfTheWeekList;
    }

    private List<CaseInsensitiveMap> getSuggestions(Collection<Suggestion> suggestions) {
        ArrayList<CaseInsensitiveMap> suggestionsList = new ArrayList<CaseInsensitiveMap>();
        for (Suggestion suggestion : suggestions) {
            CaseInsensitiveMap suggestionStruct = new CaseInsensitiveMap();
            Date date = suggestion.getDate();
            suggestionStruct.put(Key.getInstance((String)"Date"), (Object)CFPage.CreateODBCDateTime((Object)date));
            String quality = suggestion.getQuality();
            suggestionStruct.put(Key.getInstance((String)"Quality"), (Object)quality);
            Collection<TimeSuggestion> timeSuggestions = suggestion.getTimeSuggestions();
            suggestionStruct.put(Key.getInstance((String)"TimeSuggestions"), this.getTimeSuggestions(timeSuggestions));
            suggestionsList.add(suggestionStruct);
        }
        return suggestionsList;
    }

    private List<CaseInsensitiveMap> getTimeSuggestions(Collection<TimeSuggestion> timeSuggestions) {
        ArrayList<CaseInsensitiveMap> timeSuggestionsList = new ArrayList<CaseInsensitiveMap>();
        for (TimeSuggestion timeSuggestion : timeSuggestions) {
            CaseInsensitiveMap timeSuggestionsStruct = new CaseInsensitiveMap();
            Date meetingTime = timeSuggestion.getMeetingTime();
            timeSuggestionsStruct.put(Key.getInstance((String)"MeetingDate"), (Object)CFPage.CreateODBCDateTime((Object)meetingTime));
            String quality = timeSuggestion.getQuality();
            timeSuggestionsStruct.put(Key.getInstance((String)"Quality"), (Object)quality);
            Collection<Conflict> conflicts = timeSuggestion.getConflicts();
            timeSuggestionsStruct.put(Key.getInstance((String)"Conflicts"), this.getConflicts(conflicts));
            boolean isWorkTime = timeSuggestion.isWorkTime();
            timeSuggestionsStruct.put(Key.getInstance((String)"IsWorkTime"), (Object)isWorkTime);
            timeSuggestionsList.add(timeSuggestionsStruct);
        }
        return timeSuggestionsList;
    }

    private List<CaseInsensitiveMap> getConflicts(Collection<Conflict> conflicts) {
        ArrayList<CaseInsensitiveMap> conflictsList = new ArrayList<CaseInsensitiveMap>();
        for (Conflict conflict : conflicts) {
            CaseInsensitiveMap conflictStruct = new CaseInsensitiveMap();
            String conflictType = conflict.getConflictType();
            conflictStruct.put(Key.getInstance((String)"ConflictType"), (Object)conflictType);
            String freeBusyStatus = conflict.getFreeBusyStatus();
            conflictStruct.put(Key.getInstance((String)"FreebusyStatus"), (Object)freeBusyStatus);
            conflictStruct.put(Key.getInstance((String)"NumberOfMembers"), (Object)conflict.getNumberOfMembers());
            conflictStruct.put(Key.getInstance((String)"NumberOfMembersAvailable"), (Object)conflict.getNumberOfMembersAvailable());
            conflictStruct.put(Key.getInstance((String)"NumberOfMembersWithConflict"), (Object)conflict.getNumberOfMembersWithConflict());
            conflictStruct.put(Key.getInstance((String)"NumberOfMembersWithNoData"), (Object)conflict.getNumberOfMembersWithNoData());
            conflictsList.add(conflictStruct);
        }
        return conflictsList;
    }
}

