/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange;

import coldfusion.exchange.ExchangeAbstractObject;
import coldfusion.exchange.RecurrenceInfo;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class ExchangeAppointment
extends ExchangeAbstractObject
implements Serializable {
    public static final int NONE_RECURRENCE = 0;
    public static final int MONTH_RECURRENCE = 1;
    public static final int DAY_RECURRENCE = 2;
    private Date startTime = null;
    private Date endTime = null;
    private Date lastModified = null;
    private Boolean reminderSent = null;
    private Boolean isAllDay = null;
    private Long duration = null;
    private String sensitivity = null;
    private String importance = null;
    private Boolean hasAttachment = null;
    private String location = null;
    private String organizer = null;
    private String resources = null;
    private String requiredAttendees = null;
    private String optionalAttendees = null;
    private Boolean isRecurring = null;
    private Integer recurrenceType = null;
    private RecurrenceInfo recurrenceInfo = null;
    private String busyStatus = null;
    private Integer timeZoneId = null;
    private String timeZone = null;
    private String appointmentType = null;
    private Date replyTime = null;
    private Integer responseCode = null;
    private Integer attendeeStatus = null;
    private Integer appStateFlag = null;
    private Boolean recurringSeries = null;
    private Integer reminderPeriod = null;
    private Boolean isOrganizer = null;
    private String categories = null;
    private Integer label = null;
    private String recurrenceId = null;
    private String recurrenceIdRange = null;
    private String calendarFolderPath = null;
    private String calendarFolderId = null;
    private String pathDelimitter = null;

    public String getRecurrenceId() {
        return this.recurrenceId;
    }

    public void setRecurrenceId(String recurrenceId) {
        this.recurrenceId = recurrenceId;
    }

    public String getRecurrenceIdRange() {
        return this.recurrenceIdRange;
    }

    public void setRecurrenceIdRange(String recurrenceIdRange) {
        this.recurrenceIdRange = recurrenceIdRange;
    }

    public Boolean getIsOrganizer() {
        return this.isOrganizer;
    }

    public void setIsOrganizer(boolean isOrganizer) {
        this.isOrganizer = new Boolean(isOrganizer);
    }

    public Integer getReminderPeriod() {
        return this.reminderPeriod;
    }

    public void setReminderPeriod(int reminderPeriod) {
        this.reminderPeriod = new Integer(reminderPeriod);
    }

    public void setReminderPeriod(Integer reminderPeriod) {
        this.reminderPeriod = reminderPeriod;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Integer getAppStateFlag() {
        return this.appStateFlag;
    }

    public void setAppStateFlag(int appStateFlag) {
        this.appStateFlag = new Integer(appStateFlag);
    }

    public Integer getAttendeeStatus() {
        return this.attendeeStatus;
    }

    public void setAttendeeStatus(int attendeeStatus) {
        this.attendeeStatus = new Integer(attendeeStatus);
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = new Integer(responseCode);
    }

    public Date getReplyTime() {
        return this.replyTime;
    }

    public void setReplyTime(Date replyTime) {
        this.replyTime = replyTime;
    }

    public String getAppointmentType() {
        return this.appointmentType;
    }

    public void setAppointmentType(String appointmentType) {
        this.appointmentType = appointmentType;
    }

    public Integer getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(Integer timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setTimeZoneId(int timeZoneId) {
        this.timeZoneId = new Integer(timeZoneId);
    }

    public String getBusyStatus() {
        return this.busyStatus;
    }

    public void setBusyStatus(String busyStatus) {
        this.busyStatus = busyStatus;
    }

    public RecurrenceInfo getRecurrenceInfo() {
        return this.recurrenceInfo;
    }

    public void setRecurrenceInfo(RecurrenceInfo recurrenceInfo) {
        this.isRecurring = recurrenceInfo != null ? Boolean.TRUE : Boolean.FALSE;
        this.recurrenceInfo = recurrenceInfo;
    }

    public Integer getRecurrenceType() {
        return this.recurrenceType;
    }

    public void setRecurrenceType(int recurrenceType) {
        this.recurrenceType = new Integer(recurrenceType);
    }

    public Boolean isRecurring() {
        return this.isRecurring;
    }

    public void setRecurring(boolean isRecurring) {
        this.isRecurring = isRecurring ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getResources() {
        return this.resources;
    }

    public void setResources(String resources) {
        this.resources = resources;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date time) {
        this.startTime = time;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date time) {
        this.endTime = time;
    }

    public Boolean isReminderSent() {
        return this.reminderSent;
    }

    public void setReminderSent(boolean sent) {
        this.reminderSent = sent ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isAppointmentDueForNotification(int notificationDuration) {
        long startTimeMillis = this.startTime.getTime();
        long notifyMillis = notificationDuration * 1000 + 3600000;
        Date notifyDate = new Date(startTimeMillis - notifyMillis);
        Calendar cal = Calendar.getInstance();
        Date currDate = cal.getTime();
        long notifyTime = notifyDate.getTime();
        long currTime = currDate.getTime();
        if (currTime >= notifyTime && currTime <= startTimeMillis) {
            return true;
        }
        return currTime > startTimeMillis && this.reminderSent != null && this.reminderSent == false;
    }

    public boolean equals(ExchangeAppointment apt) {
        if (apt == null) {
            return false;
        }
        return apt.getStartTime().equals(this.getStartTime()) && apt.getEndTime().equals(this.getEndTime()) && apt.getSubject().equals(this.getSubject()) && apt.getMessage().equals(this.getMessage()) && apt.isReminderSent() == this.isReminderSent();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Start Date : " + this.getStartTime());
        buf.append("\n---End Date : " + this.getEndTime());
        buf.append("\n---Subject : " + this.getSubject());
        buf.append("\n---Text : " + this.getMessage() + "\n");
        return buf.toString();
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = new Long(duration);
    }

    public Boolean isHasAttachment() {
        return this.hasAttachment;
    }

    public void setHasAttachment(boolean hasAttachment) {
        this.hasAttachment = hasAttachment ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isAllDay() {
        return this.isAllDay;
    }

    public void setAllDay(boolean isAllDay) {
        this.isAllDay = isAllDay ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(String sensitivity) {
        this.sensitivity = sensitivity;
    }

    public String getOrganizer() {
        return this.organizer;
    }

    public void setOrganizer(String organizer) {
        this.organizer = organizer;
    }

    public String getOptionalAttendees() {
        return this.optionalAttendees;
    }

    public void setOptionalAttendees(String optionalAttendees) {
        this.optionalAttendees = optionalAttendees;
    }

    public String getRequiredAttendees() {
        return this.requiredAttendees;
    }

    public void setRequiredAttendees(String requiredAttendees) {
        this.requiredAttendees = requiredAttendees;
    }

    public String getImportance() {
        return this.importance;
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public void setNonNullValues(ExchangeAppointment apt) {
        super.setNonNullValues(apt);
        if (apt.isAllDay() != null) {
            this.setAllDay(apt.isAllDay());
        }
        if (apt.getAppointmentType() != null) {
            this.setAppointmentType(apt.getAppointmentType());
        }
        if (apt.getBusyStatus() != null) {
            this.setBusyStatus(apt.getBusyStatus());
        }
        if (apt.getDuration() != null) {
            this.setDuration(apt.getDuration().intValue());
        }
        if (apt.getEndTime() != null) {
            this.setEndTime(apt.getEndTime());
        }
        if (apt.getFromId() != null) {
            this.setFromId(apt.getFromId());
        }
        if (apt.isHasAttachment() != null) {
            this.setHasAttachment(apt.isHasAttachment());
        }
        if (apt.getHref() != null) {
            this.setHref(apt.getHref());
        }
        if (apt.getId() != null) {
            this.setId(apt.getId());
        }
        if (apt.getImportance() != null) {
            this.setImportance(apt.getImportance());
        }
        if (apt.getLocation() != null) {
            this.setLocation(apt.getLocation());
        }
        if (apt.getMessage() != null) {
            this.setMessage(apt.getMessage());
        }
        if (apt.getOptionalAttendees() != null) {
            this.setOptionalAttendees(apt.getOptionalAttendees());
        }
        if (apt.getOrganizer() != null) {
            this.setOrganizer(apt.getOrganizer());
        }
        if (apt.getPriority() != null) {
            this.setPriority(apt.getPriority());
        }
        if (apt.isRead() != null) {
            this.setRead(apt.isRead());
        }
        if (apt.getRecurrenceInfo() != null) {
            this.setRecurrenceInfo(apt.getRecurrenceInfo());
        }
        if (apt.getRecurrenceType() != null) {
            this.setRecurrenceType(apt.getRecurrenceType());
        }
        if (apt.isRecurring() != null) {
            this.setRecurring(apt.isRecurring());
        }
        if (apt.isReminderSent() != null) {
            this.setReminderSent(apt.isReminderSent());
        }
        if (apt.getRequiredAttendees() != null) {
            this.setRequiredAttendees(apt.getRequiredAttendees());
        }
        if (apt.getResources() != null) {
            this.setResources(apt.getResources());
        }
        if (apt.getSensitivity() != null) {
            this.setSensitivity(apt.getSensitivity());
        }
        if (apt.getStartTime() != null) {
            this.setStartTime(apt.getStartTime());
        }
        if (apt.getSubject() != null) {
            this.setSubject(apt.getSubject());
        }
        if (apt.getTimeReceived() != null) {
            this.setTimeReceived(apt.getTimeReceived());
        }
        if (apt.getTimeSent() != null) {
            this.setTimeSent(apt.getTimeSent());
        }
        if (apt.getTimeZoneId() != null) {
            this.setTimeZoneId((int)this.getTimeZoneId());
        }
        if (apt.getToId() != null) {
            this.setToId(apt.getToId());
        }
        if (apt.getReplyTime() != null) {
            this.setReplyTime(this.getReplyTime());
        }
        if (apt.getResponseCode() != null) {
            this.setResponseCode(apt.getResponseCode());
        }
        if (apt.getAttendeeStatus() != null) {
            this.setAttendeeStatus(apt.getAttendeeStatus());
        }
        if (apt.isRecurring() != null) {
            this.setRecurring(apt.isRecurring);
        }
        if (apt.isRecurringSeries() != null) {
            this.setRecurringSeries(apt.isRecurringSeries());
        }
        if (apt.getAppStateFlag() != null) {
            this.setAppStateFlag(apt.getAppStateFlag());
        }
        if (apt.getReminderPeriod() != null) {
            this.setReminderPeriod(apt.getReminderPeriod());
        }
        if (apt.getCategories() != null) {
            this.setCategories(apt.getCategories());
        }
        if (apt.getLabel() != null) {
            this.setLabel(apt.getLabel());
        }
        if (apt.getRecurrenceId() != null) {
            this.setRecurrenceId(apt.getRecurrenceId());
        }
        if (apt.getRecurrenceIdRange() != null) {
            this.setRecurrenceIdRange(apt.getRecurrenceIdRange());
        }
    }

    public Boolean isRecurringSeries() {
        return this.recurringSeries;
    }

    public void setRecurringSeries(boolean recurringSeries) {
        this.recurringSeries = recurringSeries ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getCategories() {
        return this.categories;
    }

    public void setCategories(String categories) {
        this.categories = categories;
    }

    public Integer getLabel() {
        return this.label;
    }

    public void setLabel(Integer label) {
        this.label = label;
    }

    public String getCalendarFolderPath() {
        return this.calendarFolderPath;
    }

    public void setCalendarFolderPath(String calendarFolderPath) {
        this.calendarFolderPath = calendarFolderPath;
    }

    public String getCalendarFolderId() {
        return this.calendarFolderId;
    }

    public void setCalendarFolderId(String calendarFolderId) {
        this.calendarFolderId = calendarFolderId;
    }

    public String getPathDelimitter() {
        return this.pathDelimitter;
    }

    public void setPathDelimitter(String pathDelimitter) {
        this.pathDelimitter = pathDelimitter;
    }
}

