/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ssp;

import java.io.IOException;
import java.sql.SQLException;
import macromedia.sequelink.auth.MGSSException;
import macromedia.sequelink.auth.MGSSHandle;
import macromedia.sequelink.auth.MGSSToken;
import macromedia.sequelink.ssp.CodecChainedPacket;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SspContext;
import macromedia.slutil.UtilException;

public class CodecAuthenticate
extends CodecChainedPacket {
    MGSSHandle securityHandle;
    int majorReturnCode;
    MGSSToken outputToken;
    MGSSToken inputToken;

    CodecAuthenticate(SspContext sspContext, MGSSHandle mGSSHandle, MGSSToken mGSSToken, int n) {
        super(37, sspContext);
        this.securityHandle = mGSSHandle;
        this.majorReturnCode = n;
        this.outputToken = mGSSToken;
    }

    void encodeBody() throws IOException, UtilException {
        this.sos.writeSSPString(this.securityHandle.getMechanism());
        this.sos.writeSSPInt32(this.majorReturnCode);
        this.securityHandle.streamToken(this.sos, this.outputToken);
    }

    void decodeBodyMinus() throws IOException, SQLException {
        this.majorReturnCode = this.sis.readSSPInt32();
    }

    void decodeBodyPlus() throws IOException, SQLException, UtilException {
        try {
            this.inputToken = this.securityHandle.unstreamToken(this.sis);
        }
        catch (MGSSException mGSSException) {
            SQLException sQLException = Message.Gen.getSqlException(7853);
            SQLException sQLException2 = new SQLException(mGSSException.toString(), "08001");
            sQLException.setNextException(sQLException2);
            throw sQLException;
        }
    }

    public MGSSToken getInputToken() {
        return this.inputToken;
    }

    public int getMajorReturnCode() {
        return this.majorReturnCode;
    }
}

