/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import macromedia.sequelink.net.IIOP;
import macromedia.sequelink.net.IIOPFormat;
import macromedia.sequelink.net.IIOPOctetSequence;
import macromedia.sequelink.net.IIOPRequest;
import macromedia.sequelink.net.IIOPString;
import macromedia.sequelink.net.NetByteOrder;
import macromedia.sequelink.net.NetworkException;

public class IIOPEncoder {
    OutputStream os;
    DataOutputStream dos;
    IIOPRequest iiop;
    IIOPFormat iiopFormat;

    IIOPEncoder(OutputStream outputStream, IIOPRequest iIOPRequest) throws NetworkException {
        this.iiopFormat = new IIOPFormat(iIOPRequest);
        this.os = outputStream;
        this.dos = new DataOutputStream(outputStream);
        this.iiop = iIOPRequest;
        this.encodeProtocolIdentifier();
        this.encodeHeader();
        this.encodeMessage();
    }

    public int size() {
        return this.dos.size();
    }

    private void encodeProtocolIdentifier() throws NetworkException {
        try {
            this.dos.write(IIOP.protoId);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }

    private void encodeHeader() throws NetworkException {
        try {
            this.dos.writeByte(this.iiopFormat.getMajorVersion());
            this.dos.writeByte(this.iiopFormat.getMinorVersion());
            this.dos.writeByte(this.iiopFormat.getFlag());
            this.dos.writeByte(this.iiopFormat.getMsgTypeByte());
            this.dos.writeInt(this.iiopFormat.getMsgLen());
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }

    private void encodeMessage() throws NetworkException {
        switch (this.iiop.getMsgType()) {
            case 0: {
                this.encodeRequestMessage();
                break;
            }
            default: {
                throw IIOP.getException(7524);
            }
        }
    }

    private void encodeRequestMessage() throws NetworkException {
        try {
            this.dos.writeInt(this.iiopFormat.getServiceContext());
            this.dos.writeInt(this.iiop.getRequestId());
            this.dos.write(this.iiopFormat.getReply());
            int n = 0;
            this.dos.write(n);
            this.dos.write(n);
            this.dos.write(n);
            IIOPOctetSequence iIOPOctetSequence = new IIOPOctetSequence(this.iiop.getObjectKey(), this.iiop.isBigEndian());
            this.dos.write(iIOPOctetSequence.getIIOPOctetSequence());
            IIOPString iIOPString = new IIOPString(this.iiop.getOperation(), this.iiop.isBigEndian());
            this.dos.write(iIOPString.getIIOPString());
            this.dos.writeInt(this.iiopFormat.getPrincipal());
            this.dos.writeInt(NetByteOrder.htonl(this.iiop.getDataLen(), this.iiop.isBigEndian()));
            this.dos.writeByte(0);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531);
        }
    }
}

