/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import macromedia.sequelink.net.NetMessage;
import macromedia.sequelink.net.NetworkException;

public class IIOP {
    public static final byte[] protoId = new byte[]{71, 73, 79, 80};
    public static final int majorVersion = 1;
    public static final int minorVersion = 1;
    public static final int kMSG_REQUEST = 0;
    public static final int kMSG_REPLY = 1;
    public static final int kMSG_CANCEL = 2;
    public static final int kMSG_CLOSE = 3;
    public static final int kMSG_ERROR = 4;
    public static final int kFRAG_SINGLE = 0;
    public static final int kFRAG_FIRST = 1;
    public static final int kFRAG_MIDDLE = 2;
    public static final int kFRAG_LAST = 3;
    public static final int kREPLY_NO_EXCEPTION = 0;
    public static final int kREPLY_USER_EXCEPTION = 1;
    public static final int kREPLY_SYSTEM_EXCEPTION = 2;
    public static final int kREPLY_LOCATION_FORWARD = 3;
    public static final byte[] defaultObjectKey = new byte[]{73, 73, 79, 80, 58, 115, 108, 120, 58, 58};
    public static final byte[] defaultOperationTarget = new byte[]{83, 83, 80};
    private int msgType;
    private int requestId = 0;
    private boolean reply = true;
    private int fragment = 0;
    private int replyStatus = 0;
    private int dataLen;
    private boolean bigEndian = true;
    private int completionStatus = 0;
    private int vmcid = 0;
    private int vendorException = 0;
    private String exceptionId;
    private byte[] objectKey = defaultObjectKey;
    private byte[] operation = defaultOperationTarget;
    public static final int kOBJECTKEYLEN = 64;
    public static final int kOPERATIONLEN = 32;

    IIOP(int n) throws NetworkException {
        this.validateMsgType(n);
        this.msgType = n;
    }

    IIOP(int n, int n2) throws NetworkException {
        this.validateMsgType(n);
        this.msgType = n;
        this.dataLen = n2;
    }

    IIOP(int n, int n2, int n3) throws NetworkException {
        this.validateMsgType(n);
        this.msgType = n;
        this.requestId = n2;
        this.dataLen = n3;
    }

    IIOP(int n, int n2, int n3, int n4) throws NetworkException {
        this.validateMsgType(n);
        this.validateReplyStatus(n4);
        this.msgType = n;
        this.requestId = n2;
        this.dataLen = n3;
        this.replyStatus = n4;
    }

    public void setFragment(int n) throws NetworkException {
        this.validateFragment(n);
        this.fragment = n;
    }

    public int getFragment() {
        return this.fragment;
    }

    public void setMsgType(int n) throws NetworkException {
        this.validateMsgType(n);
        this.msgType = n;
        if ((n == 0 || n == 1) && this.fragment != 0) {
            this.fragment = 0;
        }
    }

    public int getMsgType() {
        return this.msgType;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int n) throws NetworkException {
        if (n <= 0) {
            NetworkException networkException = IIOP.getException(7525);
            throw networkException;
        }
        this.requestId = n;
    }

    public boolean getReply() {
        return this.reply;
    }

    public int getReplyStatus() {
        return this.replyStatus;
    }

    public void setReplyStatus(int n) throws NetworkException {
        this.validateReplyStatus(n);
        this.replyStatus = n;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public void setDataLen(int n) throws NetworkException {
        if (n <= 0) {
            NetworkException networkException = IIOP.getException(7527);
            throw networkException;
        }
        this.dataLen = n;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void setLittleEndian() {
        this.bigEndian = false;
    }

    public void setBigEndian() {
        this.bigEndian = true;
    }

    public byte[] getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(byte[] byArray) throws NetworkException {
        if (byArray.length > 64) {
            NetworkException networkException = IIOP.getException(7533);
            throw networkException;
        }
        this.objectKey = byArray;
    }

    public byte[] getOperation() {
        return this.operation;
    }

    public void setOperation(byte[] byArray) throws NetworkException {
        if (byArray.length > 32) {
            NetworkException networkException = IIOP.getException(7534);
            throw networkException;
        }
        this.operation = byArray;
    }

    public void log() {
        switch (this.msgType) {
            case 0: {
                System.out.println("IIOP Request " + this.requestId);
                break;
            }
            case 1: {
                System.out.println("IIOP Reply " + this.requestId);
                break;
            }
            case 2: {
                System.out.println("IIOP Cancel");
                break;
            }
            case 3: {
                System.out.println("IIOP Close");
                break;
            }
            case 4: {
                System.out.println("IIOP Error");
            }
        }
    }

    private void validateMsgType(int n) throws NetworkException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                NetworkException networkException = IIOP.getException(7524);
                throw networkException;
            }
        }
    }

    private void validateFragment(int n) throws NetworkException {
        if (this.msgType != 0 && this.msgType != 1) {
            NetworkException networkException = IIOP.getException(7523);
            throw networkException;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                NetworkException networkException = IIOP.getException(7522);
                throw networkException;
            }
        }
    }

    private void validateReplyStatus(int n) throws NetworkException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                NetworkException networkException = IIOP.getException(7521);
                throw networkException;
            }
        }
    }

    public static NetworkException getException(int n) {
        return NetMessage.Message.getNetworkException(n);
    }

    public static NetworkException getException(int n, String string) {
        return NetMessage.Message.getNetworkException(n, string);
    }
}

