/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ctxt.stmt;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import macromedia.sequelink.ctxt.stmt.StatementContext;
import macromedia.sequelink.ssp.CodecPartialBind;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.util.BufferManager;
import macromedia.sequelink.variables.StreamVariable;

public class SequeLinkOutputStream
extends OutputStream {
    private static final int CHUNK = 30000;
    private DiagnosticList diagnosticList;
    private StatementContext stmtCtxt;
    private byte[] data;
    private int bytesWritten;
    private int totalLength;
    private int bytesLeft;
    private int batchLength;
    private boolean firstPacket;
    private CodecPartialBind codec;
    private int indicator;
    private boolean closed;

    public SequeLinkOutputStream(StreamVariable streamVariable, DiagnosticList diagnosticList) throws SQLException {
        this.diagnosticList = diagnosticList;
        this.stmtCtxt = streamVariable.getContext();
        if (streamVariable.isNull()) {
            this.indicator = -1;
            this.totalLength = 0;
        } else {
            this.indicator = 0;
            this.totalLength = streamVariable.getTotalLength();
        }
        this.batchLength = Math.min(this.totalLength, 30000);
        this.bytesLeft = this.totalLength;
        this.firstPacket = true;
        this.codec = this.stmtCtxt.getSsp().getCodecPartialBind(streamVariable, this.stmtCtxt);
        if (this.totalLength == 0) {
            this.send();
        } else {
            this.data = BufferManager.GetBuffer();
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        if (this.bytesLeft == 0) {
            throw new IOException();
        }
        this.data[this.bytesWritten++] = (byte)n;
        if (this.bytesWritten == this.batchLength) {
            try {
                this.send();
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.toString());
            }
            this.bytesLeft -= this.batchLength;
            if (this.bytesLeft > 0) {
                this.batchLength = Math.min(this.bytesLeft, 30000);
                this.bytesWritten = 0;
            } else {
                BufferManager.ReturnBuffer(this.data);
                this.data = null;
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.bytesLeft < n2) {
            throw new IOException();
        }
        while (n2 > 0) {
            int n3 = this.batchLength - this.bytesWritten;
            int n4 = Math.min(n3, n2);
            System.arraycopy(byArray, n, this.data, this.bytesWritten, n4);
            this.bytesWritten += n4;
            if (this.bytesWritten == this.batchLength) {
                try {
                    this.send();
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.toString());
                }
                this.bytesLeft -= this.batchLength;
                if (this.bytesLeft > 0) {
                    this.batchLength = Math.min(this.bytesLeft, 30000);
                    this.bytesWritten = 0;
                } else {
                    BufferManager.ReturnBuffer(this.data);
                    this.data = null;
                }
            }
            n2 -= n4;
            n += n4;
        }
    }

    public void close() throws IOException {
        if (this.data != null) {
            BufferManager.ReturnBuffer(this.data);
            this.data = null;
        }
        this.closed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException(Message.Gen.getPrefixedMessage("msg.is.closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send() throws SQLException {
        try {
            this.stmtCtxt.preCancel();
            int n = this.firstPacket ? this.totalLength : 0;
            this.codec.setTotalSize(n);
            this.codec.setBytesToSend(this.batchLength);
            this.codec.setIndicator(this.indicator);
            this.codec.setData(this.data);
            this.stmtCtxt.add(this.codec);
            this.stmtCtxt.send(this.diagnosticList);
            this.firstPacket = false;
        }
        finally {
            this.stmtCtxt.postCancel();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }
}

