/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.sql.SQLException;
import java.util.StringTokenizer;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseSQLTreeNode;
import macromedia.jdbc.slbase.BaseSQLTreePreOrderTraverser;
import macromedia.jdbc.slbase.BaseSQLTreeTraversalVisitor;
import macromedia.slutil.UtilStringStream;
import macromedia.slutil.UtilTransliterator;

public class BaseSQLStringGenerator
implements BaseSQLTreeTraversalVisitor {
    private boolean findVerbOnly;
    private boolean whereZeroEqualOne;
    int skipUntilBackToLevel = -1;
    private StringBuffer SQL;
    private UtilStringStream stringStream;
    private UtilTransliterator transliterator;
    private BaseExceptions exceptions;

    public String generateSQL(BaseSQLTreeNode baseSQLTreeNode, boolean bl, BaseExceptions baseExceptions) throws SQLException {
        BaseSQLTreePreOrderTraverser baseSQLTreePreOrderTraverser = new BaseSQLTreePreOrderTraverser();
        this.findVerbOnly = bl;
        this.SQL = new StringBuffer();
        baseSQLTreePreOrderTraverser.setExceptions(baseExceptions);
        baseSQLTreePreOrderTraverser.setVisitor(this);
        baseSQLTreePreOrderTraverser.traverse(baseSQLTreeNode);
        try {
            if (bl) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.SQL.toString(), " \t\n\r\f(");
                String string = stringTokenizer.nextToken();
                if (string.toUpperCase().startsWith("SELECT")) {
                    string = "select";
                } else if (string.toUpperCase().startsWith("CREATE")) {
                    string = string + " " + stringTokenizer.nextToken();
                }
                return string;
            }
        }
        catch (Exception exception) {
            throw baseExceptions.getException(6018);
        }
        return this.SQL.toString();
    }

    public void generateSQL(BaseSQLTreeNode baseSQLTreeNode, UtilStringStream utilStringStream, UtilTransliterator utilTransliterator, BaseExceptions baseExceptions) throws SQLException {
        BaseSQLTreePreOrderTraverser baseSQLTreePreOrderTraverser = new BaseSQLTreePreOrderTraverser();
        this.stringStream = utilStringStream;
        this.transliterator = utilTransliterator;
        this.exceptions = baseExceptions;
        baseSQLTreePreOrderTraverser.setExceptions(baseExceptions);
        baseSQLTreePreOrderTraverser.setVisitor(this);
        baseSQLTreePreOrderTraverser.traverse(baseSQLTreeNode);
    }

    public String generateSQLWhereZeroEqualOne(BaseSQLTreeNode baseSQLTreeNode, BaseExceptions baseExceptions) throws SQLException {
        this.whereZeroEqualOne = true;
        return this.generateSQL(baseSQLTreeNode, false, baseExceptions);
    }

    public boolean visit(BaseSQLTreeNode baseSQLTreeNode, int n) throws SQLException {
        boolean bl;
        block17: {
            bl = true;
            if (this.whereZeroEqualOne) {
                if (baseSQLTreeNode.type == 1009 && this.skipUntilBackToLevel == -1) {
                    block16: {
                        if (this.SQL != null) {
                            this.SQL.append(" where 0 = 1 ");
                        } else {
                            try {
                                this.stringStream.write(" where 0 = 1 ", this.transliterator);
                            }
                            catch (Exception exception) {
                                if (exception instanceof SQLException) break block16;
                                throw this.exceptions.getException(exception);
                            }
                        }
                    }
                    this.skipUntilBackToLevel = n;
                } else {
                    if (this.skipUntilBackToLevel >= n) {
                        this.skipUntilBackToLevel = -1;
                    }
                    if (this.skipUntilBackToLevel == -1 && baseSQLTreeNode.value != null) {
                        this.SQL.append(baseSQLTreeNode.value);
                    }
                }
            } else if (baseSQLTreeNode.value != null) {
                if (this.SQL != null) {
                    this.SQL.append(baseSQLTreeNode.value);
                } else {
                    try {
                        this.stringStream.write(baseSQLTreeNode.value, this.transliterator);
                    }
                    catch (Exception exception) {
                        if (exception instanceof SQLException) break block17;
                        throw this.exceptions.getException(exception);
                    }
                }
            }
        }
        if (this.findVerbOnly && baseSQLTreeNode.value != null && baseSQLTreeNode.type != 1020 && !baseSQLTreeNode.value.equalsIgnoreCase("create") && !baseSQLTreeNode.value.equalsIgnoreCase("(")) {
            bl = false;
        }
        return bl;
    }
}

