/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import macromedia.jdbc.slbase.BaseStatement;

public class BaseQueryTimeoutEnforcer
extends Thread {
    private BaseStatement statement;
    private int timeout = 0;
    private boolean continueRunning = true;
    private volatile boolean waitingForTimeout = false;

    BaseQueryTimeoutEnforcer() {
        this.setDaemon(true);
        this.setName("DataDirect Connect Query Timeout-Thread");
        this.start();
    }

    public synchronized void run() {
        while (this.continueRunning) {
            if (this.timeout == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.waitingForTimeout = true;
            try {
                this.wait(this.timeout * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.timeout != 0) {
                try {
                    this.statement.timeoutEnforcerCanceledExecution = true;
                    this.statement.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timeout = 0;
            }
            this.waitingForTimeout = false;
        }
    }

    synchronized void startTimeoutPeriod(BaseStatement baseStatement, int n) {
        this.statement = baseStatement;
        this.timeout = n;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetTimeoutPeriod() {
        BaseQueryTimeoutEnforcer baseQueryTimeoutEnforcer = this;
        synchronized (baseQueryTimeoutEnforcer) {
            this.timeout = 0;
            this.statement = null;
            this.notify();
        }
        while (this.waitingForTimeout) {
        }
    }

    synchronized void exit() {
        this.continueRunning = false;
        this.timeout = 0;
        this.notify();
    }
}

