/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplClob;
import macromedia.jdbc.slbase.BaseImplClobCached;
import macromedia.slutil.UtilBoyerMooreSearchStrategy;
import macromedia.slutil.UtilBruteForceSearchStrategy;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilSearchStrategy;

public class BaseImplClobSearchable
extends BaseImplClobCached {
    private UtilSearchStrategy searchStrategy = new UtilBoyerMooreSearchStrategy();

    public BaseImplClobSearchable(BaseImplClob baseImplClob, BaseExceptions baseExceptions) {
        super(baseImplClob, baseExceptions);
    }

    public long find(String string, long l) throws SQLException {
        byte[] byArray;
        UtilSearchStrategy utilSearchStrategy = this.searchStrategy;
        if (string.length() == 1) {
            utilSearchStrategy = new UtilBruteForceSearchStrategy();
        }
        if (l > Integer.MAX_VALUE) {
            throw this.exceptions.getException(6068);
        }
        this.fetchDataToCache(l, new Long(this.getLength() - (l - 1L)).intValue());
        String string2 = BaseImplClob.getEncodingName(this.getCharacterEncoding());
        int n = BaseImplClob.getBytesPerChar(this);
        int n2 = new Long(l).intValue() * n;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw this.exceptions.getException(unsupportedEncodingException);
        }
        try {
            int n3 = utilSearchStrategy.find(this.getCachedData(), byArray, n2);
            if (n3 > 0) {
                n3 /= n;
            }
            return n3;
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public boolean supportsSearch() {
        return true;
    }
}

