/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import macromedia.jdbc.slbase.BaseBlob;
import macromedia.jdbc.slbase.BaseCharacterStreamWrapper;
import macromedia.jdbc.slbase.BaseClob;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseDoubleConversionConstants;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplBlob;
import macromedia.jdbc.slbase.BaseImplBlobEmulated;
import macromedia.jdbc.slbase.BaseImplClob;
import macromedia.jdbc.slbase.BaseImplClobEmulated;
import macromedia.jdbc.slbase.BaseInputStreamWrapper;
import macromedia.jdbc.slbase.BaseIntegerStringConstants;
import macromedia.jdbc.slbase.BaseTimestamp;
import macromedia.slutil.UtilASCIIInputStreamToCharacterReader;
import macromedia.slutil.UtilBinaryToASCIIInputStream;
import macromedia.slutil.UtilCharacterReaderToASCIIInputStream;
import macromedia.slutil.UtilCharacterReaderToUCS2InputStream;
import macromedia.slutil.UtilDataConversions;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilJDKVersionChecker;
import macromedia.slutil.UtilSmallDecimal;
import macromedia.slutil.UtilStringFunctions;
import macromedia.slutil.UtilTransliterator;
import macromedia.slutil.UtilUCS2InputStreamToCharacterReader;

public class BaseData {
    public static final int UNKNOWN_DATA_OBJECT = 0;
    public static final int BYTE = 1;
    public static final int BYTE_ARRAY = 2;
    public static final int SHORT = 3;
    public static final int INTEGER = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BIGDECIMAL = 8;
    public static final int BOOLEAN = 9;
    public static final int STRING = 10;
    public static final int DATE = 11;
    public static final int TIME = 12;
    public static final int TIMESTAMP = 13;
    public static final int BINARYINPUTSTREAM = 14;
    public static final int ASCIIINPUTSTREAM = 15;
    public static final int UTF8INPUTSTREAM = 16;
    public static final int UCS2INPUTSTREAM = 17;
    public static final int CHARACTERSTREAMREADER = 18;
    public static final int BLOB = 19;
    public static final int CLOB = 20;
    public static final int SMALLDECIMAL = 21;
    public static final int NATIVE_TYPE_BYTE_BASE = 100;
    public static final int SQLSERVER_UNIQUEIDENTIFIER = 101;
    public static final int SQLSERVER_DATETIME = 102;
    public static final int SQLSERVER_SMALLDATETIME = 103;
    public static final int SYBASE_DATETIME = 104;
    public static final int SYBASE_SHORTDATE = 105;
    public static final int SYBASE_DATE = 106;
    public static final int SYBASE_TIME = 107;
    public static final int ORACLE_DATE = 108;
    public static final int ORACLE_TIMESTAMP = 109;
    public static final int ORACLE_TIMESTAMP_WITH_TIMEZONE = 110;
    public static final int ORACLE_TIMESTAMP_WITH_LOCAL_TIMEZONE = 111;
    public static final int NATIVE_TYPE_STRING_BASE = 200;
    public static final int DB2_DATE = 201;
    public static final int DB2_TIME = 202;
    public static final int DB2_TIMESTAMP = 203;
    public static final int MYSQL_DATE = 204;
    public static final int MYSQL_TIME = 205;
    public static final int MYSQL_TIMESTAMP = 206;
    private static final int DEFAULT_CHUNK_LEN = 10240;
    private static final int MAX_CHUNK_LEN = Integer.MAX_VALUE;
    public BaseConnection connection;
    public int type;
    public Object data;
    private int nativeDataLen;
    private int oracleLTZHours;
    private int oracleLTZMinutes;
    private int oracleTZScale;
    private boolean oracleFetchTSWTZasTimestamp;
    static final BigDecimal bdMaxInt = new BigDecimal(Integer.toString(Integer.MAX_VALUE));
    static final BigDecimal bdMinInt = new BigDecimal(Integer.toString(Integer.MIN_VALUE));
    static final BigDecimal bdMaxLong = new BigDecimal(Long.toString(Long.MAX_VALUE));
    static final BigDecimal bdMinLong = new BigDecimal(Long.toString(Long.MIN_VALUE));
    static final BigDecimal bdMaxShort = new BigDecimal(Long.toString(32767L));
    static final BigDecimal bdMinShort = new BigDecimal(Long.toString(-32768L));
    static final BigDecimal bdMaxByte = new BigDecimal(Long.toString(127L));
    static final BigDecimal bdMinByte = new BigDecimal(Long.toString(-128L));
    public boolean booleanValue;
    public byte byteValue;
    public short shortValue;
    public int intValue;
    public long longValue;
    public float floatValue;
    public double doubleValue;
    public boolean isNull;
    private boolean needWrapper = true;
    public static final char[] NEGATIVE_INFINITY = new char[]{'-', 'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
    public static final char[] POSITIVE_INFINITY = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
    public static final char[] NaN = new char[]{'N', 'a', 'N'};
    static final long MaxValue = 0xCCCCCCCCCCCCCCCL;
    public static final char[] DigitHundreds = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    public static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    public static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    char[] buf = null;
    private Calendar s_calendar = null;
    static int[] scalingFactors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};

    public BaseData(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.setNull(0);
    }

    public BaseData(int n, Object object, BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.setData(n, object);
    }

    public BaseData(Object object, BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.setData(object);
    }

    public int getType() {
        return this.type;
    }

    public void populate(BaseData baseData) {
        this.isNull = baseData.isNull;
        this.type = baseData.type;
        this.intValue = baseData.intValue;
        this.byteValue = baseData.byteValue;
        this.booleanValue = baseData.booleanValue;
        this.shortValue = baseData.shortValue;
        this.longValue = baseData.longValue;
        this.floatValue = baseData.floatValue;
        this.doubleValue = baseData.doubleValue;
        this.data = baseData.data;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public static boolean isVariableLengthType(int n) {
        switch (n) {
            case -9: 
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 93: {
                return true;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: {
                return false;
            }
        }
        return false;
    }

    public static int[] getInfoForSQLType(int n) {
        int[] nArray = new int[]{-1, -1, -1, -1};
        switch (n) {
            case -5: {
                nArray[0] = 20;
                nArray[1] = 19;
                nArray[2] = 0;
                nArray[3] = 5;
                break;
            }
            case -7: 
            case 16: {
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[2] = -1;
                nArray[3] = 9;
                break;
            }
            case 91: {
                nArray[0] = 10;
                nArray[1] = 10;
                nArray[2] = 0;
                nArray[3] = 11;
                break;
            }
            case 2: 
            case 3: {
                nArray[3] = 8;
                break;
            }
            case 6: 
            case 8: {
                nArray[0] = 22;
                nArray[1] = 15;
                nArray[2] = 0;
                nArray[3] = 7;
                break;
            }
            case 4: {
                nArray[0] = 11;
                nArray[1] = 10;
                nArray[2] = 0;
                nArray[3] = 4;
                break;
            }
            case 5: {
                nArray[0] = 6;
                nArray[1] = 5;
                nArray[2] = 0;
                nArray[3] = 3;
                break;
            }
            case -6: {
                nArray[0] = 4;
                nArray[1] = 3;
                nArray[2] = 0;
                nArray[3] = 1;
                break;
            }
            case 7: {
                nArray[0] = 13;
                nArray[1] = 7;
                nArray[2] = 0;
                nArray[3] = 6;
                break;
            }
            case 92: {
                nArray[0] = 18;
                nArray[1] = 18;
                nArray[2] = 9;
                nArray[3] = 12;
                break;
            }
            case 93: {
                nArray[0] = 29;
                nArray[1] = 29;
                nArray[2] = 9;
                nArray[3] = 13;
                break;
            }
            case -2: {
                nArray[3] = 2;
                break;
            }
            case -8: 
            case 1: {
                nArray[3] = 10;
                break;
            }
            case -4: {
                nArray[3] = 14;
                break;
            }
            case -1: {
                nArray[3] = 15;
                break;
            }
            case -3: {
                nArray[3] = 2;
                break;
            }
            case -9: 
            case 12: {
                nArray[3] = 10;
                break;
            }
            case 2004: {
                nArray[3] = 19;
                break;
            }
            case -10: 
            case 2005: {
                nArray[3] = 20;
                break;
            }
        }
        return nArray;
    }

    static String mapJDBCTypeToJavaObjectTypeName(int n) {
        String string = null;
        switch (n) {
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                string = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                string = "java.math.BigDecimal";
                break;
            }
            case -7: 
            case 16: {
                string = "java.lang.Boolean";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = "java.lang.Integer";
                break;
            }
            case -5: {
                string = "java.lang.Long";
                break;
            }
            case 7: {
                string = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "byte[]";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
                break;
            }
            case -10: 
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            case 2004: {
                string = "java.sql.Blob";
                break;
            }
            case 2003: {
                string = "java.sql.Array";
                break;
            }
            case 2006: {
                string = "java.sql.Ref";
                break;
            }
            case 2002: {
                string = "java.sql.Struct";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static int mapJDBCTypeToJavaObjectType(int n) {
        int n2 = 0;
        switch (n) {
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n2 = 10;
                break;
            }
            case 2: 
            case 3: {
                n2 = 8;
                break;
            }
            case -7: 
            case 16: {
                n2 = 9;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                n2 = 4;
                break;
            }
            case -5: {
                n2 = 5;
                break;
            }
            case 7: {
                n2 = 6;
                break;
            }
            case 6: 
            case 8: {
                n2 = 7;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                n2 = 2;
                break;
            }
            case 91: {
                n2 = 11;
                break;
            }
            case 92: {
                n2 = 12;
                break;
            }
            case 93: {
                n2 = 13;
                break;
            }
            case 2004: {
                n2 = 19;
                break;
            }
            case -10: 
            case 2005: {
                n2 = 20;
                break;
            }
        }
        return n2;
    }

    public void setASCIIStream(InputStream inputStream) {
        this.type = 15;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public void setBigDecimal(BigDecimal bigDecimal) {
        this.type = 8;
        if (bigDecimal == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = bigDecimal;
        }
    }

    public void setBinaryStream(InputStream inputStream) {
        this.type = 14;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public void setBlob(BaseImplBlob baseImplBlob) {
        this.type = 19;
        if (baseImplBlob == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = baseImplBlob;
        }
    }

    public void setBoolean(boolean bl) {
        this.booleanValue = bl;
        this.type = 9;
        this.isNull = false;
        this.data = null;
    }

    public void setByte(byte by) {
        this.byteValue = by;
        this.type = 1;
        this.isNull = false;
        this.data = null;
    }

    public void setBytes(byte[] byArray) {
        this.type = 2;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = byArray;
        }
    }

    public void setNativeBytes(byte[] byArray, int n) {
        this.type = n;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
            this.nativeDataLen = 0;
        } else {
            this.isNull = false;
            this.data = byArray;
            this.nativeDataLen = byArray.length;
        }
    }

    public void setNativeBytes(byte[] byArray, int n, int n2) {
        this.type = n2;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
            this.nativeDataLen = 0;
        } else {
            this.isNull = false;
            this.data = byArray;
            this.nativeDataLen = n;
        }
    }

    public void setNativeOracleTimestampWithLocalTimeZone(byte[] byArray, int n, int n2, int n3) {
        this.type = 111;
        this.oracleLTZHours = n2;
        this.oracleLTZMinutes = n3;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
            this.nativeDataLen = 0;
        } else {
            this.isNull = false;
            this.data = byArray;
            this.nativeDataLen = n;
        }
    }

    public int getOracleTZHours() {
        return this.oracleLTZHours;
    }

    public void setOracleTZHours(int n) {
        this.oracleLTZHours = n;
    }

    public int getOracleTZMinutes() {
        return this.oracleLTZMinutes;
    }

    public void setOracleTZMinutes(int n) {
        this.oracleLTZMinutes = n;
    }

    public int getOracleTZScale() {
        return this.oracleTZScale;
    }

    public void setOracleTZScale(int n) {
        this.oracleTZScale = n;
    }

    public boolean getOracleFetchTSWTZasTimestamp() {
        return this.oracleFetchTSWTZasTimestamp;
    }

    public void setOracleFetchTSWTZasTimestamp(boolean bl) {
        this.oracleFetchTSWTZasTimestamp = bl;
    }

    public void setNativeOracleTimestampWithTimeZone(byte[] byArray, int n, int n2, boolean bl) {
        this.type = 110;
        this.oracleTZScale = n2;
        this.oracleFetchTSWTZasTimestamp = bl;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
            this.nativeDataLen = 0;
        } else {
            this.isNull = false;
            this.data = byArray;
            this.nativeDataLen = n;
        }
    }

    public void setNativeString(String string, int n) {
        this.type = n;
        if (string == null) {
            this.isNull = true;
            this.data = null;
            this.nativeDataLen = 0;
        } else {
            this.isNull = false;
            this.data = string;
            this.nativeDataLen = string.length();
        }
    }

    public void setCharacterStreamReader(Reader reader) {
        this.type = 18;
        if (reader == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = reader;
        }
    }

    public void setClob(BaseImplClob baseImplClob) {
        this.type = 20;
        if (baseImplClob == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = baseImplClob;
        }
    }

    public void setData(int n, Object object) {
        this.type = n;
        if (object == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            switch (this.type) {
                case 4: {
                    this.intValue = (Integer)object;
                    this.data = null;
                    break;
                }
                case 1: {
                    this.byteValue = (Byte)object;
                    this.data = null;
                    break;
                }
                case 9: {
                    this.booleanValue = (Boolean)object;
                    this.data = null;
                    break;
                }
                case 3: {
                    this.shortValue = (Short)object;
                    this.data = null;
                    break;
                }
                case 5: {
                    this.longValue = (Long)object;
                    this.data = null;
                    break;
                }
                case 6: {
                    this.floatValue = ((Float)object).floatValue();
                    this.data = null;
                    break;
                }
                case 7: {
                    this.doubleValue = (Double)object;
                    this.data = null;
                    break;
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    this.data = object;
                    this.nativeDataLen = ((byte[])object).length;
                    break;
                }
                default: {
                    this.data = object;
                }
            }
        }
    }

    public void setData(Object object) {
        this.setData(BaseData.getJavaObjectType(object, 0), object);
    }

    public void setDate(Date date) {
        this.type = 11;
        if (date == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = date;
        }
    }

    public void setDouble(double d) {
        this.doubleValue = d;
        this.type = 7;
        this.isNull = false;
        this.data = null;
    }

    public void setFloat(float f) {
        this.floatValue = f;
        this.type = 6;
        this.isNull = false;
        this.data = null;
    }

    public void setInteger(int n) {
        this.intValue = n;
        this.type = 4;
        this.isNull = false;
        this.data = null;
    }

    public void setLong(long l) {
        this.longValue = l;
        this.type = 5;
        this.isNull = false;
        this.data = null;
    }

    public void setNull(int n) {
        this.isNull = true;
        this.type = n;
        this.data = null;
    }

    public void setShort(short s) {
        this.shortValue = s;
        this.type = 3;
        this.isNull = false;
        this.data = null;
    }

    public void setSmallDecimal(UtilSmallDecimal utilSmallDecimal) {
        this.type = 21;
        if (utilSmallDecimal == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = utilSmallDecimal;
        }
    }

    public void setString(String string) {
        this.type = 10;
        if (string == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = string;
        }
    }

    public void setTime(Time time) {
        this.type = 12;
        if (time == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = time;
        }
    }

    public void setTimestamp(BaseTimestamp baseTimestamp) {
        this.type = 13;
        if (baseTimestamp == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = baseTimestamp;
        }
    }

    public void setUCS2InputStream(InputStream inputStream) {
        this.type = 17;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public void setUTF8InputStream(InputStream inputStream) {
        this.type = 16;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public static int getJavaObjectType(Object object, int n) {
        int n2 = 0;
        if (object == null) {
            n2 = n == 0 ? 10 : BaseData.mapJDBCTypeToJavaObjectType(n);
        } else if (object instanceof Integer) {
            n2 = 4;
        } else if (object instanceof Byte) {
            n2 = 1;
        } else if (object instanceof Short) {
            n2 = 3;
        } else if (object instanceof Long) {
            n2 = 5;
        } else if (object instanceof Float) {
            n2 = 6;
        } else if (object instanceof Double) {
            n2 = 7;
        } else if (object instanceof BigDecimal) {
            n2 = 8;
        } else if (object instanceof UtilSmallDecimal) {
            n2 = 21;
        } else if (object instanceof Boolean) {
            n2 = 9;
        } else if (object instanceof String) {
            n2 = 10;
        } else if (object instanceof Date) {
            n2 = 11;
        } else if (object instanceof Time) {
            n2 = 12;
        } else if (object instanceof BaseTimestamp || object instanceof Timestamp) {
            n2 = 13;
        } else if (object instanceof Blob || object instanceof BaseImplBlob) {
            n2 = 19;
        } else if (object instanceof Clob || object instanceof BaseImplClob) {
            n2 = 20;
        } else if (object instanceof Reader) {
            n2 = 18;
        } else if (object instanceof InputStream) {
            switch (n) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    n2 = 14;
                    break;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    n2 = 15;
                }
            }
        } else {
            String string = object.getClass().getName();
            if (string.equals("[B")) {
                n2 = 2;
            }
        }
        return n2;
    }

    static boolean isStreamed(int n) {
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static byte[] stringToBytes(String string, UtilTransliterator utilTransliterator, BaseExceptions baseExceptions) throws SQLException {
        byte[] byArray = null;
        if (utilTransliterator != null) {
            try {
                byArray = utilTransliterator.encode(string);
            }
            catch (UtilException utilException) {
                throw baseExceptions.getException(6024);
            }
        } else {
            int n = string.length();
            if (n % 2 != 0) {
                throw baseExceptions.getException(6032, "22018");
            }
            byte[] byArray2 = new byte[n / 2];
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                byte by;
                char c = string.charAt(i);
                if (c >= '0' && c <= '9') {
                    by = (byte)(c - 48);
                } else if (c >= 'a' && c <= 'f') {
                    by = (byte)(c - 97 + 10);
                } else if (c >= 'A' && c <= 'F') {
                    by = (byte)(c - 65 + 10);
                } else {
                    throw baseExceptions.getException(6032, "22018");
                }
                if (bl) {
                    byArray2[i / 2] = (byte)(by << 4);
                    bl = false;
                    continue;
                }
                int n2 = i / 2;
                byArray2[n2] = (byte)(byArray2[n2] + by);
                bl = true;
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public static int compare(BaseData baseData, BaseData baseData2, int n, boolean bl, BaseExceptions baseExceptions) throws SQLException {
        int n2 = 0;
        switch (n) {
            case 10: {
                String string = baseData.getString(-1, baseExceptions);
                String string2 = baseData2.getString(-1, baseExceptions);
                if (string == string2) {
                    return 0;
                }
                if (string == null) {
                    return 1;
                }
                if (string2 == null) {
                    return -1;
                }
                if (bl) {
                    n2 = UtilStringFunctions.CompareStrings(string, string2);
                    break;
                }
                n2 = UtilStringFunctions.CompareStringsAlpha(string, string2);
                break;
            }
            case 4: {
                int n3 = baseData.getInteger(baseExceptions);
                int n4 = baseData2.getInteger(baseExceptions);
                if (n3 > n4) {
                    n2 = 1;
                    break;
                }
                if (n3 < n4) {
                    n2 = -1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: {
                short s = baseData.getShort(baseExceptions);
                short s2 = baseData2.getShort(baseExceptions);
                if (s > s2) {
                    n2 = 1;
                    break;
                }
                if (s < s2) {
                    n2 = -1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: {
                boolean bl2 = baseData.getBoolean(baseExceptions);
                boolean bl3 = baseData2.getBoolean(baseExceptions);
                n2 = bl2 && !bl3 ? 1 : (!bl2 && bl3 ? -1 : 0);
            }
        }
        return n2;
    }

    public Object getObject() {
        if (this.isNull) {
            return null;
        }
        switch (this.type) {
            case 4: {
                return new Integer(this.intValue);
            }
            case 1: {
                return new Byte(this.byteValue);
            }
            case 9: {
                return new Boolean(this.booleanValue);
            }
            case 3: {
                return new Short(this.shortValue);
            }
            case 5: {
                return new Long(this.longValue);
            }
            case 6: {
                return new Float(this.floatValue);
            }
            case 7: {
                return new Double(this.doubleValue);
            }
            case 101: {
                return this.sqlserverUniqueidentifierToString();
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return this.sqlserverDateTimeToTimestamp();
            }
            case 106: {
                return this.sybaseDatetoDate();
            }
            case 107: {
                return this.sybaseTimeToTimeStamp();
            }
            case 201: 
            case 204: {
                return Date.valueOf((String)this.data);
            }
            case 202: 
            case 205: {
                return Time.valueOf((String)this.data);
            }
            case 203: 
            case 206: {
                return BaseTimestamp.valueOf((String)this.data);
            }
            case 108: {
                return this.oracleDateToDate();
            }
            case 109: {
                return this.oracleTimestampToTimestamp(null);
            }
            case 110: {
                return this.oracleTimestampWithTimeZoneToTimestamp(null, this.oracleFetchTSWTZasTimestamp);
            }
            case 111: {
                return this.oracleTimestampWithLocalTimeZoneToTimestamp();
            }
        }
        return this.data;
    }

    public Object getObject(int n, int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        Object object = null;
        switch (n) {
            case 1: {
                object = new Byte(this.getByte(baseExceptions));
                break;
            }
            case 9: {
                object = new Boolean(this.getBoolean(baseExceptions));
                break;
            }
            case 4: {
                object = new Integer(this.getInteger(baseExceptions));
                break;
            }
            case 3: {
                object = new Short(this.getShort(baseExceptions));
                break;
            }
            case 5: {
                object = new Long(this.getLong(baseExceptions));
                break;
            }
            case 6: {
                object = new Float(this.getFloat(baseExceptions));
                break;
            }
            case 7: {
                object = new Double(this.getDouble(baseExceptions));
                break;
            }
            case 10: {
                object = this.getString(n2, baseExceptions);
                break;
            }
            case 2: {
                object = this.getBytes(n2, baseExceptions);
                break;
            }
            case 19: {
                object = this.getBlob(baseConnection, baseExceptions);
                break;
            }
            case 20: {
                object = this.getClob(baseConnection, baseExceptions);
                break;
            }
            case 8: 
            case 21: {
                object = this.getBigDecimal(baseExceptions);
                break;
            }
            case 11: 
            case 201: 
            case 204: {
                object = this.getDate(baseExceptions);
                break;
            }
            case 12: 
            case 202: 
            case 205: {
                object = this.getTime(baseExceptions);
                break;
            }
            case 13: 
            case 203: 
            case 206: {
                object = this.getTimestamp(baseExceptions).getTimestamp();
                break;
            }
            case 101: {
                object = this.sqlserverUniqueidentifierToString();
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                object = this.sqlserverDateTimeToTimestamp().getTimestamp();
                break;
            }
            case 106: {
                object = this.sybaseDatetoDate();
                break;
            }
            case 107: {
                object = this.sybaseTimeToTimeStamp().getTimestamp();
                break;
            }
            case 108: {
                object = this.oracleDateToDate();
                break;
            }
            case 109: {
                object = this.oracleTimestampToTimestamp(null).getTimestamp();
                break;
            }
            case 110: {
                object = this.oracleTimestampWithTimeZoneToTimestamp(null, this.oracleFetchTSWTZasTimestamp);
            }
            case 111: {
                object = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                break;
            }
            default: {
                object = this.data;
            }
        }
        return object;
    }

    public InputStream getASCIIStreamNoConvert() {
        return (InputStream)this.data;
    }

    public InputStream getASCIIStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n2 = -1;
            switch (this.type) {
                case 15: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 14: {
                    inputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    break;
                }
                case 2: {
                    inputStream = new UtilBinaryToASCIIInputStream(new ByteArrayInputStream((byte[])this.data));
                    n2 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    inputStream = UtilDataConversions.stringToASCIIInputStream(string);
                    n2 = string.length();
                    break;
                }
                case 10: {
                    inputStream = UtilDataConversions.stringToASCIIInputStream((String)this.data);
                    n2 = ((String)this.data).length();
                    break;
                }
                case 110: {
                    String string = (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
                    inputStream = UtilDataConversions.stringToASCIIInputStream(string);
                    n2 = string.length();
                    break;
                }
                case 18: {
                    inputStream = new UtilCharacterReaderToASCIIInputStream((Reader)this.data);
                    break;
                }
                case 20: {
                    inputStream = this.getClob(baseConnection, baseExceptions).getAsciiStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getASCIIStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions, boolean bl) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n2 = -1;
            switch (this.type) {
                case 15: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 14: {
                    inputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    break;
                }
                case 2: {
                    inputStream = new UtilBinaryToASCIIInputStream(new ByteArrayInputStream((byte[])this.data));
                    n2 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    inputStream = UtilDataConversions.stringToASCIIInputStream(string);
                    n2 = string.length();
                    break;
                }
                case 10: {
                    inputStream = UtilDataConversions.stringToASCIIInputStream((String)this.data);
                    n2 = ((String)this.data).length();
                    break;
                }
                case 110: {
                    String string = (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
                    inputStream = UtilDataConversions.stringToASCIIInputStream(string);
                    n2 = string.length();
                    break;
                }
                case 18: {
                    inputStream = new UtilCharacterReaderToASCIIInputStream((Reader)this.data);
                    break;
                }
                case 20: {
                    Clob clob = this.getClob(baseConnection, baseExceptions);
                    if (clob instanceof BaseClob) {
                        inputStream = ((BaseClob)clob).getAsciiStream(bl);
                        break;
                    }
                    inputStream = clob.getAsciiStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public BigDecimal getBigDecimalNoConvert() {
        return (BigDecimal)this.data;
    }

    public BigDecimal getBigDecimal(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            BigDecimal bigDecimal = null;
            switch (this.type) {
                case 8: {
                    bigDecimal = (BigDecimal)this.data;
                    break;
                }
                case 21: {
                    BigInteger bigInteger = new BigInteger(((UtilSmallDecimal)this.data).toByteArray());
                    bigDecimal = new BigDecimal(bigInteger, ((UtilSmallDecimal)this.data).getScale());
                    break;
                }
                case 10: {
                    bigDecimal = new BigDecimal(((String)this.data).trim());
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    bigDecimal = new BigDecimal(string.trim());
                    break;
                }
                case 7: {
                    if (UtilJDKVersionChecker.getJVMVersion() >= 1.3f) {
                        bigDecimal = new BigDecimal(Double.toString(this.doubleValue));
                        break;
                    }
                    bigDecimal = new BigDecimal(this.doubleValue);
                    break;
                }
                case 6: {
                    if (UtilJDKVersionChecker.getJVMVersion() >= 1.3f) {
                        bigDecimal = new BigDecimal(Float.toString(this.floatValue));
                        break;
                    }
                    bigDecimal = new BigDecimal(this.floatValue);
                    break;
                }
                case 1: {
                    bigDecimal = new BigDecimal((double)this.byteValue);
                    break;
                }
                case 3: {
                    bigDecimal = new BigDecimal((double)this.shortValue);
                    break;
                }
                case 5: {
                    byte[] byArray = new byte[]{(byte)(this.longValue >>> 56), (byte)(this.longValue >>> 48), (byte)(this.longValue >>> 40), (byte)(this.longValue >>> 32), (byte)(this.longValue >>> 24), (byte)(this.longValue >>> 16), (byte)(this.longValue >>> 8), (byte)this.longValue};
                    bigDecimal = new BigDecimal(new BigInteger(byArray));
                    break;
                }
                case 4: {
                    bigDecimal = new BigDecimal((double)this.intValue);
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        bigDecimal = new BigDecimal(1.0);
                        break;
                    }
                    bigDecimal = new BigDecimal(0.0);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return bigDecimal;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public BigDecimal getBigDecimal(int n, BaseExceptions baseExceptions) throws SQLException {
        try {
            BigDecimal bigDecimal = this.getBigDecimal(baseExceptions);
            if (bigDecimal != null) {
                try {
                    bigDecimal = bigDecimal.setScale(n, 7);
                }
                catch (ArithmeticException arithmeticException) {
                    bigDecimal = bigDecimal.setScale(n, 4);
                }
            }
            return bigDecimal;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Blob getBlobNoConvert() {
        return (Blob)this.data;
    }

    public Blob getBlob(BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            if (this.type == 19) {
                return null;
            }
            this.getBytes(0, baseExceptions);
            return null;
        }
        try {
            Blob blob = null;
            switch (this.type) {
                case 19: {
                    if (this.data instanceof BaseImplBlob) {
                        this.data = new BaseBlob((BaseImplBlob)this.data, baseConnection, baseExceptions);
                    }
                    blob = (Blob)this.data;
                    break;
                }
                default: {
                    this.needWrapper = false;
                    InputStream inputStream = this.getBinaryStream(-1, baseConnection, baseExceptions);
                    this.needWrapper = true;
                    BaseImplBlobEmulated baseImplBlobEmulated = new BaseImplBlobEmulated(baseExceptions, inputStream);
                    blob = new BaseBlob(baseImplBlobEmulated, baseConnection, baseExceptions);
                }
            }
            return blob;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public boolean getBooleanNoConvert() {
        return this.booleanValue;
    }

    public boolean getBoolean(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return false;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return false;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            boolean bl = false;
            switch (this.type) {
                case 9: {
                    bl = this.booleanValue;
                    break;
                }
                case 10: 
                case 15: 
                case 17: 
                case 18: {
                    String string;
                    if (this.type == 10) {
                        string = ((String)this.data).trim();
                    } else {
                        String string2 = this.getString(-1, baseExceptions);
                        string = string2.trim();
                    }
                    if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1")) {
                        bl = true;
                        break;
                    }
                    if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0")) {
                        bl = false;
                        break;
                    }
                    throw baseExceptions.getException(6024);
                }
                case 1: {
                    bl = this.byteValue != 0;
                    break;
                }
                case 3: {
                    bl = this.shortValue != 0;
                    break;
                }
                case 4: {
                    bl = this.intValue != 0;
                    break;
                }
                case 5: {
                    bl = this.longValue != 0L;
                    break;
                }
                case 6: {
                    bl = (double)this.floatValue != 0.0;
                    break;
                }
                case 7: {
                    bl = this.doubleValue != 0.0;
                    break;
                }
                case 8: {
                    bl = ((BigDecimal)this.data).doubleValue() != 0.0;
                    break;
                }
                case 21: {
                    bl = ((UtilSmallDecimal)this.data).doubleValue() != 0.0;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return bl;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public byte getByteNoConvert() {
        return this.byteValue;
    }

    public byte getByte(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            byte by = 0;
            switch (this.type) {
                case 1: {
                    by = this.byteValue;
                    break;
                }
                case 10: {
                    by = Byte.parseByte(((String)this.data).trim());
                    break;
                }
                case 3: {
                    if (this.shortValue > 127 || this.shortValue < -128) {
                        throw baseExceptions.getException(6104);
                    }
                    by = (byte)this.shortValue;
                    break;
                }
                case 4: {
                    if (this.intValue > 127 || this.intValue < -128) {
                        throw baseExceptions.getException(6104);
                    }
                    by = (byte)this.intValue;
                    break;
                }
                case 5: {
                    if (this.longValue > 127L || this.longValue < -128L) {
                        throw baseExceptions.getException(6104);
                    }
                    by = (byte)this.longValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 127.0f || this.floatValue < -128.0f) {
                        throw baseExceptions.getException(6104);
                    }
                    by = (byte)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 127.0 || this.doubleValue < -128.0) {
                        throw baseExceptions.getException(6104);
                    }
                    by = (byte)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxByte) > 0 || bigDecimal.compareTo(bdMinByte) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    by = (byte)bigDecimal.intValue();
                    break;
                }
                case 21: {
                    by = (byte)((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        by = 1;
                        break;
                    }
                    by = 0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    by = Byte.parseByte(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return by;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public byte[] getBytesNoConvert() {
        switch (this.type) {
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                if (this.nativeDataLen == ((byte[])this.data).length) {
                    return (byte[])this.data;
                }
                byte[] byArray = new byte[this.nativeDataLen];
                System.arraycopy(this.data, 0, byArray, 0, this.nativeDataLen);
                return byArray;
            }
        }
        return (byte[])this.data;
    }

    public byte[] getBytes(int n, BaseExceptions baseExceptions) throws SQLException {
        return this.getBytes(n, null, baseExceptions);
    }

    public byte[] getBytes(int n, UtilTransliterator utilTransliterator, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Object object;
            Object object2 = null;
            switch (this.type) {
                case 2: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    object2 = (byte[])this.data;
                    break;
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    if (this.nativeDataLen == ((byte[])this.data).length) {
                        object2 = (byte[])this.data;
                        break;
                    }
                    object2 = new byte[this.nativeDataLen];
                    System.arraycopy(this.data, 0, object2, 0, this.nativeDataLen);
                    break;
                }
                case 201: 
                case 202: 
                case 203: {
                    object2 = ((String)this.data).getBytes("UTF-16BE");
                    break;
                }
                case 10: 
                case 204: 
                case 205: 
                case 206: {
                    object2 = BaseData.stringToBytes((String)this.data, utilTransliterator, baseExceptions);
                    break;
                }
                case 14: {
                    object = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    boolean bl = false;
                    while (!bl) {
                        int n2;
                        try {
                            n2 = ((InputStream)this.data).read(byArray, 0, byArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n2 == -1) {
                            bl = true;
                            try {
                                ((InputStream)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        ((ByteArrayOutputStream)object).write(byArray, 0, n2);
                    }
                    object2 = ((ByteArrayOutputStream)object).toByteArray();
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    object = this.getString(-1, baseExceptions);
                    object2 = BaseData.stringToBytes((String)object, utilTransliterator, baseExceptions);
                    break;
                }
                case 19: {
                    Blob blob = this.getBlob(null, baseExceptions);
                    int n3 = (int)blob.length();
                    if (n >= 0 && n3 > n) {
                        n3 = n;
                    }
                    object2 = blob.getBytes(1L, n3);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (n != -1 && ((byte[])object2).length > n) {
                object = new byte[n];
                System.arraycopy(object2, 0, object, 0, n);
                object2 = object;
            }
            return object2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Reader getCharacterStreamReaderNoConvert() {
        return (Reader)this.data;
    }

    public Reader getCharacterStreamReader(int n, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Reader reader = null;
            int n2 = -1;
            switch (this.type) {
                case 18: {
                    reader = (Reader)this.data;
                    break;
                }
                case 10: {
                    reader = new StringReader((String)this.data);
                    n2 = ((String)this.data).length();
                    break;
                }
                case 110: {
                    String string = (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
                    reader = new StringReader(string);
                    n2 = string.length();
                    break;
                }
                case 15: {
                    reader = new UtilASCIIInputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 2: {
                    String string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    reader = new StringReader(string);
                    n2 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    reader = new StringReader(string);
                    n2 = string.length();
                    break;
                }
                case 14: {
                    UtilBinaryToASCIIInputStream utilBinaryToASCIIInputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    if (this.data instanceof BaseInputStreamWrapper) {
                        n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    }
                    reader = new UtilASCIIInputStreamToCharacterReader(utilBinaryToASCIIInputStream);
                    break;
                }
                case 17: {
                    reader = new UtilUCS2InputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 20: {
                    reader = this.getClob(baseConnection, baseExceptions).getCharacterStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (reader != null && this.needWrapper) {
                if (!(reader instanceof BaseCharacterStreamWrapper)) {
                    reader = new BaseCharacterStreamWrapper(reader, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseCharacterStreamWrapper)reader).maxCharsToReturn = n / 2;
                }
            }
            return reader;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Reader getCharacterStreamReader(int n, BaseConnection baseConnection, BaseExceptions baseExceptions, boolean bl) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Reader reader = null;
            int n2 = -1;
            switch (this.type) {
                case 18: {
                    reader = (Reader)this.data;
                    break;
                }
                case 10: {
                    reader = new StringReader((String)this.data);
                    n2 = ((String)this.data).length();
                    break;
                }
                case 110: {
                    String string = (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
                    reader = new StringReader(string);
                    n2 = string.length();
                    break;
                }
                case 15: {
                    reader = new UtilASCIIInputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 2: {
                    String string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    reader = new StringReader(string);
                    n2 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    reader = new StringReader(string);
                    n2 = string.length();
                    break;
                }
                case 14: {
                    UtilBinaryToASCIIInputStream utilBinaryToASCIIInputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    if (this.data instanceof BaseInputStreamWrapper) {
                        n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    }
                    reader = new UtilASCIIInputStreamToCharacterReader(utilBinaryToASCIIInputStream);
                    break;
                }
                case 17: {
                    reader = new UtilUCS2InputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 20: {
                    Clob clob = this.getClob(baseConnection, baseExceptions);
                    if (clob instanceof BaseClob) {
                        reader = ((BaseClob)clob).getCharacterStream(bl);
                        break;
                    }
                    reader = clob.getCharacterStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (reader != null && this.needWrapper) {
                if (!(reader instanceof BaseCharacterStreamWrapper)) {
                    reader = new BaseCharacterStreamWrapper(reader, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseCharacterStreamWrapper)reader).maxCharsToReturn = n / 2;
                }
            }
            return reader;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public short getShortNoConvert() {
        return this.shortValue;
    }

    public short getShort(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            short s = 0;
            switch (this.type) {
                case 3: {
                    s = this.shortValue;
                    break;
                }
                case 10: {
                    s = Short.parseShort(((String)this.data).trim());
                    break;
                }
                case 1: {
                    s = this.byteValue;
                    break;
                }
                case 4: {
                    if (this.intValue > Short.MAX_VALUE || this.intValue < Short.MIN_VALUE) {
                        throw baseExceptions.getException(6104);
                    }
                    s = (short)this.intValue;
                    break;
                }
                case 5: {
                    if (this.longValue > 32767L || this.longValue < -32768L) {
                        throw baseExceptions.getException(6104);
                    }
                    s = (short)this.longValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 32767.0f || this.floatValue < -32768.0f) {
                        throw baseExceptions.getException(6104);
                    }
                    s = (short)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 32767.0 || this.doubleValue < -32768.0) {
                        throw baseExceptions.getException(6104);
                    }
                    s = (short)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxShort) > 0 || bigDecimal.compareTo(bdMinShort) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    s = (short)bigDecimal.intValue();
                    break;
                }
                case 21: {
                    s = (short)((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        s = 1;
                        break;
                    }
                    s = 0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    s = Short.parseShort(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return s;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public int getIntegerNoConvert() {
        return this.intValue;
    }

    public int getInteger(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            int n = 0;
            switch (this.type) {
                case 4: {
                    n = this.intValue;
                    break;
                }
                case 1: {
                    n = this.byteValue;
                    break;
                }
                case 3: {
                    n = this.shortValue;
                    break;
                }
                case 5: {
                    if (this.longValue > Integer.MAX_VALUE || this.longValue < Integer.MIN_VALUE) {
                        throw baseExceptions.getException(6104);
                    }
                    n = (int)this.longValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 2.1474836E9f || this.floatValue < -2.1474836E9f) {
                        throw baseExceptions.getException(6104);
                    }
                    n = (int)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 2.147483647E9 || this.doubleValue < -2.147483648E9) {
                        throw baseExceptions.getException(6104);
                    }
                    n = (int)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxInt) > 0 || bigDecimal.compareTo(bdMinInt) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    n = bigDecimal.intValue();
                    break;
                }
                case 21: {
                    n = (int)((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        n = 1;
                        break;
                    }
                    n = 0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    n = Integer.parseInt(string.trim());
                    break;
                }
                case 10: {
                    n = Integer.parseInt(((String)this.data).trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return n;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public long getLongNoConvert() {
        return this.longValue;
    }

    public long getLong(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0L;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0L;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            long l = 0L;
            switch (this.type) {
                case 5: {
                    l = this.longValue;
                    break;
                }
                case 1: {
                    l = this.byteValue;
                    break;
                }
                case 3: {
                    l = this.shortValue;
                    break;
                }
                case 4: {
                    l = this.intValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 9.223372E18f || this.floatValue < -9.223372E18f) {
                        throw baseExceptions.getException(6104);
                    }
                    l = (long)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 9.223372036854776E18 || this.doubleValue < -9.223372036854776E18) {
                        throw baseExceptions.getException(6104);
                    }
                    l = (long)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxLong) > 0 || bigDecimal.compareTo(bdMinLong) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    l = ((BigDecimal)this.data).longValue();
                    break;
                }
                case 21: {
                    l = ((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        l = 1L;
                        break;
                    }
                    l = 0L;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    l = Long.parseLong(string.trim());
                    break;
                }
                case 10: {
                    l = BaseData.stringToLong(((String)this.data).trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return l;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public float getFloatNoConvert() {
        return this.floatValue;
    }

    public float getFloat(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0.0f;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0.0f;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            float f = 0.0f;
            switch (this.type) {
                case 6: {
                    f = this.floatValue;
                    break;
                }
                case 10: {
                    f = Float.valueOf(((String)this.data).trim()).floatValue();
                    break;
                }
                case 1: {
                    f = this.byteValue;
                    break;
                }
                case 3: {
                    f = this.shortValue;
                    break;
                }
                case 4: {
                    f = this.intValue;
                    break;
                }
                case 5: {
                    f = this.longValue;
                    break;
                }
                case 7: {
                    f = (float)this.doubleValue;
                    break;
                }
                case 8: {
                    float f2 = ((BigDecimal)this.data).floatValue();
                    if (f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
                        throw baseExceptions.getException(6104);
                    }
                    f = f2;
                    break;
                }
                case 21: {
                    f = (float)((UtilSmallDecimal)this.data).doubleValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        f = 1.0f;
                        break;
                    }
                    f = 0.0f;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    f = Float.valueOf(string.trim()).floatValue();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return f;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public double getDoubleNoConvert() {
        return this.doubleValue;
    }

    public double getDouble(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0.0;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0.0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            double d = 0.0;
            switch (this.type) {
                case 7: {
                    d = this.doubleValue;
                    break;
                }
                case 10: {
                    d = BaseData.asciiToDouble(this.data.toString());
                    break;
                }
                case 1: {
                    d = this.byteValue;
                    break;
                }
                case 3: {
                    d = this.shortValue;
                    break;
                }
                case 4: {
                    d = this.intValue;
                    break;
                }
                case 5: {
                    d = this.longValue;
                    break;
                }
                case 6: {
                    d = this.floatValue;
                    break;
                }
                case 8: {
                    double d2 = BaseData.bigdecimalToDouble((BigDecimal)this.data);
                    if (d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
                        throw baseExceptions.getException(6104);
                    }
                    d = d2;
                    break;
                }
                case 21: {
                    d = ((UtilSmallDecimal)this.data).doubleValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        d = 1.0;
                        break;
                    }
                    d = 0.0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    d = Double.valueOf(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return d;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public String getStringNoConvert() {
        switch (this.type) {
            case 101: {
                return this.sqlserverUniqueidentifierToString();
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return this.sqlserverDateTimeToTimestamp().toString();
            }
            case 106: {
                return this.sybaseDatetoString();
            }
            case 107: {
                return this.sybaseTimeToTimeStamp().timeToString();
            }
            case 108: {
                return this.oracleDateToTimestamp(null).toString();
            }
            case 109: {
                return this.oracleTimestampToTimestamp(null).toString();
            }
            case 110: {
                return (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
            }
            case 111: {
                return this.oracleTimestampWithLocalTimeZoneToTimestamp().toString();
            }
        }
        return (String)this.data;
    }

    public String getString(int n, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            if (this.type == 16) {
                this.unsupportedConversion(baseExceptions);
            }
            return null;
        }
        try {
            String string = null;
            switch (this.type) {
                case 10: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    string = (String)this.data;
                    break;
                }
                case 2: {
                    string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    break;
                }
                case 101: {
                    string = this.sqlserverUniqueidentifierToString();
                    break;
                }
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    string = this.sqlserverDateTimeToTimestamp().toString();
                    break;
                }
                case 106: {
                    string = this.sybaseDatetoString();
                    break;
                }
                case 107: {
                    string = this.sybaseTimeToTimeStamp().timeToString();
                    break;
                }
                case 108: {
                    string = this.oracleDateToTimestamp(null).toString();
                    break;
                }
                case 109: {
                    string = this.oracleTimestampToTimestamp(null).toString();
                    break;
                }
                case 110: {
                    string = (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
                    break;
                }
                case 111: {
                    string = this.oracleTimestampWithLocalTimeZoneToTimestamp().toString();
                    break;
                }
                case 14: {
                    byte[] byArray = this.getBytes(n, baseExceptions);
                    string = UtilDataConversions.bytesToString(byArray, byArray.length);
                    break;
                }
                case 15: 
                case 17: {
                    long l;
                    int n2 = -1;
                    if (this.data instanceof BaseInputStreamWrapper && (l = ((BaseInputStreamWrapper)this.data).numTotalBytesInStream) > 0L && l <= Integer.MAX_VALUE) {
                        n2 = new Long(l).intValue();
                    }
                    if (n2 == -1) {
                        n2 = 10240;
                    }
                    StringBuffer stringBuffer = new StringBuffer(n2);
                    boolean bl = false;
                    byte[] byArray = new byte[n2];
                    boolean bl2 = false;
                    while (!bl2) {
                        int n3;
                        try {
                            n3 = ((InputStream)this.data).read(byArray, 0, byArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n3 == -1) {
                            bl2 = true;
                            try {
                                ((InputStream)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        if (this.type == 15) {
                            stringBuffer.append(UtilDataConversions.ASCIIBytesToString(byArray, n3));
                            continue;
                        }
                        stringBuffer.append(UtilDataConversions.UCS2BytesToString(byArray, n3));
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 18: {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = false;
                    char[] cArray = new char[1024];
                    boolean bl3 = false;
                    while (!bl3) {
                        int n4;
                        try {
                            n4 = ((Reader)this.data).read(cArray, 0, cArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n4 == -1) {
                            bl3 = true;
                            try {
                                ((Reader)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        stringBuffer.append(cArray, 0, n4);
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 20: {
                    Clob clob = this.getClob(null, baseExceptions);
                    int n5 = new Long(clob.length()).intValue();
                    if (n >= 0 && n5 > n) {
                        n5 = n;
                    }
                    string = clob.getSubString(1L, n5);
                    break;
                }
                case 19: {
                    Blob blob = this.getBlob(null, baseExceptions);
                    int n6 = new Long(blob.length()).intValue();
                    if (n >= 0 && n6 > n / 2) {
                        n6 = n / 2;
                    }
                    byte[] byArray = blob.getBytes(1L, n6);
                    string = UtilDataConversions.bytesToString(byArray, byArray.length);
                    break;
                }
                case 1: {
                    string = String.valueOf(this.byteValue);
                    break;
                }
                case 9: {
                    string = String.valueOf(this.booleanValue);
                    break;
                }
                case 4: {
                    if (this.intValue >= 0 && this.intValue <= 7000) {
                        string = BaseIntegerStringConstants.positiveIntegers[this.intValue];
                        break;
                    }
                    if (this.intValue < 0 && this.intValue >= -1000) {
                        string = BaseIntegerStringConstants.negativeIntegers[-this.intValue];
                        break;
                    }
                    string = String.valueOf(this.intValue);
                    break;
                }
                case 3: {
                    if (this.shortValue >= 0 && this.shortValue <= 7000) {
                        string = BaseIntegerStringConstants.positiveIntegers[this.shortValue];
                        break;
                    }
                    if (this.shortValue < 0 && this.shortValue >= -1000) {
                        string = BaseIntegerStringConstants.negativeIntegers[-this.shortValue];
                        break;
                    }
                    string = String.valueOf(this.shortValue);
                    break;
                }
                case 5: {
                    if (this.longValue >= 0L && this.longValue <= 7000L) {
                        string = BaseIntegerStringConstants.positiveIntegers[(int)this.longValue];
                        break;
                    }
                    if (this.longValue < 0L && this.longValue >= -1000L) {
                        string = BaseIntegerStringConstants.negativeIntegers[-((int)this.longValue)];
                        break;
                    }
                    string = this.longToString(this.longValue);
                    break;
                }
                case 7: {
                    if (this.connection == null) {
                        throw baseExceptions.getException(6024);
                    }
                    if (this.connection.isJavaDoubleToString) {
                        string = String.valueOf(this.doubleValue);
                        break;
                    }
                    string = this.doubleToString(this.doubleValue);
                    break;
                }
                case 6: {
                    string = String.valueOf(this.floatValue);
                    break;
                }
                case 16: {
                    this.unsupportedConversion(baseExceptions);
                }
                default: {
                    string = this.data.toString();
                }
            }
            if (n != -1 && string.length() > n) {
                string = string.substring(0, n);
            }
            return string;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Date getDateNoConvert() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                BaseTimestamp baseTimestamp = this.sqlserverDateTimeToTimestamp();
                return new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
            }
            case 108: {
                return this.oracleDateToDate();
            }
            case 109: {
                BaseTimestamp baseTimestamp = this.oracleTimestampToTimestamp(null);
                return new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
            }
            case 110: {
                BaseTimestamp baseTimestamp = (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
                return new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
            }
            case 111: {
                BaseTimestamp baseTimestamp = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                return new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
            }
        }
        return (Date)this.data;
    }

    public Date getDate(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 203: 
                case 204: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Date date = null;
            switch (this.type) {
                case 11: {
                    date = (Date)this.data;
                    break;
                }
                case 10: 
                case 201: 
                case 204: {
                    date = Date.valueOf(((String)this.data).trim());
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    date = Date.valueOf(this.getString(-1, baseExceptions).trim());
                    break;
                }
                case 203: 
                case 206: {
                    BaseTimestamp baseTimestamp = BaseTimestamp.valueOf((String)this.data);
                    date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                    break;
                }
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    BaseTimestamp baseTimestamp = this.sqlserverDateTimeToTimestamp();
                    date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                    break;
                }
                case 106: {
                    date = this.sybaseDatetoDate();
                    break;
                }
                case 108: {
                    date = this.oracleDateToDate();
                    break;
                }
                case 109: {
                    BaseTimestamp baseTimestamp = this.oracleTimestampToTimestamp(null);
                    date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                    break;
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        BaseTimestamp baseTimestamp = (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
                        date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                        break;
                    }
                    throw baseExceptions.getException(6024);
                }
                case 111: {
                    BaseTimestamp baseTimestamp = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                    date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                    break;
                }
                case 13: {
                    BaseTimestamp baseTimestamp = (BaseTimestamp)this.data;
                    date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return date;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Date getDate(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 11: 
                case 13: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 203: 
                case 204: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            switch (this.type) {
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    return this.applyCalendarToSqlServerDate(calendar);
                }
                case 11: {
                    return BaseData.applyCalender((Date)this.data, calendar, false);
                }
                case 13: 
                case 108: 
                case 109: 
                case 111: 
                case 203: 
                case 206: {
                    Date date = this.getDate(baseExceptions);
                    return BaseData.applyCalender(date, calendar, false);
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        Date date = this.getDate(baseExceptions);
                        return BaseData.applyCalender(date, calendar, false);
                    }
                    throw baseExceptions.getException(6024);
                }
                case 201: 
                case 204: {
                    return BaseData.applyCalender(Date.valueOf((String)this.data), calendar, false);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Time getTimeNoConvert() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                BaseTimestamp baseTimestamp = this.sqlserverDateTimeToTimestamp();
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
            case 107: {
                BaseTimestamp baseTimestamp = this.sybaseTimeToTimeStamp();
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
            case 108: {
                BaseTimestamp baseTimestamp = this.oracleDateToTimestamp(null);
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
            case 109: {
                BaseTimestamp baseTimestamp = this.oracleTimestampToTimestamp(null);
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
            case 110: {
                BaseTimestamp baseTimestamp = (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
            case 111: {
                BaseTimestamp baseTimestamp = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
        }
        return (Time)this.data;
    }

    public Time getTime(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 202: 
                case 203: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Time time = null;
            switch (this.type) {
                case 12: {
                    time = (Time)this.data;
                    break;
                }
                case 10: 
                case 202: 
                case 205: {
                    time = Time.valueOf(((String)this.data).trim());
                    break;
                }
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    BaseTimestamp baseTimestamp = this.sqlserverDateTimeToTimestamp();
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 107: {
                    BaseTimestamp baseTimestamp = this.sybaseTimeToTimeStamp();
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 203: 
                case 206: {
                    BaseTimestamp baseTimestamp = BaseTimestamp.valueOf((String)this.data);
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 108: {
                    BaseTimestamp baseTimestamp = this.oracleDateToTimestamp(null);
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 109: {
                    BaseTimestamp baseTimestamp = this.oracleTimestampToTimestamp(null);
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        BaseTimestamp baseTimestamp = (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
                        time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                        break;
                    }
                    throw baseExceptions.getException(6024);
                }
                case 111: {
                    BaseTimestamp baseTimestamp = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 13: {
                    BaseTimestamp baseTimestamp = (BaseTimestamp)this.data;
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    time = Time.valueOf(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return time;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Time getTime(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 12: 
                case 13: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 202: 
                case 203: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            switch (this.type) {
                case 102: 
                case 103: 
                case 104: 
                case 107: {
                    return this.applyCalendarToSqlServerTime(calendar);
                }
                case 202: 
                case 205: {
                    return BaseData.applyCalender(Time.valueOf((String)this.data), calendar, false);
                }
                case 12: {
                    return BaseData.applyCalender((Time)this.data, calendar, false);
                }
                case 13: 
                case 108: 
                case 109: 
                case 111: 
                case 203: 
                case 206: {
                    Time time = this.getTime(baseExceptions);
                    return BaseData.applyCalender(time, calendar, false);
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        Time time = this.getTime(baseExceptions);
                        return BaseData.applyCalender(time, calendar, false);
                    }
                    throw baseExceptions.getException(6024);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public BaseTimestamp getTimestampNoConvert() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return this.sqlserverDateTimeToTimestamp();
            }
            case 107: {
                return this.sybaseTimeToTimeStamp();
            }
            case 108: {
                return this.oracleDateToTimestamp(null);
            }
            case 109: {
                return this.oracleTimestampToTimestamp(null);
            }
            case 110: {
                return (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
            }
            case 111: {
                return this.oracleTimestampWithLocalTimeZoneToTimestamp();
            }
        }
        return (BaseTimestamp)this.data;
    }

    public BaseTimestamp getTimestamp(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            BaseTimestamp baseTimestamp = null;
            switch (this.type) {
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    baseTimestamp = this.sqlserverDateTimeToTimestamp();
                    break;
                }
                case 107: {
                    baseTimestamp = this.sybaseTimeToTimeStamp();
                    break;
                }
                case 13: {
                    baseTimestamp = (BaseTimestamp)this.data;
                    break;
                }
                case 10: 
                case 203: 
                case 206: {
                    baseTimestamp = BaseTimestamp.valueOf(((String)this.data).trim());
                    break;
                }
                case 108: {
                    baseTimestamp = this.oracleDateToTimestamp(null);
                    break;
                }
                case 109: {
                    baseTimestamp = this.oracleTimestampToTimestamp(null);
                    break;
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        baseTimestamp = (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
                        break;
                    }
                    throw baseExceptions.getException(6024);
                }
                case 111: {
                    baseTimestamp = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    baseTimestamp = BaseTimestamp.valueOf(string.trim());
                    break;
                }
                case 201: 
                case 202: 
                case 204: 
                case 205: {
                    if (this.data == null) break;
                    Calendar calendar = Calendar.getInstance();
                    if (this.type == 202 || this.type == 205) {
                        calendar.setTime(Time.valueOf((String)this.data));
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                    } else {
                        calendar.setTime(Date.valueOf((String)this.data));
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                    baseTimestamp = new BaseTimestamp(calendar, 0);
                    break;
                }
                case 11: 
                case 12: {
                    if (this.data == null) break;
                    Calendar calendar = Calendar.getInstance();
                    if (this.type == 12) {
                        calendar.setTime((Time)this.data);
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                    } else {
                        calendar.setTime((Date)this.data);
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                    baseTimestamp = new BaseTimestamp(calendar, 0);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return baseTimestamp;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public BaseTimestamp getTimestamp(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 11: 
                case 12: 
                case 13: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            switch (this.type) {
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    return this.applyCalendarToSqlServerTimestamp(calendar);
                }
                case 201: 
                case 204: {
                    return new BaseData(11, BaseData.applyCalender(Date.valueOf(((String)this.data).trim()), calendar, false), this.connection).getTimestamp(baseExceptions);
                }
                case 202: 
                case 205: {
                    return new BaseData(12, BaseData.applyCalender(Time.valueOf(((String)this.data).trim()), calendar, false), this.connection).getTimestamp(baseExceptions);
                }
                case 203: 
                case 206: {
                    return BaseTimestamp.applyCalender(BaseTimestamp.valueOf(((String)this.data).trim()), calendar);
                }
                case 108: {
                    return this.oracleDateToTimestamp(calendar);
                }
                case 109: {
                    return this.oracleTimestampToTimestamp(calendar);
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        return (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(calendar, true);
                    }
                    throw baseExceptions.getException(6024);
                }
                case 111: {
                    return this.oracleTimestampWithLocalTimeZoneToTimestamp();
                }
                case 13: {
                    return BaseTimestamp.applyCalender((BaseTimestamp)this.data, calendar);
                }
                case 12: {
                    return new BaseData(12, BaseData.applyCalender((Time)this.data, calendar, false), this.connection).getTimestamp(baseExceptions);
                }
                case 11: {
                    return new BaseData(11, BaseData.applyCalender((Date)this.data, calendar, false), this.connection).getTimestamp(baseExceptions);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getBinaryStreamNoConvert() {
        return (InputStream)this.data;
    }

    public InputStream getBinaryStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 14: 
                case 19: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n2 = -1;
            switch (this.type) {
                case 14: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 201: 
                case 202: 
                case 203: {
                    byte[] byArray = ((String)this.data).getBytes("UTF-16BE");
                    inputStream = new ByteArrayInputStream(byArray);
                    n2 = byArray.length;
                    break;
                }
                case 204: 
                case 205: 
                case 206: {
                    byte[] byArray = ((String)this.data).getBytes();
                    inputStream = new ByteArrayInputStream(byArray);
                    n2 = byArray.length;
                    break;
                }
                case 2: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    inputStream = new ByteArrayInputStream((byte[])this.data);
                    n2 = ((byte[])this.data).length;
                    break;
                }
                case 108: 
                case 109: 
                case 110: {
                    inputStream = new ByteArrayInputStream(this.getBytesNoConvert());
                    n2 = this.nativeDataLen;
                    break;
                }
                case 19: {
                    inputStream = this.getBlob(baseConnection, baseExceptions).getBinaryStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null && this.needWrapper) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getBinaryStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions, boolean bl) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 14: 
                case 19: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n2 = -1;
            switch (this.type) {
                case 14: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 201: 
                case 202: 
                case 203: {
                    byte[] byArray = ((String)this.data).getBytes("UTF-16BE");
                    inputStream = new ByteArrayInputStream(byArray);
                    n2 = byArray.length;
                    break;
                }
                case 204: 
                case 205: 
                case 206: {
                    byte[] byArray = ((String)this.data).getBytes();
                    inputStream = new ByteArrayInputStream(byArray);
                    n2 = byArray.length;
                    break;
                }
                case 2: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    inputStream = new ByteArrayInputStream((byte[])this.data);
                    n2 = ((byte[])this.data).length;
                    break;
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    inputStream = new ByteArrayInputStream(this.getBytesNoConvert());
                    n2 = this.nativeDataLen;
                    break;
                }
                case 19: {
                    Blob blob = this.getBlob(baseConnection, baseExceptions);
                    if (blob instanceof BaseBlob) {
                        inputStream = ((BaseBlob)blob).getBinaryStream(bl);
                        break;
                    }
                    inputStream = blob.getBinaryStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null && this.needWrapper) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getUTF8InputStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            if (this.type == 16) {
                return null;
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            switch (this.type) {
                case 16: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, -1L, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getUCS2InputStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            if (this.type == 17) {
                return null;
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            switch (this.type) {
                case 17: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                default: {
                    Reader reader = this.getCharacterStreamReader(n, baseConnection, baseExceptions);
                    if (reader == null) break;
                    inputStream = new UtilCharacterReaderToUCS2InputStream(reader);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, -1L, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Clob getClobNoConvert() {
        return (Clob)this.data;
    }

    public Clob getClob(BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            if (this.type == 20) {
                return null;
            }
            this.getString(0, baseExceptions);
            return null;
        }
        try {
            Clob clob = null;
            switch (this.type) {
                case 20: {
                    if (this.data == null) break;
                    if (this.data instanceof BaseImplClob) {
                        this.data = new BaseClob((BaseImplClob)this.data, baseConnection, baseExceptions);
                    }
                    clob = (Clob)this.data;
                    break;
                }
                default: {
                    this.needWrapper = false;
                    Reader reader = this.getCharacterStreamReader(-1, baseConnection, baseExceptions);
                    this.needWrapper = true;
                    BaseImplClobEmulated baseImplClobEmulated = new BaseImplClobEmulated(baseExceptions, reader);
                    clob = new BaseClob(baseImplClobEmulated, baseConnection, baseExceptions);
                }
            }
            return clob;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    static Date applyCalender(Date date, Calendar calendar, boolean bl) {
        calendar = (Calendar)calendar.clone();
        if (bl) {
            calendar.setTime(date);
            int n = calendar.get(1) - 1900;
            int n2 = calendar.get(2);
            int n3 = calendar.get(5);
            return new Date(n, n2, n3);
        }
        calendar.clear();
        calendar.set(date.getYear() + 1900, date.getMonth(), date.getDate(), 0, 0, 0);
        return new Date(calendar.getTime().getTime());
    }

    static Time applyCalender(Time time, Calendar calendar, boolean bl) {
        calendar = (Calendar)calendar.clone();
        if (bl) {
            calendar.setTime(time);
            int n = calendar.get(11);
            int n2 = calendar.get(12);
            int n3 = calendar.get(13);
            return new Time(n, n2, n3);
        }
        calendar.clear();
        calendar.set(1970, 0, 1, time.getHours(), time.getMinutes(), time.getSeconds());
        return new Time(calendar.getTime().getTime());
    }

    final void unsupportedConversion(BaseExceptions baseExceptions) throws SQLException {
        switch (this.type) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                try {
                    ((InputStream)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 18: {
                try {
                    ((Reader)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 19: {
                try {
                    ((BaseImplBlob)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 20: {
                try {
                    ((BaseImplClob)this.data).close();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw baseExceptions.getException(6008);
    }

    static double exponentAdjust(long l, int n, int n2) {
        int n3;
        long l2;
        long l3;
        if (n == 0) {
            return l;
        }
        if (n > 0) {
            if (n >= BaseDoubleConversionConstants.PowersOf10Mantissa.length) {
                return Double.longBitsToDouble(0x7FF0000000000000L);
            }
            l3 = BaseDoubleConversionConstants.PowersOf10Mantissa[n];
            l2 = BaseDoubleConversionConstants.PowersOf10Exponent[n];
        } else {
            int n4 = -n;
            if (n4 >= BaseDoubleConversionConstants.DivisorsOf10Mantissa.length) {
                return 0.0;
            }
            l3 = BaseDoubleConversionConstants.DivisorsOf10Mantissa[n4];
            l2 = BaseDoubleConversionConstants.DivisorsOf10Exponent[n4] + (long)n2;
        }
        long l4 = (l & 0xFFFFFFFFL) * (l3 & 0xFFFFFFFFL);
        long l5 = (l >> 32 & 0xFFFFFFFFL) * (l3 >> 32 & 0xFFFFFFFFL);
        long l6 = (l >> 32 & 0xFFFFFFFFL) * (l3 & 0xFFFFFFFFL);
        l5 += l6 >> 32 & 0xFFFFFFFFL;
        long l7 = l6 << 32;
        if (l4 < 0L) {
            l4 += l7;
            if (l7 < 0L) {
                ++l5;
            } else if (l4 >= 0L) {
                ++l5;
            }
        } else if (l7 < 0L && (l4 += l7) >= 0L) {
            ++l5;
        }
        l6 = (l & 0xFFFFFFFFL) * (l3 >> 32 & 0xFFFFFFFFL);
        l5 += l6 >> 32 & 0xFFFFFFFFL;
        l7 = l6 << 32;
        if (l4 < 0L) {
            l4 += l7;
            if (l7 < 0L) {
                ++l5;
            } else if (l4 >= 0L) {
                ++l5;
            }
        } else if (l7 < 0L && (l4 += l7) >= 0L) {
            ++l5;
        }
        if (l5 == 0L) {
            if (l4 >= 0L) {
                l5 = l4;
            } else {
                l5 = l4 >> 1 & Long.MAX_VALUE;
                ++l2;
            }
            l4 = 0L;
            l2 -= 64L;
        }
        if (l5 < 0x10000000000000L || l5 >= 0x20000000000000L) {
            int n5 = 0;
            int n6 = BaseDoubleConversionConstants.HighestBit.length - 1;
            do {
                int n7;
                if (l5 < BaseDoubleConversionConstants.HighestBit[n7 = (n5 + n6) / 2]) {
                    n6 = n7 - 1;
                    continue;
                }
                n5 = n7 + 1;
            } while (n5 <= n6);
            if (n6 < 52) {
                n3 = 52 - n6;
                l5 = l4 >= 0L ? l5 << n3 | l4 >> 64 - n3 & Long.MAX_VALUE : l5 << n3 | (l4 >> 1 & Long.MAX_VALUE) >> 63 - n3;
                l4 <<= n3;
                l2 -= (long)n3;
            } else {
                n3 = n6 - 52;
                l4 = l5 << 64 - n3;
                l5 >>= n3;
                l2 += (long)n3;
            }
        }
        l6 = l5;
        if (l4 < 0L && ++l6 >= 0x20000000000000L) {
            l6 = 0x10000000000000L;
            ++l2;
        }
        if (n < 0) {
            l7 = (l6 |= 0x4330000000000000L) + (l2 + 2L << 52);
            if (l7 < 0L || (l7 & 0x7FF0000000000000L) == 0L) {
                l7 = l5;
                if ((l2 += 2L + ((l6 & 0x7FF0000000000000L) >> 52)) <= 0L) {
                    n3 = (int)(-l2);
                } else {
                    System.out.println("** Internal Error! ** : " + l2);
                    n3 = 0;
                }
                if (n3 > 52) {
                    return 0.0;
                }
                if (n3 > 0) {
                    l7 >>= n3;
                }
                l7 = (l7 & 1L) == 0L ? (l7 >>= 1) : (l7 >> 1) + 1L;
            }
        } else {
            l7 = l6 + (l2 + 1138L << 52);
            if (l7 < 0L || (l7 & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
                l7 = 0x7FF0000000000000L;
            }
        }
        double d = Double.longBitsToDouble(l7);
        return d;
    }

    static double asciiToDouble(String string) {
        long l;
        boolean bl;
        int n;
        int n2;
        for (n2 = string.length(); n2 >= 0 && string.charAt(n2 - 1) <= ' '; --n2) {
        }
        if (n2 == 0) {
            throw new NumberFormatException("empty string");
        }
        for (n = 0; n < n2 && string.charAt(n) <= ' '; ++n) {
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        char c = string.charAt(n);
        while (c <= ' ' && (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') && ++n < n2) {
            c = string.charAt(n);
        }
        if (n >= n2) {
            return 0.0;
        }
        if (c == '-') {
            bl = true;
            c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
        } else {
            bl = false;
            if (c == '+') {
                c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
            }
        }
        while (c == '0') {
            if (++n < n2) {
                c = string.charAt(n);
                continue;
            }
            c = '\u0000';
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (c >= '0' && c <= '9') {
            n5 = n5 * 10 + (c - 48);
            c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
            if (++n4 != 9 || c != '.' && (c < '0' || c > '9')) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (c == '.') {
                c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                if (n5 == 0) {
                    while (c == '0') {
                        c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                        ++n3;
                    }
                }
                while (c >= '0' && c <= '9') {
                    n5 = n5 * 10 + (c - 48);
                    c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                    ++n3;
                    if (++n4 != 9 || c < '0' || c > '9') continue;
                    bl2 = true;
                    bl3 = true;
                    break;
                }
            }
            if (!bl2) {
                if (c == 'E' || c == 'e') {
                    boolean bl5;
                    if ((c = string.charAt(++n)) == '-') {
                        bl5 = true;
                        c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                    } else {
                        bl5 = false;
                        if (c == '+') {
                            c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                        }
                    }
                    while (c == '0') {
                        if (++n < n2) {
                            c = string.charAt(n);
                            continue;
                        }
                        c = '\u0000';
                    }
                    while (c >= '0' && c <= '9') {
                        n6 = n6 * 10 + (c - 48);
                        if (++n < n2) {
                            c = string.charAt(n);
                            continue;
                        }
                        c = '\u0000';
                    }
                    if (bl5) {
                        n6 = -n6;
                    }
                }
                while (c <= ' ' && (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f')) {
                    if (++n < n2) {
                        c = string.charAt(n);
                        continue;
                    }
                    c = '\u0000';
                }
                if (c != '\u0000') {
                    throw new NumberFormatException("Invalid value");
                }
                if (n5 == 0) {
                    if (bl) {
                        return -0.0;
                    }
                    return 0.0;
                }
                double d = BaseData.exponentAdjust(n5, n6 -= n3, 0);
                if (bl) {
                    d = -d;
                }
                return d;
            }
        }
        if (!bl3) {
            l = n5;
            while (c >= '0' && c <= '9') {
                l = l * 10L + (long)(c - 48);
                c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                if (++n4 != 19 && (n4 != 18 || l < 0xCCCCCCCCCCCCCCCL)) continue;
                if (c >= '5') {
                    ++l;
                }
                while (c >= '0' && c <= '9') {
                    c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                    --n3;
                }
                if (c == '.') {
                    c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                }
                while (c >= '0' && c <= '9') {
                    if (++n < n2) {
                        c = string.charAt(n);
                        continue;
                    }
                    c = '\u0000';
                }
                bl4 = true;
                break;
            }
            if (!bl4 && c == '.') {
                c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                bl3 = true;
            }
        } else {
            l = n5;
        }
        if (bl3) {
            while (c >= '0' && c <= '9') {
                l = l * 10L + (long)(c - 48);
                c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                ++n3;
                if (++n4 != 19 && (n4 != 18 || l < 0xCCCCCCCCCCCCCCCL)) continue;
                if (c >= '5') {
                    ++l;
                }
                while (c >= '0' && c <= '9') {
                    if (++n < n2) {
                        c = string.charAt(n);
                        continue;
                    }
                    c = '\u0000';
                }
                break block13;
            }
        }
        if (c == 'E' || c == 'e') {
            boolean bl6;
            if ((c = ++n < n2 ? string.charAt(n) : (char)'\u0000') == '-') {
                bl6 = true;
                c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
            } else {
                bl6 = false;
                if (c == '+') {
                    c = ++n < n2 ? string.charAt(n) : (char)'\u0000';
                }
            }
            while (c == '0') {
                if (++n < n2) {
                    c = string.charAt(n);
                    continue;
                }
                c = '\u0000';
            }
            while (c >= '0' && c <= '9') {
                n6 = n6 * 10 + (c - 48);
                if (++n < n2) {
                    c = string.charAt(n);
                    continue;
                }
                c = '\u0000';
            }
            if (bl6) {
                n6 = -n6;
            }
        }
        while (c <= ' ' && (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f')) {
            if (++n < n2) {
                c = string.charAt(n);
                continue;
            }
            c = '\u0000';
        }
        if (c != '\u0000') {
            throw new NumberFormatException("Invalid Value");
        }
        double d = BaseData.exponentAdjust(l, n6 -= n3, 0);
        if (bl) {
            d = -d;
        }
        return d;
    }

    public String doubleToString(double d) {
        int n;
        int n2;
        int n3;
        int n4;
        if (d == Double.NEGATIVE_INFINITY) {
            return new String(NEGATIVE_INFINITY);
        }
        if (d == Double.POSITIVE_INFINITY) {
            return new String(POSITIVE_INFINITY);
        }
        if (d != d) {
            return new String(NaN);
        }
        if (d == 0.0) {
            return "0.0";
        }
        if (this.buf == null) {
            this.buf = new char[32];
        }
        int n5 = 0;
        boolean bl = false;
        long l = Double.doubleToLongBits(d);
        int n6 = (int)((l & 0x7FF0000000000000L) >> 52);
        long l2 = n6 != 0 ? l & 0xFFFFFFFFFFFFFL | 0x10000000000000L : l & 0xFFFFFFFFFFFFFL;
        if ((n6 -= 1023) >= 0 && n6 <= 52) {
            if (d < 0.0) {
                bl = true;
            }
            if ((BaseDoubleConversionConstants.CheckForInteger[n6] & l2) == 0L) {
                int n7;
                int n8;
                long l3 = l2 >> 52 - n6;
                n5 = 25;
                while (l3 > Integer.MAX_VALUE) {
                    long l4 = l3 / 1000L;
                    n8 = (int)(l3 - l4 * 1000L);
                    l3 = l4;
                    this.buf[n5] = DigitOnes[n8];
                    this.buf[n5 - 1] = DigitTens[n8];
                    this.buf[n5 - 2] = DigitHundreds[n8];
                    n5 -= 3;
                }
                int n9 = (int)l3;
                while (n9 >= 65536) {
                    n7 = n9 / 1000;
                    n8 = n9 - n7 * 1000;
                    n9 = n7;
                    this.buf[n5] = DigitOnes[n8];
                    this.buf[n5 - 1] = DigitTens[n8];
                    this.buf[n5 - 2] = DigitHundreds[n8];
                    n5 -= 3;
                }
                while (true) {
                    n7 = n9 * 52429 >>> 19;
                    this.buf[n5] = (char)(n9 - n7 * 10 + 48);
                    --n5;
                    if (n7 == 0) break;
                    n9 = n7;
                }
                if (n5 <= 17) {
                    n6 = 24 - n5;
                    this.buf[n5] = this.buf[n5 + 1];
                    this.buf[n5 + 1] = 46;
                    int n10 = 25;
                    while (this.buf[n10] == '0') {
                        --n10;
                    }
                    if (n10 == n5 + 1) {
                        n10 += 2;
                    }
                    int n11 = ++n10;
                    ++n10;
                    this.buf[n11] = 69;
                    if (n6 > 9) {
                        this.buf[n10++] = 49;
                        this.buf[n10++] = (char)(n6 + 38);
                    } else {
                        this.buf[n10++] = (char)(n6 + 48);
                    }
                    if (bl) {
                        this.buf[--n5] = 45;
                    }
                    return new String(this.buf, n5, n10 - n5);
                }
                this.buf[26] = 46;
                this.buf[27] = 48;
                if (bl) {
                    this.buf[n5] = 45;
                    --n5;
                }
                return new String(this.buf, n5 + 1, 27 - n5);
            }
        }
        long l5 = BaseDoubleConversionConstants.ScalingTable[n6 += 1050];
        long l6 = l5 & 0xFFFFFFFFL;
        long l7 = l2 & 0xFFFFFFFFL;
        long l8 = (l5 & 0xFFFFFFFFL) * (l2 & 0xFFFFFFFFL);
        long l9 = (l5 >> 32 & 0xFFFFFFFFL) * (l2 & 0xFFFFFFFFL);
        long l10 = l8;
        long l11 = l9 << 32;
        l8 += l11;
        boolean bl2 = false;
        if (l10 < 0L && l11 < 0L) {
            bl2 = true;
        } else if (l10 < 0L || l11 < 0L) {
            bl2 = l8 >= 0L;
        }
        long l12 = bl2 ? (l9 >> 32 & 0xFFFFFFFFL) + 1L : l9 >> 32 & 0xFFFFFFFFL;
        l9 = (l5 & 0xFFFFFFFFL) * (l2 >> 32 & 0xFFFFFFFFL);
        l10 = l8;
        l11 = l9 << 32;
        l8 += l11;
        bl2 = false;
        if (l10 < 0L && l11 < 0L) {
            bl2 = true;
        } else if (l10 < 0L || l11 < 0L) {
            boolean bl3 = bl2 = l8 >= 0L;
        }
        l12 = bl2 ? (l12 += (l9 >> 32 & 0xFFFFFFFFL) + 1L) : (l12 += l9 >> 32 & 0xFFFFFFFFL);
        l9 = (l5 >> 32 & 0xFFFFFFFFL) * (l2 >> 32 & 0xFFFFFFFFL);
        l12 += l9;
        int n12 = ((int)(l8 >> 48) & 0xFFFF) * 100;
        if (d < 0.0) {
            l12 = (n12 & 0x8000) != 0 ? -(l12 * 100L + (long)(n12 >> 16) + 1L) : -(l12 * 100L + (long)(n12 >> 16));
            bl = true;
        } else {
            l12 = (n12 & 0x8000) != 0 ? l12 * 100L + (long)(n12 >> 16) + 1L : l12 * 100L + (long)(n12 >> 16);
        }
        int n13 = BaseDoubleConversionConstants.ScalingTableExp[n6] + 3;
        if (bl) {
            l12 = -l12;
        }
        if (l12 > 999999999999999L) {
            if (l12 > 9999999999999999L) {
                if (l12 > 99999999999999999L) {
                    if (l12 > 999999999999999999L) {
                        n13 -= 4;
                        l12 = (l12 + 5000L) / 10000L;
                    } else {
                        n13 -= 3;
                        l12 = (l12 + 500L) / 1000L;
                    }
                } else {
                    n13 -= 2;
                    l12 = (l12 + 50L) / 100L;
                }
            } else {
                --n13;
                l12 = (l12 + 5L) / 10L;
            }
        }
        n5 = 25;
        while (l12 > Integer.MAX_VALUE) {
            long l13 = l12 / 1000L;
            n4 = (int)(l12 - l13 * 1000L);
            l12 = l13;
            this.buf[n5] = DigitOnes[n4];
            this.buf[n5 - 1] = DigitTens[n4];
            this.buf[n5 - 2] = DigitHundreds[n4];
            n5 -= 3;
        }
        int n14 = (int)l12;
        while (n14 >= 65536) {
            n3 = n14 / 1000;
            n4 = n14 - n3 * 1000;
            n14 = n3;
            this.buf[n5] = DigitOnes[n4];
            this.buf[n5 - 1] = DigitTens[n4];
            this.buf[n5 - 2] = DigitHundreds[n4];
            n5 -= 3;
        }
        while (true) {
            n3 = n14 * 52429 >>> 19;
            this.buf[n5] = (char)(n14 - n3 * 10 + 48);
            --n5;
            if (n3 == 0) break;
            n14 = n3;
        }
        n13 = 25 - n5 - n13;
        if (n13 <= 6 && n13 > 0) {
            n2 = n5;
            for (n = 0; n <= n13; ++n) {
                this.buf[n2] = this.buf[n2 + 1];
                ++n2;
            }
            this.buf[n2] = 46;
        } else if (n13 > -4 && n13 < 0) {
            switch (n13) {
                case -1: {
                    this.buf[n5--] = 46;
                    this.buf[n5] = 48;
                    break;
                }
                case -2: {
                    this.buf[n5--] = 48;
                    this.buf[n5--] = 46;
                    this.buf[n5] = 48;
                    break;
                }
                case -3: {
                    this.buf[n5--] = 48;
                    this.buf[n5--] = 48;
                    this.buf[n5--] = 46;
                    this.buf[n5] = 48;
                }
            }
        } else {
            this.buf[n5] = this.buf[n5 + 1];
            this.buf[n5 + 1] = 46;
        }
        n2 = 26;
        n = 25;
        while (this.buf[n] == '0') {
            --n;
        }
        int n15 = n2 = this.buf[n] == '.' ? n + 2 : n + 1;
        if (bl) {
            this.buf[--n5] = 45;
        }
        if (n13 > 6 || n13 < -3) {
            this.buf[n2] = 69;
            ++n2;
            if (n13 < 0) {
                this.buf[n2] = 45;
                ++n2;
                n13 = -n13;
            }
            if (n13 < 10) {
                this.buf[n2] = DigitOnes[n13];
                ++n2;
            } else if (n13 < 100) {
                this.buf[n2] = DigitTens[n13];
                this.buf[n2 + 1] = DigitOnes[n13];
                n2 += 2;
            } else if (n13 < 1000) {
                this.buf[n2] = DigitHundreds[n13];
                this.buf[n2 + 1] = DigitTens[n13];
                this.buf[n2 + 2] = DigitOnes[n13];
                n2 += 3;
            }
        }
        return new String(this.buf, n5, n2 - n5);
    }

    public static double bigdecimalToDouble(BigDecimal bigDecimal) {
        double d;
        int n;
        if (bigDecimal.signum() == 0) {
            return 0.0;
        }
        int n2 = bigDecimal.scale();
        if (n2 >= BaseDoubleConversionConstants.DivisorsOf10Mantissa.length) {
            return BaseData.asciiToDouble(bigDecimal.toString());
        }
        boolean bl = bigDecimal.signum() < 0;
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        int n3 = byArray.length - 1;
        if (n3 < 8) {
            n = 0;
        } else {
            n = (n3 - 7) * 8;
            n3 = 7;
        }
        long l = byArray[n3] & 0xFF;
        if (n3 > 0) {
            l |= (long)((byArray[n3 - 1] & 0xFF) << 8);
            if (n3 > 1) {
                l |= (long)((byArray[n3 - 2] & 0xFF) << 16);
                if (n3 > 2) {
                    l |= ((long)byArray[n3 - 3] & 0xFFL) << 24;
                    if (n3 > 3) {
                        l |= ((long)byArray[n3 - 4] & 0xFFL) << 32;
                        if (n3 > 4) {
                            l |= ((long)byArray[n3 - 5] & 0xFFL) << 40;
                            if (n3 > 5) {
                                l |= ((long)byArray[n3 - 6] & 0xFFL) << 48;
                                if (n3 > 6) {
                                    if (bl && (l |= ((long)byArray[n3 - 7] & 0xFFL) << 56) != Long.MIN_VALUE) {
                                        l = -l;
                                    }
                                } else if (bl) {
                                    l = 0x100000000000000L - l;
                                }
                            } else if (bl) {
                                l = 0x1000000000000L - l;
                            }
                        } else if (bl) {
                            l = 0x10000000000L - l;
                        }
                    } else if (bl) {
                        l = 0x100000000L - l;
                    }
                } else if (bl) {
                    l = 0x1000000L - l;
                }
            } else if (bl) {
                l = 65536L - l;
            }
        } else if (bl) {
            l = 256L - l;
        }
        if (n2 == 0) {
            if (l < 0L) {
                if ((l >> 10 & 1L) != 0L) {
                    if ((l = (l >> 11 & 0x1FFFFFFFFFFFFFL) + 1L) >= 0x20000000000000L) {
                        l = 0x10000000000000L;
                        ++n;
                    }
                } else {
                    l = l >> 11 & 0x1FFFFFFFFFFFFFL;
                }
                n += 11;
            } else if (l < 0x10000000000000L || l >= 0x20000000000000L) {
                int n4 = 0;
                int n5 = BaseDoubleConversionConstants.HighestBit.length - 1;
                do {
                    int n6;
                    if (l < BaseDoubleConversionConstants.HighestBit[n6 = (n4 + n5) / 2]) {
                        n5 = n6 - 1;
                        continue;
                    }
                    n4 = n6 + 1;
                } while (n4 <= n5);
                if (n5 < 52) {
                    int n7 = 52 - n5;
                    l <<= n7;
                    n -= n7;
                } else if (n5 != 52) {
                    int n8 = n5 - 52;
                    n += n8;
                    if (l << 116 - n5 < 0L) {
                        if ((l = (l >> n8) + 1L) >= 0x20000000000000L) {
                            l = 0x10000000000000L;
                            ++n;
                        }
                    } else {
                        l >>= n8;
                    }
                }
            }
            l = (n += 1074) >= 2046 ? 0x7FF0000000000000L : (l += (long)n << 52);
            d = Double.longBitsToDouble(l);
        } else {
            d = BaseData.exponentAdjust(l, -n2, n);
            if (byArray.length > 8) {
                byte by = byArray[8];
                if (l >= 0L) {
                    int n9;
                    if ((l & 0xF000000000000000L) == 0L) {
                        if ((l & 0xC00000000000000L) == 0L) {
                            if ((l & 0x200000000000000L) == 0L) {
                                if ((l & 0x100000000000000L) == 0L) {
                                    n9 = 8;
                                    l = l << 8 | (long)(by & 0xFF);
                                    by = byArray.length > 9 ? byArray[9] : (byte)0;
                                } else {
                                    n9 = 7;
                                }
                            } else {
                                n9 = 6;
                            }
                        } else {
                            n9 = (l & 0x800000000000000L) == 0L ? 5 : 4;
                        }
                    } else {
                        n9 = (l & 0xC000000000000000L) == 0L ? ((l & 0x2000000000000000L) == 0L ? 3 : 2) : 1;
                    }
                    if (n9 < 8) {
                        l = l << n9 | (long)((by & 0xFF) >> 8 - n9);
                        by = (byte)(by << n9);
                    }
                    n -= n9;
                }
                if (by < 0 && ++l == 0L) {
                    l = Long.MIN_VALUE;
                    ++n;
                }
                d = BaseData.exponentAdjust(l, -n2, n);
            }
        }
        if (bl) {
            d = -d;
        }
        return d;
    }

    public String longToString(long l) {
        int n;
        int n2;
        boolean bl = false;
        if (l < 0L) {
            if (l == Long.MIN_VALUE) {
                return "-9223372036854775808";
            }
            l = -l;
            bl = true;
        }
        if (this.buf == null) {
            this.buf = new char[32];
        }
        int n3 = 19;
        while (l > Integer.MAX_VALUE) {
            long l2 = l / 1000L;
            n2 = (int)(l - l2 * 1000L);
            l = l2;
            this.buf[n3] = DigitOnes[n2];
            this.buf[n3 - 1] = DigitTens[n2];
            this.buf[n3 - 2] = DigitHundreds[n2];
            n3 -= 3;
        }
        int n4 = (int)l;
        while (n4 >= 65536) {
            n = n4 / 1000;
            n2 = n4 - n * 1000;
            n4 = n;
            this.buf[n3] = DigitOnes[n2];
            this.buf[n3 - 1] = DigitTens[n2];
            this.buf[n3 - 2] = DigitHundreds[n2];
            n3 -= 3;
        }
        while (true) {
            n = n4 * 52429 >>> 19;
            this.buf[n3] = (char)(n4 - n * 10 + 48);
            --n3;
            if (n == 0) break;
            n4 = n;
        }
        if (bl) {
            this.buf[n3--] = 45;
        }
        return new String(this.buf, ++n3, 20 - n3);
    }

    public static long stringToLong(String string) {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        long l = 0L;
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        if (n2 > 0) {
            int n3;
            long l2;
            if (string.charAt(0) == '-') {
                bl = true;
                l2 = Long.MIN_VALUE;
                ++n;
            } else {
                l2 = -9223372036854775807L;
            }
            long l3 = l2 / 10L;
            if (n < n2) {
                if ((n3 = string.charAt(n++) - 48) < 0) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                l = -n3;
            }
            while (n < n2) {
                n3 = string.charAt(n++) - 48;
                if (n3 < 0) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                if (n3 > 9) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                if (l < l3) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                if ((l *= 10L) < l2 + (long)n3) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                l -= (long)n3;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + string + "\"");
        }
        if (bl) {
            if (n > 1) {
                return l;
            }
            throw new NumberFormatException("For input string: \"" + string + "\"");
        }
        return -l;
    }

    private String sqlserverUniqueidentifierToString() {
        byte[] byArray = (byte[])this.data;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[byArray[3] >> 4 & 0xF], cArray[byArray[3] & 0xF], cArray[byArray[2] >> 4 & 0xF], cArray[byArray[2] & 0xF], cArray[byArray[1] >> 4 & 0xF], cArray[byArray[1] & 0xF], cArray[byArray[0] >> 4 & 0xF], cArray[byArray[0] & 0xF], '-', cArray[byArray[5] >> 4 & 0xF], cArray[byArray[5] & 0xF], cArray[byArray[4] >> 4 & 0xF], cArray[byArray[4] & 0xF], '-', cArray[byArray[7] >> 4 & 0xF], cArray[byArray[7] & 0xF], cArray[byArray[6] >> 4 & 0xF], cArray[byArray[6] & 0xF], '-', cArray[byArray[8] >> 4 & 0xF], cArray[byArray[8] & 0xF], cArray[byArray[9] >> 4 & 0xF], cArray[byArray[9] & 0xF], '-', cArray[byArray[10] >> 4 & 0xF], cArray[byArray[10] & 0xF], cArray[byArray[11] >> 4 & 0xF], cArray[byArray[11] & 0xF], cArray[byArray[12] >> 4 & 0xF], cArray[byArray[12] & 0xF], cArray[byArray[13] >> 4 & 0xF], cArray[byArray[13] & 0xF], cArray[byArray[14] >> 4 & 0xF], cArray[byArray[14] & 0xF], cArray[byArray[15] >> 4 & 0xF], cArray[byArray[15] & 0xF]};
        return new String(cArray2);
    }

    private Time applyCalendarToSqlServerTime(Calendar calendar) {
        int[] nArray = new int[3];
        if (this.type == 107) {
            this.sybaseTimeValues(nArray);
        } else {
            this.sqlserverDateTimeValues(nArray);
        }
        calendar = (Calendar)calendar.clone();
        calendar.clear();
        calendar.set(1970, 0, 1, 0, 0, nArray[1]);
        return new Time(calendar.getTime().getTime());
    }

    private Date applyCalendarToSqlServerDate(Calendar calendar) {
        int[] nArray = new int[3];
        this.sqlserverDateTimeValues(nArray);
        calendar = (Calendar)calendar.clone();
        calendar.clear();
        if (this.type == 106) {
            calendar.set(1900, 0, nArray[0]);
        } else {
            calendar.set(1900, 0, nArray[0], 0, 0, nArray[1]);
        }
        return new Date(calendar.getTime().getTime());
    }

    private BaseTimestamp applyCalendarToSqlServerTimestamp(Calendar calendar) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        this.sqlserverDateTimeValues(nArray);
        if (this.type == 107) {
            this.sybaseTimeValues(nArray2);
            calendar = (Calendar)calendar.clone();
            calendar.clear();
            calendar.set(1900, 0, nArray[0], 0, 0, nArray2[1]);
            BaseTimestamp baseTimestamp = new BaseTimestamp(calendar, nArray2[2]);
            return baseTimestamp;
        }
        calendar = (Calendar)calendar.clone();
        calendar.clear();
        calendar.set(1900, 0, nArray[0], 0, 0, nArray[1]);
        BaseTimestamp baseTimestamp = new BaseTimestamp(calendar, nArray[2]);
        return baseTimestamp;
    }

    private Date sybaseDatetoDate() {
        int[] nArray = new int[3];
        this.sqlserverDateTimeValues(nArray);
        ((GregorianCalendar)this.connection.cal).setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        this.connection.cal.set(1900, 0, nArray[0]);
        Calendar cfr_ignored_0 = this.connection.cal;
        Calendar cfr_ignored_1 = this.connection.cal;
        Calendar cfr_ignored_2 = this.connection.cal;
        return new Date(this.connection.cal.get(1) - 1900, this.connection.cal.get(2), this.connection.cal.get(5));
    }

    private String sybaseDatetoString() {
        int[] nArray = new int[3];
        Object var2_2 = null;
        this.sqlserverDateTimeValues(nArray);
        ((GregorianCalendar)this.connection.cal).setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        this.connection.cal.set(1900, 0, nArray[0]);
        Calendar cfr_ignored_0 = this.connection.cal;
        this.datetoString(3, 4, this.connection.cal.get(1));
        Calendar cfr_ignored_1 = this.connection.cal;
        this.datetoString(6, 2, this.connection.cal.get(2) + 1);
        Calendar cfr_ignored_2 = this.connection.cal;
        this.datetoString(9, 2, this.connection.cal.get(5));
        return new String(this.connection.buff);
    }

    void datetoString(int n, int n2, int n3) {
        while (n2 > 0) {
            this.connection.buff[n--] = (char)(48 + n3 % 10);
            n3 /= 10;
            --n2;
        }
        this.connection.buff[4] = 45;
        this.connection.buff[7] = 45;
    }

    private BaseTimestamp sybaseTimeToTimeStamp() {
        int[] nArray = new int[3];
        this.sybaseTimeValues(nArray);
        return new BaseTimestamp(1970, 0, 1, 0, 0, nArray[1], nArray[2], null);
    }

    private void sybaseTimeValues(int[] nArray) {
        byte[] byArray = (byte[])this.data;
        int n = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | byArray[0] << 24;
        int n2 = n / 300;
        int n3 = n - n2 * 300;
        int n4 = n3 * 10 / 3 * 1000000;
        nArray[1] = n2;
        nArray[2] = n4;
    }

    private BaseTimestamp sqlserverDateTimeToTimestamp() {
        int[] nArray = new int[3];
        this.sqlserverDateTimeValues(nArray);
        return new BaseTimestamp(1900, 0, nArray[0], 0, 0, nArray[1], nArray[2], null);
    }

    private void sqlserverDateTimeValues(int[] nArray) {
        int n;
        int n2;
        byte[] byArray = (byte[])this.data;
        int n3 = 0;
        if (this.type == 102 || this.type == 104) {
            int n4;
            if (this.type == 102) {
                n2 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | byArray[3] << 24;
                n4 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | byArray[7] << 24;
            } else {
                n2 = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | byArray[0] << 24;
                n4 = byArray[7] & 0xFF | (byArray[6] & 0xFF) << 8 | (byArray[5] & 0xFF) << 16 | byArray[4] << 24;
            }
            n = n4 / 300;
            int n5 = n4 - n * 300;
            n3 = this.type == 102 ? (n5 * 10 + 1) / 3 * 1000000 : n5 * 10 / 3 * 1000000;
            nArray[2] = n3;
        } else {
            if (this.type == 103) {
                n2 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
                n = (byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8) * 60;
            } else {
                n2 = byArray[1] & 0xFF | (byArray[0] & 0xFF) << 8;
                n = (byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8) * 60;
            }
            nArray[2] = 0;
        }
        if (this.type == 106) {
            n2 = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | byArray[0] << 24;
            nArray[1] = 0;
        }
        nArray[0] = ++n2;
        nArray[1] = n;
    }

    private BaseTimestamp oracleDateToTimestamp(Calendar calendar) {
        byte[] byArray = (byte[])this.data;
        int n = byArray[0] >= 0 ? byArray[0] : 256 + byArray[0];
        int n2 = byArray[1] >= 0 ? byArray[1] : 256 + byArray[1];
        int n3 = (n - 100) * 100 + (n2 - 100);
        return new BaseTimestamp(n3, byArray[2] - 1, byArray[3], byArray[4] - 1, byArray[5] - 1, byArray[6] - 1, 0, calendar);
    }

    private Date oracleDateToDate() {
        byte[] byArray = (byte[])this.data;
        int n = byArray[0] >= 0 ? byArray[0] : 256 + byArray[0];
        int n2 = byArray[1] >= 0 ? byArray[1] : 256 + byArray[1];
        int n3 = (n - 100) * 100 + (n2 - 100);
        return new Date(n3 - 1900, byArray[2] - 1, byArray[3]);
    }

    private BaseTimestamp oracleTimestampToTimestamp(Calendar calendar) {
        byte[] byArray = (byte[])this.data;
        int n = this.nativeDataLen;
        int n2 = byArray[0] >= 0 ? byArray[0] : 256 + byArray[0];
        int n3 = byArray[1] >= 0 ? byArray[1] : 256 + byArray[1];
        int n4 = (n2 - 100) * 100 + (n3 - 100);
        int n5 = 0;
        if (n > 7) {
            n5 = ((byArray[7] >= 0 ? byArray[7] : 256 + byArray[7]) << 24) + ((byArray[8] >= 0 ? byArray[8] : 256 + byArray[8]) << 16) + ((byArray[9] >= 0 ? byArray[9] : 256 + byArray[9]) << 8) + (byArray[10] >= 0 ? byArray[10] : 256 + byArray[10]);
        }
        return new BaseTimestamp(n4, byArray[2] - 1, byArray[3], byArray[4] - 1, byArray[5] - 1, byArray[6] - 1, n5, calendar);
    }

    static int insertDateTimeComponent(char[] cArray, int n, int n2, int n3) {
        for (int i = 1; i <= n3; ++i) {
            int n4 = (int)Math.pow(10.0, n3 - i);
            int n5 = n2 / n4;
            cArray[n + i - 1] = (char)(48 + n5);
            n2 -= n5 * n4;
        }
        return n3;
    }

    private BaseTimestamp oracleTimestampWithLocalTimeZoneToTimestamp() {
        boolean bl = false;
        byte[] byArray = (byte[])this.data;
        int n = this.nativeDataLen;
        int n2 = byArray[0] >= 0 ? byArray[0] : 256 + byArray[0];
        int n3 = byArray[1] >= 0 ? byArray[1] : 256 + byArray[1];
        int n4 = (n2 - 100) * 100 + (n3 - 100);
        byte by = byArray[2];
        byte by2 = byArray[3];
        int n5 = byArray[4] - 1;
        int n6 = byArray[5] - 1;
        int n7 = byArray[6] - 1;
        int n8 = 0;
        if (n > 7) {
            n8 = ((byArray[7] >= 0 ? byArray[7] : 256 + byArray[7]) << 24) + ((byArray[8] >= 0 ? byArray[8] : 256 + byArray[8]) << 16) + ((byArray[9] >= 0 ? byArray[9] : 256 + byArray[9]) << 8) + (byArray[10] >= 0 ? byArray[10] : 256 + byArray[10]);
        }
        if (this.s_calendar == null) {
            this.s_calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        }
        this.s_calendar.clear();
        if (n4 < 0) {
            this.s_calendar.set(0, 0);
            this.s_calendar.set(-n4, by - 1, by2, n5, n6, n7);
        } else {
            this.s_calendar.set(n4, by - 1, by2, n5, n6, n7);
        }
        if (bl) {
            System.out.println("Before");
            System.out.println(this.s_calendar.getTime().toString());
            System.out.println("Calendar.getYear=" + this.s_calendar.get(1));
            System.out.println("Calendar.getMonth=" + this.s_calendar.get(2));
            System.out.println("Calendar.getDay=" + this.s_calendar.get(5));
            System.out.println("Calendar.getHour=" + this.s_calendar.get(11));
            System.out.println("Calendar.getMinute=" + this.s_calendar.get(12));
            System.out.println("Calendar.getSecond=" + this.s_calendar.get(13));
            System.out.println("Applying TZ adjustment: tzHours=" + this.oracleLTZHours + ",tzMinutes=" + this.oracleLTZMinutes);
        }
        this.s_calendar.add(10, this.oracleLTZHours);
        this.s_calendar.add(12, this.oracleLTZMinutes);
        if (bl) {
            System.out.println("After");
            System.out.println(this.s_calendar.getTime().toString());
            System.out.println("Calendar.getYear=" + this.s_calendar.get(1));
            System.out.println("Calendar.getMonth=" + this.s_calendar.get(2));
            System.out.println("Calendar.getDay=" + this.s_calendar.get(5));
            System.out.println("Calendar.getHour=" + this.s_calendar.get(11));
            System.out.println("Calendar.getMinute=" + this.s_calendar.get(12));
            System.out.println("Calendar.getSecond=" + this.s_calendar.get(13));
        }
        return new BaseTimestamp(this.s_calendar.get(1), this.s_calendar.get(2), this.s_calendar.get(5), this.s_calendar.get(11), this.s_calendar.get(12), this.s_calendar.get(13), n8, null);
    }

    private Object oracleTimestampWithTimeZoneToTimestamp(Calendar calendar, boolean bl) {
        byte[] byArray = (byte[])this.data;
        int n = 0;
        int n2 = byArray[0 + n] >= 0 ? byArray[0 + n] : 256 + byArray[0 + n];
        int n3 = byArray[1 + n] >= 0 ? byArray[1 + n] : 256 + byArray[1 + n];
        int n4 = (n2 - 100) * 100 + (n3 - 100);
        byte by = byArray[2 + n];
        byte by2 = byArray[3 + n];
        int n5 = byArray[4 + n] - 1;
        int n6 = byArray[5 + n] - 1;
        int n7 = byArray[6 + n] - 1;
        if (this.s_calendar == null) {
            this.s_calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        }
        this.s_calendar.clear();
        if (n4 < 0) {
            this.s_calendar.set(0, 0);
            this.s_calendar.set(-n4, by - 1, by2, n5, n6, n7);
        } else {
            this.s_calendar.set(n4, by - 1, by2, n5, n6, n7);
        }
        int n8 = byArray[11 + n] - 20;
        int n9 = byArray[12 + n] - 60;
        this.s_calendar.add(10, n8);
        this.s_calendar.add(12, n9);
        int n10 = 32;
        if (n8 < 0) {
            n10 = 45;
            n8 = Math.abs(n8);
        } else if (n8 > 0) {
            n10 = 43;
        }
        int n11 = ((byArray[7 + n] >= 0 ? byArray[7 + n] : 256 + byArray[7 + n]) << 24) + ((byArray[8 + n] >= 0 ? byArray[8 + n] : 256 + byArray[8 + n]) << 16) + ((byArray[9 + n] >= 0 ? byArray[9 + n] : 256 + byArray[9 + n]) << 8) + (byArray[10 + n] >= 0 ? byArray[10 + n] : 256 + byArray[10 + n]);
        if (bl) {
            return new BaseTimestamp(this.s_calendar.get(1), this.s_calendar.get(2), this.s_calendar.get(5), this.s_calendar.get(11), this.s_calendar.get(12), this.s_calendar.get(13), n11, calendar);
        }
        int n12 = scalingFactors[this.oracleTZScale];
        if (n11 != 0) {
            n11 /= n12;
        }
        char[] cArray = new char[27 + this.oracleTZScale + (n4 < 0 ? 1 : 0)];
        int n13 = 0;
        if (n4 < 0) {
            cArray[n13++] = 45;
        }
        n13 += BaseData.insertDateTimeComponent(cArray, n13, this.s_calendar.get(1), 4);
        cArray[n13++] = 45;
        n13 += BaseData.insertDateTimeComponent(cArray, n13, this.s_calendar.get(2) + 1, 2);
        cArray[n13++] = 45;
        n13 += BaseData.insertDateTimeComponent(cArray, n13, this.s_calendar.get(5), 2);
        cArray[n13++] = 32;
        n13 += BaseData.insertDateTimeComponent(cArray, n13, this.s_calendar.get(11), 2);
        cArray[n13++] = 58;
        n13 += BaseData.insertDateTimeComponent(cArray, n13, this.s_calendar.get(12), 2);
        cArray[n13++] = 58;
        n13 += BaseData.insertDateTimeComponent(cArray, n13, this.s_calendar.get(13), 2);
        cArray[n13++] = 46;
        n13 += BaseData.insertDateTimeComponent(cArray, n13, n11, this.oracleTZScale);
        cArray[n13++] = 32;
        cArray[n13++] = n10;
        n13 += BaseData.insertDateTimeComponent(cArray, n13, n8, 2);
        cArray[n13++] = 58;
        BaseData.insertDateTimeComponent(cArray, n13, Math.abs(n9), 2);
        return new String(cArray);
    }
}

