/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.columns;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.columns.SequeLinkColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import macromedia.jdbc.sequelink.utilities.ObjectArray;
import macromedia.jdbc.slbase.BaseData;
import macromedia.sequelink.ctxt.stmt.StatementContext;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.slutil.UtilException;

public class SequeLinkNumericColumn
extends SequeLinkColumn {
    private ObjectArray array = new ObjectArray();

    public SequeLinkNumericColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe, int n) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, n, 8);
    }

    protected void setBindInfo() {
        this.sqlnkType = 11;
        this.sqlnkSize = this.precision;
    }

    protected void readDataFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        this.array.add(sspInputStream.readSSPBcdType(this.scale));
    }

    protected void readNull() {
        this.array.add(null);
    }

    private String getValueString(int n, String string, int n2) {
        StringBuffer stringBuffer;
        int n3 = string.length() - n2;
        if (n3 == 0) {
            return (n < 0 ? "-0." : "0.") + string;
        }
        if (n3 > 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n3, '.');
            if (n < 0) {
                stringBuffer.insert(0, '-');
            }
        } else {
            stringBuffer = new StringBuffer(3 - n3 + string.length());
            stringBuffer.append(n < 0 ? "-0." : "0.");
            for (int i = 0; i < -n3; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public BaseData getData(int n, int n2, DiagnosticList diagnosticList) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.array.get(n2);
        if (bigDecimal != null && n == 10) {
            BigInteger bigInteger = bigDecimal.unscaledValue();
            String string = bigDecimal.scale() == 0 ? bigInteger.toString() : this.getValueString(bigDecimal.signum(), bigInteger.abs().toString(), bigDecimal.scale());
            this.myBaseData.setString(string);
        } else {
            this.myBaseData.setBigDecimal((BigDecimal)this.array.get(n2));
        }
        return this.myBaseData;
    }

    public void clearData() {
        this.array.reset();
    }
}

