/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds;

import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.rds.RdsRequestImpl;
import coldfusion.debugger.rds.RdsResponseImpl;
import coldfusion.rds.RdsGlobals;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.security.AuthorizedUser;
import coldfusion.security.ESAPIUtils;
import coldfusion.util.RB;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class RdsServlet
extends HttpServlet
implements RdsGlobals {
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpServletResponse resp;
        HttpServletRequest req;
        try {
            req = request;
            resp = response;
        }
        catch (ClassCastException e) {
            throw new ServletException(RB.getString((Object)((Object)this), (String)"RdsServlet.NonHttp"));
        }
        RdsRequestImpl rdsReq = new RdsRequestImpl();
        RdsResponseImpl rdsResp = new RdsResponseImpl();
        rdsReq.init(req);
        rdsResp.init(resp);
        try {
            this.processCmd(rdsReq, rdsResp, null);
        }
        catch (Throwable th) {
            CFDebuggerLogger.log(th);
            rdsResp.setError(th);
        }
        this.doPostProcessCmd(rdsReq, rdsResp);
    }

    protected abstract void processCmd(RdsRequest var1, RdsResponse var2, AuthorizedUser var3) throws ServletException, IOException;

    private void doPostProcessCmd(RdsRequestImpl request, RdsResponseImpl response) throws IOException, ServletException {
        response.finish();
        request.reset();
        response.reset();
    }

    public String getInitParameter(String name) {
        String value = this.getServletConfig().getInitParameter(name);
        if (value == null) {
            value = this.getServletContext().getInitParameter(name);
        }
        return value;
    }

    public String getRequiredInitParameter(String name) throws ServletException {
        String value = this.getInitParameter(name);
        if (value == null) {
            throw new ServletException(RB.getString((Object)((Object)this), (String)"RdsServlet.MissingRequiredInitParameter", (Object)ESAPIUtils.encodeForHTML((String)name, (boolean)false)));
        }
        return value;
    }

    public int getRequiredInitParameterAsInt(String name) throws ServletException {
        String value = this.getRequiredInitParameter(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ServletException(RB.getString((Object)((Object)this), (String)"RdsServlet.InitParameterNotAnInt", (Object)ESAPIUtils.encodeForHTML((String)name, (boolean)false)));
        }
    }

    public boolean checkAuthorization(String username, String password) {
        return true;
    }

    public Properties getInitParameters() {
        String name;
        Properties props = new Properties();
        ServletContext ctx = this.getServletContext();
        ServletConfig cfg = this.getServletConfig();
        Enumeration names = ctx.getInitParameterNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            props.put(name, ctx.getInitParameter(name));
        }
        names = cfg.getInitParameterNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            props.put(name, cfg.getInitParameter(name));
        }
        return props;
    }

    boolean isSecure() {
        return true;
    }
}

