/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.CFDebuggerUtils;
import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.debugger.ClassMethodLineTableCache;
import coldfusion.debugger.ClientDebugSession;
import coldfusion.debugger.JVMDebugThread;
import coldfusion.debugger.JVMDebugThreadManager;
import coldfusion.debugger.LineLocationWrapper;
import coldfusion.debugger.LocatableEventWrapper;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import java.util.List;
import java.util.Map;

public abstract class DebugEventHandler {
    CFJVMDebugManager debugManager = null;

    public DebugEventHandler(CFJVMDebugManager debugManager) {
        this.debugManager = debugManager;
    }

    public abstract void handleEvent(Event var1, Map var2) throws Throwable;

    public ClientDebugSession findClientSession(ThreadReference th, LocatableEvent breakpointEvent, boolean attach) throws Throwable {
        ClientDebugSession[] sessions = this.debugManager.getClientSessions();
        if (sessions == null || sessions.length == 0) {
            return null;
        }
        if (sessions.length == 1) {
            if (attach) {
                this.attachClientSessionWithRequest(sessions[0], th);
            }
            return sessions[0];
        }
        String debugSessionId = CFDebuggerUtils.getSessionId(th);
        if (debugSessionId == null) {
            if (!th.isAtBreakpoint() && !th.isSuspended()) {
                return null;
            }
            if (breakpointEvent != null) {
                Location loc = breakpointEvent.location();
                int lineNum = loc.lineNumber();
                String sourcePath = loc.sourcePath();
                for (int i = 0; i < sessions.length; ++i) {
                    ClientDebugSession session = sessions[i];
                    if (!session.isBreakpointSet(sourcePath, lineNum)) continue;
                    if (attach) {
                        this.attachClientSessionWithRequest(session, th);
                    }
                    return session;
                }
                if (attach) {
                    this.attachClientSessionWithRequest(sessions[0], th);
                }
                return sessions[0];
            }
        } else {
            for (int i = 0; i < sessions.length; ++i) {
                if (!sessions[i].getSessionId().equals(debugSessionId)) continue;
                return sessions[i];
            }
        }
        return null;
    }

    public void attachClientSessionWithRequest(ClientDebugSession session, ThreadReference th) throws Throwable {
        JVMDebugThread debugThread = JVMDebugThreadManager.setThread(th);
        try {
            CFDebuggerUtils.setSessionId(th, session.getSessionId());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        debugThread.setSession(session);
    }

    public static int getOpCode(Location loc) {
        int default_return_value = -1;
        try {
            Method mth = loc.method();
            if (mth == null) {
                return default_return_value;
            }
            byte[] code = mth.bytecodes();
            long index = loc.codeIndex();
            return code[(int)index] & 0xFF;
        }
        catch (Throwable throwable) {
            return default_return_value;
        }
    }

    public static int getLineNumberForLocation(Location loc) {
        int lineNum = ClassMethodLineTableCache.checkCodeIndex(loc.method(), loc.codeIndex());
        if (lineNum > 0 || lineNum == 0) {
            return lineNum;
        }
        try {
            long codeIndex = loc.codeIndex();
            Method mth = loc.method();
            List<Location> lineLocations = mth.allLineLocations();
            for (Location loc1 : lineLocations) {
                if (loc1.codeIndex() != codeIndex) continue;
                return loc1.lineNumber();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public static LocatableEvent getLocatableEventForLocation(Location loc, LocatableEvent orgEvt) {
        int lineNumber = DebugEventHandler.getLineNumberForLocation(loc);
        LocatableEvent locEvent = orgEvt;
        if (lineNumber == 0) {
            return null;
        }
        if (lineNumber > 0) {
            LineLocationWrapper newLoc = new LineLocationWrapper(loc, lineNumber);
            short eventType = 0;
            if (orgEvt instanceof BreakpointEvent) {
                eventType = 2;
            } else if (orgEvt instanceof StepEvent) {
                eventType = 1;
            } else if (orgEvt instanceof ExceptionEvent) {
                eventType = 3;
            }
            locEvent = new LocatableEventWrapper(orgEvt, newLoc, eventType);
        }
        return locEvent;
    }

    public static boolean isCfmlFile(String path) {
        int index = path.lastIndexOf(46);
        if (index < 0) {
            return false;
        }
        String ext = path.substring(index + 1).toLowerCase();
        return ext.equals("cfm") || ext.equals("cfml") || ext.equals("cfc") || ext.equals("cfr");
    }
}

