/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debug;

import coldfusion.debug.AMFDebugger;
import coldfusion.debug.DummyDeubgRequestHandler;
import coldfusion.debug.LineDebuggerConfig;
import coldfusion.debug.buildersession.CFBuilderSession;
import coldfusion.debug.core.CFMLDebugger;
import coldfusion.debug.core.Debugger;
import coldfusion.debugger.rds.handler.DebuggerRDSRequestManager;
import coldfusion.inspect.weinre.RemoteInspectionConfig;
import coldfusion.log.CFLogs;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.server.ConfigMap;
import coldfusion.server.ConfigMapListener;
import coldfusion.server.DebuggingService;
import coldfusion.server.RuntimeService;
import coldfusion.server.Service;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class DebuggingServiceImpl
extends ServiceBase
implements DebuggingService {
    private File file = null;
    private static ThreadLocal debugger;
    private static ThreadLocal showDebug;
    private ServletException initException = null;
    private ConfigMap settings = null;
    private ConfigMap iplist = null;
    private ConfigMap lineDebugSettings = null;
    private boolean enable;
    private long debuggerStartTime = 0L;
    private ConfigMap remoteInspectionSettings = null;
    private RemoteInspectionConfig remoteInspectionConfig = null;
    private HashMap<String, CFBuilderSession> listOfBuilderSessions = new HashMap();

    public DebuggingServiceImpl(File f) {
        this.file = f;
        this.setEnableWatch(true);
        this.setWatchFile(f);
    }

    public Debugger getDebugger() {
        if (this.debuggerStartTime == 0L) {
            this.debuggerStartTime = System.currentTimeMillis();
        }
        try {
            return (Debugger)debugger.get();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public long getDebuggerStartTime() {
        return this.debuggerStartTime;
    }

    public Map getSettings() {
        return this.settings;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnabled(boolean b) {
        this.enable = b;
        this.settings.put((Object)"enabled", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    public boolean isRobustEnabled() {
        Object enablerobustexception = AppHelper.getApplicationSetting((String)"enablerobustexception");
        if (enablerobustexception != null) {
            return Cast._boolean((Object)enablerobustexception);
        }
        Boolean b = (Boolean)this.settings.get((Object)"robust_enabled");
        return b == null ? false : b;
    }

    public boolean isDeveloperEnabled() {
        Boolean b = (Boolean)this.settings.get((Object)"developer_enabled");
        return b == null ? false : b;
    }

    public boolean isRobustEnabledInAdministrator() {
        Boolean b = (Boolean)this.settings.get((Object)"robust_enabled");
        return b == null ? false : b;
    }

    public void setRobustEnabled(boolean b) {
        this.settings.put((Object)"robust_enabled", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeveloperEnabled(boolean b) throws ServiceException {
        RuntimeService runtimeSvc = ServiceFactory.getRuntimeService();
        if (b) {
            FileOutputStream fileOut = null;
            try {
                Properties properties = new Properties();
                properties.setProperty("istrustedcache", runtimeSvc.isTrustedCache() + "");
                properties.setProperty("robust_enabled", this.isRobustEnabledInAdministrator() + "");
                properties.setProperty("restdiscovery", runtimeSvc.isAllowRestDiscovery() + "");
                File devproffile = new File(this.file.getParent() + File.separatorChar + "devprof.properties");
                fileOut = new FileOutputStream(devproffile);
                properties.store(fileOut, "Settings before dev profile was enabled.");
            }
            catch (FileNotFoundException e) {
                CFLogs.SERVER_LOG.warn((Object)e.getLocalizedMessage());
            }
            catch (IOException e) {
                CFLogs.SERVER_LOG.warn((Object)e.getLocalizedMessage());
            }
            finally {
                if (fileOut != null) {
                    try {
                        fileOut.close();
                    }
                    catch (IOException e) {
                        CFLogs.SERVER_LOG.warn((Object)e.getLocalizedMessage());
                    }
                }
            }
            this.settings.put((Object)"developer_enabled", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
            this.settings.put((Object)"robust_enabled", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
            runtimeSvc.setTrustedCache(!b);
            runtimeSvc.setAllowRestDiscovery(b);
        }
        if (!b) {
            Properties prop = new Properties();
            FileInputStream input = null;
            File devProf = new File(this.file.getParent() + File.separatorChar + "devprof.properties");
            if (devProf != null && devProf.exists()) {
                try {
                    input = new FileInputStream(devProf);
                    prop.load(input);
                    runtimeSvc.setTrustedCache(Boolean.parseBoolean(prop.getProperty("istrustedcache")));
                    runtimeSvc.setAllowRestDiscovery(Boolean.parseBoolean(prop.getProperty("restdiscovery")));
                    this.settings.put((Object)"robust_enabled", (Object)Boolean.parseBoolean(prop.getProperty("robust_enabled")));
                    this.settings.put((Object)"developer_enabled", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
                }
                catch (IOException ex) {
                    CFLogs.SERVER_LOG.warn((Object)ex.getLocalizedMessage());
                }
                finally {
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (IOException e) {
                            CFLogs.SERVER_LOG.warn((Object)e.getLocalizedMessage());
                        }
                    }
                }
            } else {
                this.settings.put((Object)"developer_enabled", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
                this.settings.put((Object)"robust_enabled", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
                runtimeSvc.setTrustedCache(!b);
                runtimeSvc.setAllowRestDiscovery(b);
            }
        }
    }

    public boolean isTimerEnabled() {
        if (this.settings.containsKey((Object)"TIMER")) {
            return (Boolean)this.settings.get((Object)"TIMER");
        }
        return false;
    }

    public boolean isFlashFormCompileErrorsEnabled() {
        if (this.settings.containsKey((Object)"FLASHFORMCOMPILEERRORS")) {
            return (Boolean)this.settings.get((Object)"FLASHFORMCOMPILEERRORS");
        }
        return false;
    }

    public boolean check(String event) {
        try {
            Boolean result = (Boolean)this.settings.get((Object)event);
            return result;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean check(int type) {
        if (!this.isEnabled() || !this.getShowdebug()) {
            return false;
        }
        try {
            switch (type) {
                case 1: {
                    Boolean result = (Boolean)this.settings.get((Object)"Template");
                    return result;
                }
                case 2: {
                    Boolean result = (Boolean)this.settings.get((Object)"ExecutionTime");
                    return result;
                }
                case 3: {
                    Boolean result = (Boolean)this.settings.get((Object)"Database");
                    return result;
                }
                case 4: {
                    Boolean result = (Boolean)this.settings.get((Object)"SqlQuery");
                    return result;
                }
                case 14: {
                    Boolean result = (Boolean)this.settings.get((Object)"ORMSqlQuery");
                    return true;
                }
                case 5: {
                    Boolean result = (Boolean)this.settings.get((Object)"ObjectQuery");
                    return result;
                }
                case 7: {
                    Boolean result = (Boolean)this.settings.get((Object)"Trace");
                    return result;
                }
                case 10: {
                    Boolean result = (Boolean)this.settings.get((Object)"LockWarning");
                    return result;
                }
                case 8: {
                    Boolean result = (Boolean)this.settings.get((Object)"Exception");
                    return result;
                }
                case 200: {
                    Boolean result = (Boolean)this.settings.get((Object)"Http");
                    return result;
                }
                case 100: {
                    Boolean result = (Boolean)this.settings.get((Object)"Variables");
                    return result;
                }
                case 101: {
                    Boolean result = (Boolean)this.settings.get((Object)"ApplicationVar");
                    return result;
                }
                case 102: {
                    Boolean result = (Boolean)this.settings.get((Object)"CGIVar");
                    return result;
                }
                case 103: {
                    Boolean result = (Boolean)this.settings.get((Object)"ClientVar");
                    return result;
                }
                case 104: {
                    Boolean result = (Boolean)this.settings.get((Object)"CookieVar");
                    return result;
                }
                case 105: {
                    Boolean result = (Boolean)this.settings.get((Object)"FormVar");
                    return result;
                }
                case 106: {
                    Boolean result = (Boolean)this.settings.get((Object)"RequestVar");
                    return result;
                }
                case 107: {
                    Boolean result = (Boolean)this.settings.get((Object)"ServerVar");
                    return result;
                }
                case 108: {
                    Boolean result = (Boolean)this.settings.get((Object)"SessionVar");
                    return result;
                }
                case 109: {
                    Boolean result = (Boolean)this.settings.get((Object)"URLVar");
                    return result;
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean getShowdebug() {
        Boolean b = (Boolean)showDebug.get();
        return b == null ? true : b;
    }

    public boolean getShowAjaxDebug() {
        Object appCFCDebugSetting = AppHelper.getApplicationSetting((String)"showajaxdebugoutput");
        if (appCFCDebugSetting == null || !Cast._boolean((Object)appCFCDebugSetting)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void setShowdebug(boolean b) {
        showDebug.set(b ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isAjaxDebugEnabled() {
        Boolean b = (Boolean)this.settings.get((Object)"ajax_enabled");
        return b == null ? false : b;
    }

    public void setAjaxDebugEnabled(boolean b) {
        this.settings.put((Object)"ajax_enabled", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    public boolean isValidIP(String ip) {
        Boolean ipPresentInAppSetting = this.isValidIPInAppSetting(ip);
        if (ipPresentInAppSetting != null) {
            return ipPresentInAppSetting;
        }
        if (this.iplist == null) {
            return true;
        }
        if (ip == null) {
            return false;
        }
        String list = (String)this.iplist.get((Object)"iplist");
        if (list != null && list.length() > 0) {
            return CFPage.ListFindNoCase((String)list, (String)ip) != 0;
        }
        return true;
    }

    public Boolean isValidIPInAppSetting(String ip) {
        String ipListInAppSetting = (String)AppHelper.getApplicationSetting((String)"debuggingipaddresses");
        if (ip == null) {
            return false;
        }
        if (ipListInAppSetting == null) {
            return null;
        }
        if (ipListInAppSetting.length() == 0) {
            return true;
        }
        if (ipListInAppSetting.length() > 0) {
            return CFPage.ListFindNoCase((String)ipListInAppSetting, (String)ip) != 0;
        }
        return false;
    }

    public Map getIplist() {
        return this.iplist;
    }

    public String getDebugTemplate() {
        return (String)this.settings.get((Object)"debug_template");
    }

    public String getXMLTemplate() {
        return (String)this.settings.get((Object)"xml_template");
    }

    public void load() throws ServiceException {
        Vector v = null;
        try {
            v = (Vector)this.deserialize(this.file);
            this.settings = (ConfigMap)v.elementAt(0);
            this.iplist = (ConfigMap)v.elementAt(1);
            if (v.size() > 2) {
                this.lineDebugSettings = (ConfigMap)v.elementAt(2);
            }
            if (v.size() > 3) {
                this.remoteInspectionSettings = (ConfigMap)v.elementAt(3);
            }
            this.remoteInspectionConfig = RemoteInspectionConfig.getInstance();
            if (this.remoteInspectionSettings == null) {
                this.remoteInspectionSettings = this.remoteInspectionConfig.getRemoteInspectionSettings();
            }
            this.remoteInspectionConfig.setRemoteInspectionSettings(this.remoteInspectionSettings);
            LineDebuggerConfig.getInstance().setDebuggingSettings(this.lineDebugSettings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException((Throwable)ex);
        }
        Object o = this.settings.get((Object)"enabled");
        this.enable = o != null && o instanceof Boolean ? (Boolean)o : false;
        if (!this.getSettings().containsKey("TIMER")) {
            this.settings.put((Object)"TIMER", (Object)new Boolean(false));
        }
        if (!this.getSettings().containsKey("FLASHFORMCOMPILEERRORS")) {
            this.settings.put((Object)"FLASHFORMCOMPILEERRORS", (Object)new Boolean(false));
        }
        this.settings.init((Service)this, "settings");
        this.iplist.init((Service)this, "iplist");
        this.settings.setConfigMapListener((ConfigMapListener)this);
        this.iplist.setConfigMapListener((ConfigMapListener)this);
        this.remoteInspectionSettings.setConfigMapListener((ConfigMapListener)this);
    }

    public void storeRemoteInspectionUI() throws ServiceException {
        this.remoteInspectionSettings = this.remoteInspectionConfig.getRemoteInspectionSettings();
        this.remoteInspectionSettings.setConfigMapListener((ConfigMapListener)this);
        this.store();
    }

    public void store() throws ServiceException {
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.addElement(this.settings);
        v.addElement(this.iplist);
        this.lineDebugSettings = LineDebuggerConfig.getInstance().getDebuggingSettings();
        if (this.lineDebugSettings != null) {
            v.addElement(this.lineDebugSettings);
        }
        if (this.remoteInspectionSettings != null) {
            v.addElement(this.remoteInspectionSettings);
            this.remoteInspectionConfig.setRemoteInspectionSettings(this.remoteInspectionSettings);
        }
        this.serialize(v, this.file);
    }

    public void reset(int type) {
        Object d = null;
        switch (type) {
            case 1: {
                d = new CFMLDebugger();
                break;
            }
            case 2: {
                d = new AMFDebugger();
                break;
            }
            default: {
                d = new CFMLDebugger();
            }
        }
        debugger.set(d);
        Boolean b = Boolean.TRUE;
        showDebug.set(b);
        this.debuggerStartTime = 0L;
    }

    public void reset() {
        debugger.set(null);
        showDebug.set(null);
    }

    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("settings.keys", "developer_enabled,ajax_enabled,enabled,general,lockwarning,lockrelease,lockacquire,lockcreate,executiontime,template,database,sqlquery,objectquery,storedprocedure,variables,trace,exception,http,applicationvar,cgivar,clientvar,cookievar,formvar,requestvar,servervar,sessionvar,urlvar,template_highlight_minimum,debug_template,xml_template,robust_enabled,template_mode,timer,flashFormCompileErrors");
            this.rb.put("settings.types", "java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Number,java.lang.String,java.lang.String,java.lang.Boolean,java.lang.String,java.lang.Boolean,java.lang.Boolean");
            this.rb.put("settings.formats", "coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter");
            this.rb.put("iplist.keys", "iplist");
            this.rb.put("iplist.types", "java.lang.String");
            this.rb.put("iplist.formats", "coldfusion.server.StringFormatter");
        }
        return this.rb;
    }

    public boolean isLineDebuggerEnabled() {
        return LineDebuggerConfig.getInstance().isLineDebuggerEnabled();
    }

    public boolean isRemoteInspectionEnabled() {
        return this.remoteInspectionConfig.isRemoteInspectionEnabled();
    }

    public boolean isAdvanceSettingsEnabled() {
        return this.remoteInspectionConfig.isAdvanceSettingsEnabled();
    }

    public void setLineDebuggerEnabled(boolean enable) throws ServiceException {
        try {
            LineDebuggerConfig.getInstance().setLineDebuggerEnabled(enable);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void setRemoteInspectionEnabled(boolean enable) {
        this.remoteInspectionConfig.setRemoteInspectionEnabled(enable);
        if (!enable) {
            try {
                this.remoteInspectionConfig.stopWeinreServer();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
    }

    public void enableWeinreAdvanceSettings(boolean enable) {
        this.remoteInspectionConfig.enableWeinreAdvanceSettings(enable);
    }

    public void setWeinreServerlocation(String weinreServerLoc) {
        this.remoteInspectionConfig.setWeinreServerLocation(weinreServerLoc);
    }

    public int getLineDebuggerPort() throws ServiceException {
        try {
            return LineDebuggerConfig.getInstance().getDebuggerPort();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public String getWeinreServerUrl() {
        return this.remoteInspectionConfig.getWeinreServerLocation();
    }

    public void setLineDebuggerPort(int portNum) throws ServiceException {
        try {
            LineDebuggerConfig.getInstance().setDebuggerPort(portNum);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public int getMaxDebuggingSessions() {
        return LineDebuggerConfig.getInstance().getMaxDebuggingSessions();
    }

    public void setMaxDebuggingSessions(int maxSessions) {
        LineDebuggerConfig.getInstance().setMaxDebuggingSessions(maxSessions);
    }

    public void stopLineDebugger() {
        LineDebuggerConfig.getInstance().stopLineDebugger();
    }

    public boolean isLineDebuggerRunning() {
        return LineDebuggerConfig.getInstance().isLineDebuggerRunning();
    }

    public void startDebugger() throws ServiceException {
        try {
            LineDebuggerConfig.getInstance().startDebugger();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void startWeinreServer() throws ServiceException {
        try {
            this.remoteInspectionConfig.startWeinreServer();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void startWeinreServerOnFreePort() throws ServiceException {
        try {
            this.remoteInspectionConfig.startWeinreServerOnFreePort();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void restartWeinreServerOnFreePort() throws ServiceException {
        try {
            this.remoteInspectionConfig.restartWeinreServerOnFreePort();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void stopWeinreServer() throws ServiceException {
        try {
            this.remoteInspectionConfig.stopWeinreServer();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void restartWeinreServer() throws ServiceException {
        try {
            this.remoteInspectionConfig.restartWeinreServer();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void restartDebugger() throws ServiceException {
        try {
            LineDebuggerConfig.getInstance().restartDebugger();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Map getLineDebugSettings() {
        return this.lineDebugSettings;
    }

    public Map getRemoteInspectionSettings() {
        return this.remoteInspectionSettings;
    }

    public Boolean isLocalWeinreServerAvailable() {
        return this.remoteInspectionConfig.isLocalWeinreServerInstalled();
    }

    public Boolean isWeinreServerRunning() throws ServiceException {
        Boolean flag = this.remoteInspectionConfig.isWeinreServerRunning();
        return flag;
    }

    public String getLocalInspectionURL() {
        String localUrl = this.remoteInspectionConfig.getLocalInspectionURL();
        return localUrl;
    }

    public Array getAllLocalIpAddresses() {
        return this.remoteInspectionConfig.getAllLocalIpAddresses();
    }

    public void setWeinreServerType(String serverType) {
        this.remoteInspectionConfig.setWeinreServerType(serverType);
    }

    public String getWeinreServerType() {
        return this.remoteInspectionConfig.getWeinreServerType();
    }

    public String getLocalWeinreIpAddress() {
        return this.remoteInspectionConfig.getLocalWeinreIpAddress();
    }

    public void setLocalWeinreIpAddress(String ipAddress) {
        this.remoteInspectionConfig.setLocalWeinreIpAddress(ipAddress);
    }

    public String getLocalWeinrePort() {
        return this.remoteInspectionConfig.getLocalWeinrePort();
    }

    public void setLocalWeinrePort(String port) {
        this.remoteInspectionConfig.setLocalWeinrePort(port);
    }

    public String getLocalWeinreServerDeathTimeOut() {
        return this.remoteInspectionConfig.getLocalWeinreServerDeathTimeOut();
    }

    public void setLocalWeinreServerDeathTimeOut(String deathTimeout) {
        this.remoteInspectionConfig.setLocalWeinreServerDeathTimeOut(deathTimeout);
    }

    public void setLocalWeinreServerReadTimeOut(String readTimeOut) {
        this.remoteInspectionConfig.setLocalWeinreServerReadTimeOut(readTimeOut);
    }

    public String getLocalWeinreServerReadTimeOut() {
        return this.remoteInspectionConfig.getLocalWeinreServerReadTimeOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDebugJettyServerIpForFile(String fileName) {
        HashMap<String, CFBuilderSession> hashMap = this.listOfBuilderSessions;
        synchronized (hashMap) {
            for (CFBuilderSession session : this.listOfBuilderSessions.values()) {
                if (!session.isFileinThisSession(fileName)) continue;
                return session.getIp();
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCFBuilderSession(String ip, Object session) {
        HashMap<String, CFBuilderSession> hashMap = this.listOfBuilderSessions;
        synchronized (hashMap) {
            ((CFBuilderSession)session).initializeTimer();
            this.listOfBuilderSessions.put(ip, (CFBuilderSession)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCFBuilderSession(String ip) {
        HashMap<String, CFBuilderSession> hashMap = this.listOfBuilderSessions;
        synchronized (hashMap) {
            CFBuilderSession session = this.listOfBuilderSessions.get(ip);
            if (session != null) {
                session.shutDownTimer();
            }
            this.listOfBuilderSessions.remove(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPresentinListOfFilesForDebug(String fileName) {
        HashMap<String, CFBuilderSession> hashMap = this.listOfBuilderSessions;
        synchronized (hashMap) {
            for (CFBuilderSession session : this.listOfBuilderSessions.values()) {
                if (!session.isFileinThisSession(fileName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, CFBuilderSession> getAllCFBuilderSessions() {
        HashMap<String, CFBuilderSession> hashMap = this.listOfBuilderSessions;
        synchronized (hashMap) {
            return this.listOfBuilderSessions;
        }
    }

    public Object getCFBuilderSession(String debugServerIp, boolean isPGSession) {
        return new CFBuilderSession(debugServerIp, isPGSession);
    }

    public void addFoldertoCFBuilderSession(Object cfBuilderSession, String folderPath) {
        ((CFBuilderSession)cfBuilderSession).addFoldertoSession(folderPath);
    }

    public void setContextRootForLineDebugger(ServletContext ctxRoot) {
        LineDebuggerConfig.getInstance().setCtxRoot(ctxRoot);
    }

    public String getContextRootForLineDebugger() {
        return LineDebuggerConfig.getInstance().getCtxRoot();
    }

    public void setDebuggingSettings(ConfigMap lineDebuggingSettings) throws ServiceException {
        LineDebuggerConfig.getInstance().setDebuggingSettings(lineDebuggingSettings);
    }

    public int getDebuggerPort() {
        int port = 0;
        try {
            return LineDebuggerConfig.getInstance().getDebuggerPort();
        }
        catch (Exception e) {
            this.initException = new ServletException(e.getMessage());
            return port;
        }
    }

    public void onCFRequestEnd() {
        DummyDeubgRequestHandler.onCFRequestEnd();
    }

    public Object getDebuggerRDSRequestManager(String host, String ctxRoot, String canonicalCtxRoot, int port, String cfRoot, int maxSessions) {
        return new DebuggerRDSRequestManager(host, ctxRoot, canonicalCtxRoot, port, cfRoot, maxSessions);
    }

    public void processRequest(Object reqMgr, RdsRequest req, RdsResponse resp) {
        ((DebuggerRDSRequestManager)reqMgr).processRequest(req, resp);
    }

    public boolean doesServerNeedRestart() {
        return LineDebuggerConfig.getInstance().doesServerNeedRestart();
    }

    public boolean showPortInUseWarning() throws Exception {
        return LineDebuggerConfig.getInstance().showPortInUseWarning();
    }

    static {
        try {
            Class.forName("coldfusion.debug.DummyDeubgRequestHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        debugger = new ThreadLocal();
        showDebug = new ThreadLocal();
    }
}

