/*
 * Decompiled with CFR 0.152.
 */
package com.zingchart;

import com.zingchart.Canvas;
import com.zingchart.CanvasGradient;
import com.zingchart.CanvasPattern;
import com.zingchart.Image;
import com.zingchart.State;
import com.zingchart.TextStyle;
import com.zingchart.Utils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Stack;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Context2d
extends ScriptableObject {
    private static final long serialVersionUID = 438270592527335642L;
    private Canvas canvas;
    private Stack<State> stack = new Stack();
    private State state = new State();
    private GeneralPath path = new GeneralPath();
    private TextStyle textStyle;
    private boolean bMoveTo = false;

    public void setCanvas(Canvas pcanvas) {
        this.canvas = pcanvas;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setTextStyle(TextStyle ptextStyle) {
        this.textStyle = ptextStyle;
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setState(State pstate) {
        this.state.fillStyle = pstate.fillStyle;
        this.state.strokeStyle = pstate.strokeStyle;
        this.state.lineWidth = pstate.lineWidth;
        this.state.lineJoin = pstate.lineJoin;
        this.state.lineCap = pstate.lineCap;
        this.state.miterLimit = pstate.miterLimit;
        this.state.globalAlpha = pstate.globalAlpha;
        this.state.globalCompositeOperation = pstate.globalCompositeOperation;
        this.state.transform = pstate.transform;
        if (pstate.transform != null) {
            this.getCanvas().getGraphics().setTransform(pstate.transform);
        }
    }

    public State getState() {
        return this.state;
    }

    public void jsSet_font(String fontDefinition) {
        boolean bold = false;
        boolean italic = false;
        String size = "";
        String family = "";
        if (fontDefinition.indexOf("bold") != -1) {
            bold = true;
            fontDefinition = fontDefinition.replace("bold", "");
        }
        if (fontDefinition.indexOf("italic") != -1) {
            italic = true;
            fontDefinition = fontDefinition.replace("italic", "");
        }
        String[] tokens = fontDefinition.split(" ");
        String units = ",px,pt,mm,cm,in,pc,";
        int i = 0;
        while (i < tokens.length) {
            String token;
            if (!tokens[i].trim().isEmpty() && units.indexOf("," + (token = tokens[i].trim()).substring(token.length() - 2, token.length()) + ",") != -1) {
                size = tokens[i].trim();
                fontDefinition = fontDefinition.replace(size, "");
            }
            ++i;
        }
        this.textStyle.fontFamily = family = fontDefinition.trim();
        this.textStyle.fontSize = size;
        this.textStyle.fontVariant = italic ? "italic" : "none";
        this.textStyle.fontWeight = bold ? "bold" : "regular";
    }

    public String jsGet_font() {
        return "";
    }

    public void jsSet_textAlign(String ptextAlign) {
        this.textStyle.textAlign = ptextAlign;
    }

    public String jsGet_textAlign() {
        return this.textStyle.textAlign;
    }

    public void jsSet_textBaseline(String ptextBaseline) {
    }

    public String jsGet_textBaseline() {
        return "";
    }

    public void jsFunction_strokeText(String text, double x, double y) {
        this.jsFunction_fillText(text, x, y);
    }

    public int jsFunction_getStringWidth(String text) {
        FontMetrics metrics = this.getTextStyle().getMetrics();
        return metrics.stringWidth(text);
    }

    public void jsFunction_fillText(String text, double x, double y) {
        FontMetrics metrics = this.getTextStyle().getMetrics();
        String textAlign = this.textStyle.textAlign;
        if ("center".equals(textAlign)) {
            x -= (double)(metrics.stringWidth(text) / 2);
        } else if ("right".equals(textAlign)) {
            x -= (double)metrics.stringWidth(text);
        }
        y = y + (double)metrics.getLeading() + (double)metrics.getAscent();
        String verticalAlign = this.textStyle.verticalAlign;
        if ("baseline".equals(verticalAlign)) {
            y = y - (double)metrics.getLeading() + (double)metrics.getAscent();
        } else if ("text-top".equals(verticalAlign)) {
            y -= (double)metrics.getLeading();
        } else if ("middle".equals(verticalAlign)) {
            y = y - (double)metrics.getLeading() - (double)(metrics.getAscent() / 2);
        } else if ("bottom".equals(verticalAlign) || "text-bottom".equals(verticalAlign)) {
            y -= (double)metrics.getHeight();
        }
        this.getCanvas().getGraphics().setColor(Utils.parseColor(this.getState().fillStyle.toString()));
        this.getCanvas().getGraphics().setFont(this.getTextStyle().getFont());
        this.getCanvas().getGraphics().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.getCanvas().getGraphics().drawString(text, (int)x, (int)y);
    }

    public void jsFunction_drawImage(Object generic, double x, double y, double w, double h) {
        if (generic.getClass().getName() == "com.zingchart.Canvas") {
            this.getCanvas().getImage().createGraphics().drawImage(((Canvas)generic).getImage(), (int)x, (int)y, (int)w, (int)h, null);
        } else if (generic.getClass().getName() == "com.zingchart.Image") {
            this.getCanvas().getGraphics().drawImage(((Image)generic).image, (int)x, (int)y, (int)w, (int)h, null);
        }
    }

    public void jsFunction_drawImageRect(Object generic, double x, double y, double w, double h, double sx, double sy, double sw, double sh) {
        if (generic.getClass().getName() == "com.zingchart.Canvas") {
            this.getCanvas().getImage().createGraphics().drawImage(((Canvas)generic).getImage(), (int)x, (int)y, (int)w, (int)h, (int)sx, (int)sy, (int)sw, (int)sh, null);
        } else if (generic.getClass().getName() == "com.zingchart.Image") {
            this.getCanvas().getGraphics().drawImage(((Image)generic).image, (int)x, (int)y, (int)w, (int)h, (int)sx, (int)sy, (int)sw, (int)sh, null);
        }
    }

    public void jsSet_fillStyle(Object pfillStyle) {
        this.state.fillStyle = pfillStyle;
        Paint paint = null;
        if (this.state.fillStyle instanceof String) {
            paint = Utils.parseColor(this.state.fillStyle.toString());
        } else if (this.state.fillStyle instanceof CanvasGradient) {
            paint = ((CanvasGradient)this.state.fillStyle).getPaint();
        } else if (this.state.fillStyle instanceof CanvasPattern) {
            paint = ((CanvasPattern)this.state.fillStyle).getPaint();
        }
        this.state.fillPaint = paint;
    }

    public Object jsGet_fillStyle() {
        return this.state.fillStyle;
    }

    public void jsSet_strokeStyle(Object pstrokeStyle) {
        this.state.strokeStyle = pstrokeStyle;
        Paint paint = null;
        if (this.state.strokeStyle instanceof String) {
            paint = Utils.parseColor(this.state.strokeStyle.toString());
        } else if (this.state.strokeStyle instanceof CanvasGradient) {
            paint = ((CanvasGradient)this.state.strokeStyle).getPaint();
        }
        this.state.strokePaint = paint;
    }

    public Object jsGet_strokeStyle() {
        return this.state.strokeStyle;
    }

    public void jsSet_lineWidth(int plineWidth) {
        this.state.lineWidth = plineWidth;
    }

    public int jsGet_lineWidth() {
        return this.state.lineWidth;
    }

    public void jsSet_lineCap(String plineCap) {
        this.state.lineCap = plineCap;
    }

    public String jsGet_lineCap() {
        return this.state.lineCap;
    }

    public void jsSet_lineJoin(String plineJoin) {
        this.state.lineJoin = plineJoin;
    }

    public String jsGet_lineJoin() {
        return this.state.lineJoin;
    }

    public void jsSet_miterLimit(double pmiterLimit) {
        this.state.miterLimit = (float)pmiterLimit;
    }

    public double jsGet_miterLimit() {
        return this.state.miterLimit;
    }

    public AlphaComposite setupComposite(String pglobalCompositeOperation) {
        int type = "source-atop".equals(this.state.globalCompositeOperation) ? 10 : ("source-in".equals(this.state.globalCompositeOperation) ? 5 : ("source-out".equals(this.state.globalCompositeOperation) ? 7 : ("destination-atop".equals(this.state.globalCompositeOperation) ? 10 : ("destination-in".equals(this.state.globalCompositeOperation) ? 6 : ("destination-out".equals(this.state.globalCompositeOperation) ? 8 : ("destination-over".equals(this.state.globalCompositeOperation) ? 4 : ("xor".equals(this.state.globalCompositeOperation) ? 12 : ("over".equals(this.state.globalCompositeOperation) ? 1 : 3))))))));
        return AlphaComposite.getInstance(type, this.state.globalAlpha);
    }

    public void jsSet_globalAlpha(Object pglobalAlpha) {
        this.state.globalAlpha = Float.parseFloat(pglobalAlpha.toString());
        this.applyComposite();
    }

    public float jsGet_globalAlpha() {
        return this.state.globalAlpha;
    }

    public void jsSet_globalCompositeOperation(String pglobalCompositeOperation) {
        this.state.globalCompositeOperation = pglobalCompositeOperation;
        this.applyComposite();
    }

    public void applyComposite() {
        AlphaComposite composite = this.setupComposite(this.state.globalCompositeOperation);
        this.getCanvas().getGraphics().setComposite(composite);
    }

    public void jsFunction_fillRect(int x, int y, int width, int height) {
        this.getCanvas().getGraphics().setPaint(this.state.fillPaint);
        this.getCanvas().getGraphics().fillRect(x, y, width, height);
    }

    public void jsFunction_strokeRect(int x, int y, int width, int height) {
        this.getCanvas().getGraphics().setPaint(this.state.strokePaint);
        this.getCanvas().getGraphics().setStroke(this.setupStroke());
        this.getCanvas().getGraphics().drawRect(x, y, width, height);
    }

    public Scriptable jsFunction_createLinearGradient(double x1, double y1, double x2, double y2) {
        Object[] args = new Object[]{Float.valueOf((float)x1), Float.valueOf((float)y1), Float.valueOf(-1.0f), Float.valueOf((float)x2), Float.valueOf((float)y2), Float.valueOf(-1.0f)};
        Scriptable jsgradient = Context.getCurrentContext().newObject(this.getCanvas().getParentScope(), "CanvasGradient", args);
        return jsgradient;
    }

    public Scriptable jsFunction_createRadialGradient(double x1, double y1, double r1, double x2, double y2, double r2) {
        Object[] args = new Object[]{Float.valueOf((float)x1), Float.valueOf((float)y1), Float.valueOf((float)r1), Float.valueOf((float)x2), Float.valueOf((float)y2), Float.valueOf((float)r2)};
        Scriptable jsgradient = Context.getCurrentContext().newObject(this.getCanvas().getParentScope(), "CanvasGradient", args);
        return jsgradient;
    }

    public Scriptable jsFunction_createPattern(Image image, String repetition, int x, int y) {
        Object[] args = new Object[]{image, repetition, x, y};
        Scriptable jspattern = Context.getCurrentContext().newObject(this.getCanvas().getParentScope(), "CanvasPattern", args);
        return jspattern;
    }

    public void jsFunction_beginPath() {
        this.path = new GeneralPath();
        this.bMoveTo = false;
    }

    public void jsFunction_closePath() {
        if (this.bMoveTo) {
            this.bMoveTo = false;
            this.path.closePath();
        }
        this.getCanvas().getGraphics().setClip(null);
    }

    public void jsFunction_clip() {
        this.getCanvas().getGraphics().setClip(this.path);
    }

    public void jsFunction_moveTo(double x, double y) {
        this.bMoveTo = true;
        Point2D.Float p = new Point2D.Float((float)x, (float)y);
        this.getCanvas().getGraphics().getTransform().transform(p, p);
        this.path.moveTo(Math.max(0.0f, (float)((Point2D)p).getX()), Math.max(0.0f, (float)((Point2D)p).getY()));
    }

    public void jsFunction_lineTo(double x, double y) {
        Point2D.Float p = new Point2D.Float((float)x, (float)y);
        this.getCanvas().getGraphics().getTransform().transform(p, p);
        if (!this.bMoveTo) {
            this.path.moveTo(Math.max(0.0f, (float)((Point2D)p).getX()), Math.max(0.0f, (float)((Point2D)p).getY()));
        }
        this.path.lineTo(Math.max(0.0f, (float)((Point2D)p).getX()), Math.max(0.0f, (float)((Point2D)p).getY()));
    }

    public void jsFunction_quadraticCurveTo(double cpx, double cpy, double x, double y) {
        float[] xy = new float[]{(float)cpx, (float)cpy, (float)x, (float)y};
        this.getCanvas().getGraphics().getTransform().transform(xy, 0, xy, 0, 2);
        this.path.quadTo(xy[0], xy[1], xy[2], xy[3]);
    }

    public void jsFunction_bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        float[] xy = new float[]{(float)cp1x, (float)cp1y, (float)cp2x, (float)cp2y, (float)x, (float)y};
        this.getCanvas().getGraphics().getTransform().transform(xy, 0, xy, 0, 3);
        this.path.curveTo(xy[0], xy[1], xy[2], xy[3], xy[4], xy[5]);
    }

    public void jsFunction_arcTo(double x1, double y1, double x2, double y2, double radius) {
    }

    public void jsFunction_rect(double x, double y, double w, double h) {
        this.path.append(new Rectangle2D.Double(x, y, w, h), true);
    }

    public void jsFunction_arc(double x, double y, double radius, double startAngle, double endAngle, boolean counterclockwise) {
        double ang;
        boolean clockwise = !counterclockwise;
        double twopi = Math.PI * 2;
        while (startAngle < 0.0) {
            startAngle += twopi;
        }
        while (startAngle > twopi) {
            startAngle -= twopi;
        }
        while (endAngle < 0.0) {
            endAngle += twopi;
        }
        while (endAngle > twopi) {
            endAngle -= twopi;
        }
        if (clockwise) {
            if (startAngle > endAngle) {
                endAngle += twopi;
            }
        } else if (startAngle < endAngle) {
            endAngle -= twopi;
        }
        if ((ang = startAngle - endAngle) == 0.0) {
            ang = Math.PI * 2;
        }
        startAngle = -startAngle;
        this.path.append(this.getCanvas().getGraphics().getTransform().createTransformedShape(new Arc2D.Double(x - radius, y - radius, 2.0 * radius, 2.0 * radius, Math.toDegrees(startAngle), Math.toDegrees(ang), 0)), true);
    }

    public void jsFunction_fill() {
        AffineTransform t = this.getCanvas().getGraphics().getTransform();
        this.getCanvas().getGraphics().setTransform(new AffineTransform());
        this.getCanvas().getGraphics().setPaint(this.state.fillPaint);
        this.getCanvas().getGraphics().fill(this.path);
        this.getCanvas().getGraphics().setTransform(t);
    }

    public void jsFunction_stroke() {
        try {
            this.getCanvas().getGraphics().setColor(Utils.parseColor(this.getState().strokeStyle.toString()));
            this.getCanvas().getGraphics().setStroke(this.setupStroke());
            this.getCanvas().getGraphics().draw(this.getCanvas().getGraphics().getTransform().createInverse().createTransformedShape(this.path));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public BasicStroke setupStroke() {
        int cap = this.state.lineCap.equals("round") ? 1 : (this.state.lineCap.equals("square") ? 2 : 0);
        int join = this.state.lineJoin.equals("round") ? 1 : (this.state.lineJoin.equals("bevel") ? 2 : 0);
        BasicStroke stroke = new BasicStroke(this.getState().lineWidth, cap, join, this.state.miterLimit);
        return stroke;
    }

    public void jsFunction_save() {
        State cstate = new State();
        cstate.fillStyle = this.state.fillStyle;
        cstate.strokeStyle = this.state.strokeStyle;
        cstate.lineWidth = this.state.lineWidth;
        cstate.lineCap = this.state.lineCap;
        cstate.lineJoin = this.state.lineJoin;
        cstate.miterLimit = this.state.miterLimit;
        cstate.globalAlpha = this.state.globalAlpha;
        cstate.globalCompositeOperation = this.state.globalCompositeOperation;
        cstate.transform = this.getCanvas().getGraphics().getTransform();
        this.stack.push(cstate);
    }

    public void jsFunction_restore() {
        this.getCanvas().getGraphics().setClip(null);
        this.setState(this.stack.pop());
        this.applyComposite();
    }

    public void jsFunction_scale(double x, double y) {
        this.getCanvas().getGraphics().scale(x, y);
    }

    public void jsFunction_rotate(double angle) {
        this.getCanvas().getGraphics().rotate(angle);
    }

    public void jsFunction_translate(double tx, double ty) {
        this.getCanvas().getGraphics().translate(tx, ty);
    }

    public void jsFunction_transform(double m11, double m12, double m21, double m22, double dx, double dy) {
        AffineTransform at = new AffineTransform(m11, m12, m21, m22, dx, dy);
        this.getCanvas().getGraphics().transform(at);
    }

    public void jsFunction_setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.getCanvas().getGraphics().setTransform(new AffineTransform(m11, m12, m21, m22, dx, dy));
    }

    public Context2d() {
        this.setState(new State());
        this.setTextStyle(new TextStyle(this));
    }

    @Override
    public String getClassName() {
        return "Context2d";
    }
}

