/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillElementGroup
implements JRElementGroup,
JRCloneable {
    protected List children = new ArrayList();
    protected JRElementGroup elementGroup = null;
    protected JRFillElement[] elements = null;
    private JRElement topElementInGroup = null;
    private JRElement bottomElementInGroup = null;
    private int stretchHeightDiff = 0;

    protected JRFillElementGroup(JRElementGroup elementGrp, JRFillObjectFactory factory) {
        factory.put(elementGrp, this);
        if (elementGrp != null) {
            List list = elementGrp.getChildren();
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    JRChild child = (JRChild)list.get(i);
                    child = child.getCopy(factory);
                    this.children.add(child);
                }
            }
            this.getElements();
            this.elementGroup = factory.getElementGroup(elementGrp.getElementGroup());
        }
    }

    protected JRFillElementGroup(JRFillElementGroup elementGrp, JRFillCloneFactory factory) {
        factory.put(elementGrp, this);
        List list = elementGrp.getChildren();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                JRCloneable child = (JRCloneable)list.get(i);
                JRCloneable clone = child.createClone(factory);
                this.children.add(clone);
            }
        }
        this.getElements();
        this.elementGroup = (JRFillElementGroup)factory.getClone((JRFillElementGroup)elementGrp.getElementGroup());
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    @Override
    public JRElement[] getElements() {
        if (this.elements == null && this.children != null) {
            ArrayList<JRElement> allElements = new ArrayList<JRElement>();
            Object child = null;
            JRElement[] childElementArray = null;
            for (int i = 0; i < this.children.size(); ++i) {
                child = this.children.get(i);
                if (child instanceof JRFillElement) {
                    allElements.add((JRElement)child);
                    continue;
                }
                if (!(child instanceof JRFillElementGroup) || (childElementArray = ((JRFillElementGroup)child).getElements()) == null) continue;
                allElements.addAll(Arrays.asList(childElementArray));
            }
            this.elements = new JRFillElement[allElements.size()];
            allElements.toArray(this.elements);
        }
        return this.elements;
    }

    @Override
    public JRElement getElementByKey(String key) {
        return null;
    }

    protected void reset() {
        this.topElementInGroup = null;
    }

    protected int getStretchHeightDiff() {
        if (this.topElementInGroup == null) {
            this.stretchHeightDiff = 0;
            this.setTopBottomElements();
            JRElement[] allElements = this.getElements();
            if (allElements != null && allElements.length > 0) {
                JRFillElement topElem = null;
                JRFillElement bottomElem = null;
                for (int i = 0; i < allElements.length; ++i) {
                    JRFillElement element = (JRFillElement)allElements[i];
                    if (!element.isToPrint()) continue;
                    if (topElem == null || topElem != null && element.getRelativeY() + element.getStretchHeight() < topElem.getRelativeY() + topElem.getStretchHeight()) {
                        topElem = element;
                    }
                    if (bottomElem != null && (bottomElem == null || element.getRelativeY() + element.getStretchHeight() <= bottomElem.getRelativeY() + bottomElem.getStretchHeight())) continue;
                    bottomElem = element;
                }
                if (topElem != null) {
                    this.stretchHeightDiff = bottomElem.getRelativeY() + bottomElem.getStretchHeight() - topElem.getRelativeY() - (this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight() - this.topElementInGroup.getY());
                }
                if (this.stretchHeightDiff < 0) {
                    this.stretchHeightDiff = 0;
                }
            }
        }
        return this.stretchHeightDiff;
    }

    private void setTopBottomElements() {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            for (int i = 0; i < allElements.length; ++i) {
                if (this.topElementInGroup == null || this.topElementInGroup != null && allElements[i].getY() + allElements[i].getHeight() < this.topElementInGroup.getY() + this.topElementInGroup.getHeight()) {
                    this.topElementInGroup = allElements[i];
                }
                if (this.bottomElementInGroup != null && (this.bottomElementInGroup == null || allElements[i].getY() + allElements[i].getHeight() <= this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight())) continue;
                this.bottomElementInGroup = allElements[i];
            }
        }
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getElementGroup(this);
    }

    @Override
    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        xmlWriter.writeElementGroup(this);
    }

    @Override
    public JRCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillElementGroup(this, factory);
    }
}

