/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search.core;

import coldfusion.orm.search.ORMSearchManager;
import coldfusion.orm.search.core.IndexableField;
import coldfusion.orm.search.core.IndexableRelationField;
import coldfusion.util.CaseInsensitiveMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CFCSearchMetadata {
    private String entityName;
    private String cfcName;
    private String ParentEntityName;
    private String language;
    private boolean autoIndex = true;
    private Map<String, IndexableField> nameVsIndexableFields = new CaseInsensitiveMap();
    private List<IndexableField> indexableFields = new ArrayList<IndexableField>();
    private List<IndexableField> indexableIDFields = new ArrayList<IndexableField>();
    private List<IndexableRelationField> indexableRelationFields;
    private static String DOT = ".";

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getCfcName() {
        return this.cfcName;
    }

    public void setCfcName(String cfcName) {
        this.cfcName = cfcName;
    }

    public String getParentEntityName() {
        return this.ParentEntityName;
    }

    public void setParentEntityName(String parentEntityName) {
        this.ParentEntityName = parentEntityName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    public void setAutoIndex(boolean autoIndex) {
        this.autoIndex = autoIndex;
    }

    public void addIndexableField(IndexableField field) {
        this.indexableFields.add(field);
        this.nameVsIndexableFields.put(field.getIndexFieldName(), field);
    }

    public void addIndexableIDField(IndexableField idField) {
        this.indexableIDFields.add(idField);
        this.nameVsIndexableFields.put(idField.getIndexFieldName(), idField);
    }

    public void addIndexableRelationField(IndexableRelationField relationField) {
        if (this.indexableRelationFields == null) {
            this.indexableRelationFields = new ArrayList<IndexableRelationField>();
        }
        this.indexableRelationFields.add(relationField);
        this.nameVsIndexableFields.put(relationField.getIndexFieldName(), relationField);
    }

    public List<IndexableField> getIndexableFields() {
        return this.indexableFields;
    }

    public List<IndexableField> getIndexableIDFields() {
        return this.indexableIDFields;
    }

    public List<IndexableRelationField> getIndexableRelationFields() {
        return this.indexableRelationFields;
    }

    public IndexableField getIndexableField(String fieldName) {
        return this.nameVsIndexableFields.get(fieldName);
    }

    public boolean isFieldIndexable(String fieldName) {
        boolean contains = this.nameVsIndexableFields.containsKey(fieldName);
        if (!contains && fieldName.indexOf(DOT) > 0) {
            String relationFieldName = fieldName.substring(0, fieldName.indexOf(DOT));
            return this.nameVsIndexableFields.containsKey(relationFieldName);
        }
        return contains;
    }

    public boolean isFieldStorable(String fieldName) {
        boolean storable;
        IndexableField field = this.nameVsIndexableFields.get(fieldName);
        boolean bl = storable = field != null && field.isIndexStorable();
        if (field == null && fieldName.indexOf(DOT) > 0) {
            String relationFieldName = fieldName.substring(0, fieldName.indexOf(DOT));
            field = this.nameVsIndexableFields.get(relationFieldName);
            if (field instanceof IndexableRelationField) {
                String cfcName = ((IndexableRelationField)field).getTargetComponent();
                String targetEntityName = ORMSearchManager.getCurrentSearchFactory().getEntityName(cfcName);
                CFCSearchMetadata smd = ORMSearchManager.getCurrentSearchFactory().getSearchMetadataForReferredCFC(targetEntityName);
                if (smd != null) {
                    fieldName = fieldName.substring(relationFieldName.length() + 1);
                    return smd.isFieldStorable(fieldName);
                }
                return false;
            }
            return field != null && field.isIndexStorable();
        }
        return storable;
    }
}

