/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.proxy;

import coldfusion.log.CFLogs;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.net.websocket.server.proxy.ProxyConnection;
import coldfusion.tagext.net.websocket.server.proxy.ProxyMessage;
import coldfusion.tagext.net.websocket.server.proxy.WSProxyConnectionManager;
import coldfusion.tagext.net.websocket.server.proxy.WSProxyMessageHandler;
import coldfusion.tagext.net.websocket.server.proxy.WSProxyMessageReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;

public class WSProxyServer
extends Thread {
    static int MAX_RECEIVE_BUFFERS = 10000;
    private static WSProxyServer webSocketProxyServerInstance;
    private ServerSocketChannel serverChannel;
    private ArrayBlockingQueue<String> messageQ;
    private AsynchronousChannelGroup group;
    private AsynchronousServerSocketChannel server;
    static ArrayBlockingQueue<ArrayList<ProxyMessage>> receivedBuffers;
    private WSProxyMessageHandler msgHandler;
    private int proxyConnectPort;

    public WSProxyServer(int port) {
        this.proxyConnectPort = port;
        this.msgHandler = new WSProxyMessageHandler();
        this.msgHandler.start();
    }

    public static WSProxyServer getWSProxyServerInstance() throws IOException {
        if (webSocketProxyServerInstance == null) {
            WebSocketService wsService = ServiceFactory.getWebsocketService();
            webSocketProxyServerInstance = new WSProxyServer(wsService.getPort());
        }
        return webSocketProxyServerInstance;
    }

    @Override
    public void run() {
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(Executors.newCachedThreadPool());
            this.server = AsynchronousServerSocketChannel.open(this.group);
            this.server.bind(new InetSocketAddress(this.proxyConnectPort));
            CompletionHandler<AsynchronousSocketChannel, Object> onAccept = new CompletionHandler<AsynchronousSocketChannel, Object>(){

                @Override
                public void completed(AsynchronousSocketChannel result, Object attachment) {
                    ProxyConnection pConn = new ProxyConnection(result);
                    WSProxyConnectionManager.getInstance().addClientConnection(pConn);
                    WSProxyMessageReader proxyMsgReader = new WSProxyMessageReader(pConn, ServiceFactory.getWebsocketService().getMaxFrameSize());
                    proxyMsgReader.doRead();
                    WSProxyServer.this.server.accept(null, this);
                }

                @Override
                public void failed(Throwable exc, Object attachment) {
                    try {
                        WSProxyServer.this.server.close();
                    }
                    catch (IOException e) {
                        CFLogs.WEBSOCKETPROXY_LOG.error((Object)("Error while listening on websocket proxy port :" + WSProxyServer.this.proxyConnectPort));
                    }
                }
            };
            this.server.accept(null, onAccept);
        }
        catch (IOException e) {
            CFLogs.WEBSOCKETPROXY_LOG.error((Object)("Error while listening on websocket proxy port :" + this.proxyConnectPort));
        }
    }

    public void shutdown() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.group.shutdown();
        WSProxyConnectionManager.getInstance().shutdown();
    }

    public static void main(String[] args) {
        try {
            WSProxyServer srv = new WSProxyServer(81);
            new Thread(srv).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        receivedBuffers = new ArrayBlockingQueue(MAX_RECEIVE_BUFFERS);
    }
}

