/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.protocol;

import coldfusion.log.CFLogs;
import coldfusion.server.ServiceFactory;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;

public class RequestPacketReader {
    public static final int DEFAULT_MAX_FRAME_SIZE = 0x100000;
    private static final int maxFrameSize = ServiceFactory.getWebsocketService().getMaxFrameSize() > 0 ? ServiceFactory.getWebsocketService().getMaxFrameSize() * 1024 : 0x100000;
    private static Logger logger = Logger.getLogger(RequestPacketReader.class);

    public static WebSocketFrame readHixie_textFrame(int type, ChannelBuffer buffer, int readableBytes) throws TooLongFrameException {
        if (readableBytes < 1) {
            CFLogs.WEBSOCKET_LOG.info((Object)"RequestPacketReader Hixie specification: data size is zero returning it back as per");
            return null;
        }
        CFLogs.WEBSOCKET_LOG.info((Object)"RequestPacketReader: Reading request data as per Hixie specification.");
        int ridx = buffer.readerIndex();
        int delimPos = buffer.indexOf(ridx, ridx + readableBytes, (byte)-1);
        if (delimPos == -1) {
            return null;
        }
        int frameSize = delimPos - ridx;
        if (frameSize > maxFrameSize) {
            throw new TooLongFrameException();
        }
        ChannelBuffer binaryData = buffer.readBytes(frameSize);
        buffer.skipBytes(1);
        return new DefaultWebSocketFrame(type, binaryData);
    }

    public static WebSocketFrame readHybi_textFrame(byte byte_1, ChannelBuffer buffer) throws TooLongFrameException {
        CFLogs.WEBSOCKET_LOG.info((Object)"RequestPacketReader: Reading request data as per Hybi specification.");
        boolean finalFragment = (byte_1 & 0x80) == 128;
        int type = byte_1 & 0xF;
        byte payload = buffer.readByte();
        boolean masked = (payload & 0x80) == 128;
        long contextLength = payload & 0x7F;
        if (contextLength == 126L) {
            contextLength = buffer.readShort();
        } else if (contextLength == 127L) {
            contextLength = buffer.readLong();
        }
        int[] maskedKeys = new int[4];
        if (masked) {
            maskedKeys[0] = buffer.readByte() & 0xFF;
            maskedKeys[1] = buffer.readByte() & 0xFF;
            maskedKeys[2] = buffer.readByte() & 0xFF;
            maskedKeys[3] = buffer.readByte() & 0xFF;
        }
        if (contextLength < 0L) {
            logger.error((Object)("Request contentLength is negative. contentLength=" + contextLength));
        }
        ChannelBuffer binaryData = buffer.readBytes((int)contextLength);
        if (masked) {
            byte[] reqData = binaryData.array();
            int j = 0;
            for (int i = 0; i < reqData.length; ++i) {
                reqData[i] = (byte)(reqData[i] ^ maskedKeys[j]);
                ++j;
                j &= 3;
            }
        }
        return new DefaultWebSocketFrame(type, binaryData);
    }
}

