/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.netty;

import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class WebSocketSSLEngine {
    private static SSLContext sslContext = null;
    private static final String JKS_TYPE = "jks";
    private static final String PKCS12_TYPE = "pkcs12";

    private static KeyStore getKeyStore(File keystoreFile, String keystorePassword) {
        try {
            return WebSocketSSLEngine.getKeyStore(keystoreFile, keystorePassword, JKS_TYPE);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                return WebSocketSSLEngine.getKeyStore(keystoreFile, keystorePassword, PKCS12_TYPE);
            }
            catch (ApplicationException e1) {
                throw e1;
            }
            catch (Throwable t) {
                CFLogs.SECURITY_LOG.error((Object)"Error in loading keystore. Either the keystore is corrupted or the keystore password is wrong.", t);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(File keystoreFile, String keystorePassword, String storeType) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(keystoreFile);
            KeyStore keystore = KeyStore.getInstance(storeType);
            keystore.load(fis, keystorePassword.toCharArray());
            KeyStore keyStore = keystore;
            return keyStore;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static SSLContext getContext() {
        return sslContext;
    }

    static {
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        SSLContext serverContext = null;
        WebSocketService webSocketService = ServiceFactory.getWebsocketService();
        try {
            String keyStoreLocation = webSocketService.getKeyStorePath();
            File file = new File(keyStoreLocation);
            if (!file.exists()) {
                CFLogs.SERVER_LOG.info((Object)"KeyStore file does not exist. Can not start WebSocket service over SSL.");
            }
            String password = webSocketService.getKeyStorePassword();
            KeyStore ks = WebSocketSSLEngine.getKeyStore(file, webSocketService.getKeyStorePassword());
            if (ks != null) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                kmf.init(ks, password.toCharArray());
                serverContext = SSLContext.getInstance("TLS");
                serverContext.init(kmf.getKeyManagers(), null, null);
            }
        }
        catch (Exception e) {
            CFLogs.SECURITY_LOG.error((Object)"Can not create Secure WebSocket context for WebSocket.", (Throwable)e);
        }
        sslContext = serverContext;
    }
}

