/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.messaging;

import coldfusion.compiler.NeoTranslator;
import coldfusion.log.CFLogs;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.net.websocket.messaging.Channel;
import coldfusion.tagext.net.websocket.messaging.ChannelConstants;
import coldfusion.tagext.net.websocket.messaging.ChannelException;
import coldfusion.tagext.net.websocket.messaging.ChannelRequestHeader;
import coldfusion.tagext.net.websocket.messaging.ChannelUtil;
import coldfusion.tagext.net.websocket.messaging.ChannelscopePropertyResolver;
import coldfusion.tagext.net.websocket.server.core.AbstractClientConnection;
import coldfusion.util.Key;
import coldfusion.util.RB;
import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelListener {
    private static Logger log = LoggerFactory.getLogger(ChannelListener.class);
    private Channel channel;
    private TemplateProxy listenerProxy;
    private static RuntimeService runtimeService = ServiceFactory.getRuntimeService();
    private File listenerCFCFile;
    private String listenerCFCFilePath;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private long lastModifiedTime;
    private long refreshCheckedTime = System.currentTimeMillis();
    private static int REFRESH_INTERVAL = 2000;
    private boolean needCanSendMessageInvoking = true;
    private String applicationName;

    public ChannelListener(Channel channel, String appName, TemplateProxy listenerProxy) {
        this.channel = channel;
        this.applicationName = appName;
        this.listenerProxy = listenerProxy;
        this.needCanSendMessageInvoking = this.checkCanSendMessageInvocationRequired();
        this.listenerCFCFile = new File((String)((AttributeCollection)listenerProxy.getMetadata()).get(Key.PATH));
        this.listenerCFCFilePath = this.listenerCFCFile.getAbsolutePath();
        this.lastModifiedTime = this.listenerCFCFile.lastModified();
    }

    public boolean checkSubscribePermission(AbstractClientConnection aConnector, ChannelRequestHeader subscriberReqHeader) {
        CFLogs.WEBSOCKET_LOG.info((Object)("In checkSubscribePermission method of" + this.listenerCFCFilePath + " channel listner."));
        this.needRefreshing();
        Struct mConnectionInfo = aConnector.getConnectionInfo();
        Struct subscriberInfo = subscriberReqHeader.getCustomOptionMap();
        subscriberInfo.put((Object)"connectioninfo", (Object)mConnectionInfo);
        Object[] args = new Object[]{subscriberInfo};
        Object retVal = null;
        try {
            retVal = ChannelUtil.callCFCFunction(this.applicationName, this.listenerProxy, "allowsubscribe", this.listenerCFCFilePath, args, this.readLock);
        }
        catch (Throwable e) {
            throw new ChannelException(RB.getString((Object)this, (String)"CFCListener.MethodInvocationError", (Object)"allowsubscribe", (Object)this.channel.getName()), e);
        }
        return Cast._boolean((Object)retVal);
    }

    public void afterUnsubscribe(AbstractClientConnection aConnector, ChannelRequestHeader subscriberReqHeader) {
        CFLogs.WEBSOCKET_LOG.info((Object)("In afterUnsubscribe method of" + this.listenerCFCFilePath + " channel listner."));
        this.needRefreshing();
        Struct mConnectionInfo = aConnector.getConnectionInfo();
        Struct subscriberInfo = subscriberReqHeader.getCustomOptionMap();
        if (subscriberInfo.get((Object)"connectioninfo") == null) {
            subscriberInfo.put((Object)"connectioninfo", (Object)mConnectionInfo);
        }
        Object[] args = new Object[]{subscriberInfo};
        try {
            ChannelUtil.callCFCFunction(this.applicationName, this.listenerProxy, "afterunsubscribe", this.listenerCFCFilePath, args, this.readLock);
        }
        catch (Throwable e) {
            throw new ChannelException(RB.getString((Object)this, (String)"CFCListener.MethodInvocationError", (Object)"afterunsubscribe", (Object)this.channel.getName()), e);
        }
    }

    public boolean checkPublishPermission(AbstractClientConnection aConnector, ChannelRequestHeader aPublisherRequestHeader) {
        CFLogs.WEBSOCKET_LOG.info((Object)("In checkPublishPermission method of" + this.listenerCFCFilePath + " channel listner."));
        this.needRefreshing();
        Struct mConnectionInfo = aConnector.getConnectionInfo();
        Struct publisherInfo = aPublisherRequestHeader.getCustomOptionMap();
        publisherInfo.put((Object)"connectioninfo", (Object)mConnectionInfo);
        Object[] args = new Object[]{publisherInfo};
        Object retVal = null;
        try {
            retVal = ChannelUtil.callCFCFunction(this.applicationName, this.listenerProxy, "allowpublish", this.listenerCFCFilePath, args, this.readLock);
        }
        catch (Throwable e) {
            throw new ChannelException(RB.getString((Object)this, (String)"CFCListener.MethodInvocationError", (Object)"allowpublish", (Object)this.channel.getName()), e);
        }
        return Cast._boolean((Object)retVal);
    }

    public Object beforePublish(AbstractClientConnection aConnector, ChannelRequestHeader aPublisherRequestHeader, Object message) {
        CFLogs.WEBSOCKET_LOG.info((Object)("In beforePublish method of" + this.listenerCFCFilePath + " channel listner."));
        Struct mConnectionInfo = aConnector != null ? aConnector.getConnectionInfo() : new Struct();
        Struct publisherInfo = aPublisherRequestHeader.getCustomOptionMap();
        publisherInfo.put((Object)"connectioninfo", (Object)mConnectionInfo);
        Object[] args = new Object[]{message, publisherInfo};
        Object retVal = null;
        try {
            retVal = ChannelUtil.callCFCFunction(this.applicationName, this.listenerProxy, "beforepublish", this.listenerCFCFilePath, args, this.readLock);
        }
        catch (Throwable e) {
            throw new ChannelException(RB.getString((Object)this, (String)"CFCListener.MethodInvocationError", (Object)"beforepublish", (Object)this.channel.getName()), e);
        }
        return retVal;
    }

    public boolean canSendMessage(AbstractClientConnection subscriberConnector, ChannelRequestHeader aSubscriberReqHeader, AbstractClientConnection publisherConnector, ChannelRequestHeader aPublisherRequestHeader, Object message) {
        CFLogs.WEBSOCKET_LOG.info((Object)("In canSendMessage method of" + this.listenerCFCFilePath + " channel listner."));
        Struct subscriberConnectionInfo = subscriberConnector != null ? subscriberConnector.getConnectionInfo() : new Struct();
        Struct publisherConnectionInfo = publisherConnector != null ? publisherConnector.getConnectionInfo() : new Struct();
        Object retVal = null;
        if (!(this.needCanSendMessageInvoking || aSubscriberReqHeader.getSelectorExpression() == null && aPublisherRequestHeader.getSelectorExpression() == null)) {
            ChannelscopePropertyResolver resolverPage;
            retVal = true;
            if (aSubscriberReqHeader.getSelectorExpression() != null) {
                resolverPage = aSubscriberReqHeader.getPropertyResolver();
                resolverPage.reset();
                resolverPage.addScope(aPublisherRequestHeader.getCustomOptionMap());
                if (message instanceof Struct) {
                    resolverPage.addScope((Struct)message);
                }
                try {
                    retVal = aSubscriberReqHeader.getSelectorExpression().evaluate((CFPage)resolverPage, null);
                }
                catch (Exception e) {
                    retVal = false;
                }
            }
            if (Cast._boolean((Object)retVal) && aPublisherRequestHeader.getSelectorExpression() != null) {
                resolverPage = aPublisherRequestHeader.getPropertyResolver();
                resolverPage.reset();
                resolverPage.addScope(aSubscriberReqHeader.getCustomOptionMap());
                resolverPage.addScope(subscriberConnectionInfo);
                try {
                    retVal = aPublisherRequestHeader.getSelectorExpression().evaluate((CFPage)resolverPage, null);
                }
                catch (Exception e) {
                    retVal = false;
                }
            }
        } else {
            try {
                Struct publisherInfo;
                Struct subscriberInfo = aSubscriberReqHeader.getCustomOptionMap();
                if (subscriberInfo.get((Object)"connectioninfo") == null) {
                    subscriberInfo.put((Object)"connectioninfo", (Object)subscriberConnectionInfo);
                }
                if ((publisherInfo = aPublisherRequestHeader.getCustomOptionMap()).get((Object)"connectioninfo") == null) {
                    publisherInfo.put((Object)"connectioninfo", (Object)publisherConnectionInfo);
                }
                Object[] args = new Object[]{message, subscriberInfo, publisherInfo};
                retVal = ChannelUtil.callCFCFunction(this.applicationName, this.listenerProxy, "cansendmessage", this.listenerCFCFilePath, args, this.readLock);
            }
            catch (Throwable e) {
                throw new ChannelException(RB.getString((Object)this, (String)"CFCListener.MethodInvocationError", (Object)"cansendmessage", (Object)this.channel.getName()), e);
            }
        }
        return Cast._boolean((Object)retVal);
    }

    public Object beforeSendMessage(AbstractClientConnection aConnector, ChannelRequestHeader subscriberReqHeader, Object message) {
        CFLogs.WEBSOCKET_LOG.info((Object)("In beforeSendMessage method of" + this.listenerCFCFilePath + " channel listner."));
        Struct mConnectionInfo = aConnector != null ? aConnector.getConnectionInfo() : new Struct();
        Struct subscriberInfo = subscriberReqHeader.getCustomOptionMap();
        if (subscriberInfo.get((Object)"connectioninfo") == null) {
            subscriberInfo.put((Object)"connectioninfo", (Object)mConnectionInfo);
        }
        Object[] args = new Object[]{message, subscriberInfo};
        Object retVal = null;
        try {
            retVal = ChannelUtil.callCFCFunction(this.applicationName, this.listenerProxy, "beforesendmessage", this.listenerCFCFilePath, args, this.readLock);
        }
        catch (Throwable e) {
            throw new ChannelException(RB.getString((Object)this, (String)"CFCListener.MethodInvocationError", (Object)"beforesendmessage", (Object)this.channel.getName()), e);
        }
        return retVal;
    }

    private boolean checkCanSendMessageInvocationRequired() {
        String fullyQualifiedCFCName = this.listenerProxy.getCfcFullyQualifiedName();
        if (ChannelConstants.ListenerBaseComponent.equalsIgnoreCase(fullyQualifiedCFCName)) {
            return false;
        }
        AttributeCollection metadata = (AttributeCollection)this.listenerProxy.getMetadata();
        while (metadata != null) {
            Object parentMetaDataObj;
            Object[] funcMetaDatas = (Object[])metadata.get(Key.FUNCTIONS);
            if (funcMetaDatas != null) {
                for (Object funcMD : funcMetaDatas) {
                    String funcName = (String)((AttributeCollection)funcMD).get(Key.NAME);
                    if (!funcName.equalsIgnoreCase("cansendmessage")) continue;
                    return true;
                }
            }
            if ((parentMetaDataObj = metadata.get((Object)"EXTENDS")) != null && parentMetaDataObj instanceof AttributeCollection) {
                metadata = (AttributeCollection)parentMetaDataObj;
                String cfcName = (String)metadata.get((Object)"NAME");
                if (!ChannelConstants.ListenerBaseComponent.equalsIgnoreCase(cfcName)) continue;
                return false;
            }
            metadata = null;
        }
        return false;
    }

    public void needRefreshing() {
        if (!runtimeService.isTrustedCache() && System.currentTimeMillis() - this.refreshCheckedTime > (long)REFRESH_INTERVAL) {
            this.refreshCheckedTime = System.currentTimeMillis();
            if (this.listenerCFCFile.lastModified() > this.lastModifiedTime) {
                try {
                    NeoTranslator.removeFileCheckThreadLocal();
                    TemplateProxy proxy = TemplateProxyFactory.resolveFile((NeoPageContext)ChannelUtil.getFusionContext((String)this.applicationName, null).pageContext, (File)this.listenerCFCFile.getAbsoluteFile());
                    this.setListenerProxy(proxy);
                    this.lastModifiedTime = this.listenerCFCFile.lastModified();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void setListenerProxy(TemplateProxy listenerProxy) {
        this.writeLock.lock();
        try {
            this.listenerProxy = listenerProxy;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

