/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.flex.rmi;

import coldfusion.eventgateway.flex.CFDataServicesAdapter;
import coldfusion.eventgateway.flex.rmi.CFToDataManagementProxy;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;

public class CFToDataManagementProxyServer
extends UnicastRemoteObject
implements CFToDataManagementProxy {
    private CFDataServicesAdapter adapter;

    public CFToDataManagementProxyServer(CFDataServicesAdapter adapter) throws RemoteException {
        this.adapter = adapter;
    }

    @Override
    public boolean performDataServiceTransaction(Map msg) throws RemoteException {
        this.checkPermissions();
        try {
            this.adapter.performDataServiceTransaction(msg);
        }
        catch (Exception e) {
            throw new RemoteException("Error performing Data Management transaction: " + e.getMessage(), e);
        }
        return true;
    }

    private void checkPermissions() throws RemoteException {
        try {
            String host = CFToDataManagementProxyServer.getClientHost();
            if (!this.adapter.verifyHost(host)) {
                throw new RemoteException("Permission denied");
            }
        }
        catch (ServerNotActiveException e) {
            throw new RemoteException("Permission denied");
        }
    }
}

