/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.messaging;

import coldfusion.tagext.net.websocket.server.core.AbstractClientConnection;
import coldfusion.tagext.net.websocket.server.core.ClientConnectionManager;
import coldfusion.tagext.net.websocket.server.core.TokenMap;
import coldfusion.tagext.net.websocket.server.core.WSTaskProcessor;
import java.util.ArrayList;
import java.util.List;

public class Subscriber {
    private String mConnectionId;
    private List<String> mChannels = new ArrayList<String>();

    public Subscriber(String aConnectionId) {
        this.mConnectionId = aConnectionId;
    }

    public String getId() {
        return this.mConnectionId;
    }

    public AbstractClientConnection getConnector() {
        return ClientConnectionManager.getClientConnection(this.mConnectionId);
    }

    public List<String> getChannels() {
        return this.mChannels;
    }

    public void addChannel(String aChannel) {
        if (this.mChannels != null) {
            this.mChannels.add(aChannel);
        }
    }

    public void removeChannel(String aChannel) {
        if (this.mChannels != null) {
            this.mChannels.remove(aChannel);
        }
    }

    public void sendToken(TokenMap tokens) {
        AbstractClientConnection connection = this.getConnector();
        if (connection != null && tokens != null) {
            WSTaskProcessor.getTaskProcessor();
            WSTaskProcessor.sendToken(connection, tokens);
        }
    }

    public String resolveExactChannel(String channelName) {
        if (channelName.indexOf(".") > 0) {
            String superChannel = channelName.substring(0, channelName.lastIndexOf("."));
            return this.mChannels.contains(superChannel.toLowerCase()) ? superChannel : this.resolveExactChannel(superChannel);
        }
        return channelName;
    }
}

