/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.excel;

import coldfusion.excel.Excel;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.tagext.lang.SpreadSheetTag;
import coldfusion.util.CFDumpable;
import coldfusion.util.CaseInsensitiveMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelInfo
implements CFDumpable {
    Workbook workbook = null;
    private int rowcount;
    private String sheetname;
    private int sheetnumber;
    private Drawing drawing;
    private CaseInsensitiveMap SummaryInfo;
    private ArrayList ignoreColumnsForAutoResize = new ArrayList();
    HashMap map;
    private boolean sheetNoProvided = false;

    ExcelInfo(Workbook book) {
        this.workbook = book;
        this.SummaryInfo = new CaseInsensitiveMap();
        this.SummaryInfo.put((Object)"AUTHOR", (Object)"Adobe ColdFusion");
    }

    public boolean isSheetNoProvided() {
        return this.sheetNoProvided;
    }

    public void setSheetNoProvided(boolean sheetNoProvided) {
        this.sheetNoProvided = sheetNoProvided;
    }

    public CaseInsensitiveMap getSummaryInfo() {
        return this.SummaryInfo;
    }

    public void setSummaryInfo(Struct info) {
        this.SummaryInfo.clear();
        this.SummaryInfo.putAll((Map)info);
    }

    public void setSummaryInfo(CaseInsensitiveMap summaryinfo) {
        this.SummaryInfo = summaryinfo;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook book) {
        this.workbook = book;
    }

    public void setExcelRowCount(int count) {
        this.rowcount = count;
    }

    public String getExcelSheetName() {
        return this.sheetname;
    }

    public void setExcelSheetName(String sheetname) {
        this.sheetname = sheetname;
    }

    public void setExcelSheetNumber(int number) {
        this.sheetnumber = number;
    }

    public void setDrawing(Drawing drawing) {
        this.drawing = drawing;
    }

    public Drawing getDrawing() {
        return this.drawing;
    }

    public int getExcelSheetNumber() {
        return this.sheetnumber;
    }

    public Object getMetadata() {
        Struct excelInfo = new Struct();
        excelInfo.put((Object)"SHEETNAME", (Object)this.sheetname);
        excelInfo.put((Object)"SHEETNUMBER", (Object)(this.sheetnumber + 1));
        excelInfo.put((Object)"ROWCOUNT", (Object)this.rowcount);
        excelInfo.put((Object)"SUMMARYINFO", (Object)this.SummaryInfo);
        return excelInfo;
    }

    public String getLabel() {
        return "SpreadSheetInfo";
    }

    public ArrayList getIgnoreColumnsForAutoResize() {
        return this.ignoreColumnsForAutoResize;
    }

    public void addIgnoreColumnsForAutoResize(int colnum) {
        this.ignoreColumnsForAutoResize.add(colnum);
    }

    public int getColumnCount() {
        int activeSheetIndex = this.getWorkbook().getActiveSheetIndex();
        return this.getColumnCount(++activeSheetIndex + "");
    }

    public int getColumnCount(Object sheet) {
        if (CFPage.IsNumeric((Object)sheet)) {
            this.sheetnumber = Cast._int((Object)sheet, (boolean)false);
            --this.sheetnumber;
        } else {
            this.sheetnumber = this.getWorkbook().getSheetIndex((String)sheet);
        }
        if (this.sheetnumber == -1 && !sheet.equals("all")) {
            throw new SpreadSheetTag.ExcelInvalidSheetNameException((String)sheet);
        }
        int result = -1;
        Sheet sheetobj = this.getWorkbook().getSheetAt(this.sheetnumber);
        int physicalNumberOfRows = sheetobj.getLastRowNum();
        for (int i = 0; i <= physicalNumberOfRows; ++i) {
            Row row = sheetobj.getRow(i);
            if (row == null) continue;
            result = Math.max(result, row.getLastCellNum());
        }
        return result;
    }

    public void formatCellRange(Struct format, int startrow, int startcolumn, int endrow, int endcolumn) {
        Excel.formatCellRange(this, format, startrow, startcolumn, endrow, endcolumn);
    }
}

