/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.ut.UnitSpan;

public class TextBaselineShift {
    public static final int BASELINE = 0;
    public static final int PERCENTAGE = 1;
    public static final int LENGTH = 2;
    public static final int SUBSCRIPT = 3;
    public static final int SUPERSCRIPT = 4;
    public static final TextBaselineShift DEFAULT_SHIFT = new TextBaselineShift();
    private int meType = 0;
    private UnitSpan moLength;
    private double mdPercentage;
    private int mnLevel;

    public TextBaselineShift() {
    }

    public TextBaselineShift(TextBaselineShift oSource) {
        this.copy(oSource);
    }

    public TextBaselineShift(double dPercentage) {
        this.meType = 1;
        this.mdPercentage = dPercentage;
    }

    public TextBaselineShift(UnitSpan oLength) {
        this.meType = 2;
        this.moLength = oLength;
    }

    public TextBaselineShift(int eType, int nLevel) {
        this.meType = eType;
        if (eType == 3 || eType == 4) {
            this.mnLevel = nLevel;
        }
    }

    public TextBaselineShift(String sString, boolean bSuppressInversion) {
        sString = sString.trim();
        this.mdPercentage = 0.0;
        if (sString.equals("baseline")) {
            this.meType = 0;
            return;
        }
        if (sString.equals("sub")) {
            this.meType = 3;
            this.mnLevel = 1;
        } else if (sString.equals("super")) {
            this.meType = 4;
            this.mnLevel = 1;
        }
        int nFound = sString.indexOf(37);
        if (nFound >= 0) {
            sString = sString.substring(0, nFound);
            this.mdPercentage = Double.parseDouble(sString);
            this.mdPercentage /= 100.0;
            if (!bSuppressInversion) {
                this.mdPercentage = -this.mdPercentage;
            }
            this.meType = 1;
        } else {
            this.moLength = new UnitSpan(sString);
            if (!bSuppressInversion) {
                this.moLength = new UnitSpan(this.moLength.units(), -this.moLength.value());
            }
            this.meType = 2;
        }
    }

    public UnitSpan[] flatten(UnitSpan oStartingBaseline, UnitSpan oLineHeight, UnitSpan poFontSize) {
        UnitSpan baseline = oStartingBaseline;
        UnitSpan fontSize = poFontSize != null ? poFontSize : oLineHeight;
        switch (this.meType) {
            case 0: {
                break;
            }
            case 1: {
                baseline = oStartingBaseline.add(oLineHeight.multiply(this.mdPercentage));
                break;
            }
            case 2: {
                baseline = oStartingBaseline.add(this.moLength);
                break;
            }
            default: {
                boolean bIsSuper = this.meType == 4;
                double nBaseScale = bIsSuper ? 0.31 : 0.15;
                double nFontScale = 0.66;
                UnitSpan shift = oLineHeight.multiply(nBaseScale);
                if (bIsSuper) {
                    shift = new UnitSpan(shift.units(), shift.value());
                }
                for (int i = 0; i < this.mnLevel; ++i) {
                    baseline = baseline.add(shift);
                    shift = shift.multiply(nFontScale);
                    fontSize = fontSize.multiply(nFontScale);
                }
            }
        }
        UnitSpan[] result = new UnitSpan[]{baseline, fontSize};
        return result;
    }

    public UnitSpan applyShift(UnitSpan oStartingBaseline, UnitSpan oLineHeight) {
        if (this.isNeutral()) {
            return oStartingBaseline;
        }
        UnitSpan[] result = this.flatten(oStartingBaseline, oLineHeight, oLineHeight);
        return result[0];
    }

    public String getString(boolean bSuppressInversion) {
        switch (this.meType) {
            case 0: {
                return "baseline";
            }
            case 3: {
                return "sub";
            }
            case 4: {
                return "super";
            }
            case 1: {
                double dValue = this.mdPercentage * 100.0;
                if (!bSuppressInversion) {
                    dValue = -dValue;
                }
                return Double.toString(dValue) + '%';
            }
        }
        UnitSpan oValue = this.moLength;
        if (!bSuppressInversion) {
            oValue = new UnitSpan(oValue.units(), -oValue.value());
        }
        return oValue.toString();
    }

    public int getType() {
        return this.meType;
    }

    public UnitSpan getLength() {
        return this.moLength == null ? UnitSpan.ZERO : this.moLength;
    }

    public double getPercentage() {
        return this.mdPercentage;
    }

    public int getLevel() {
        return this.mnLevel;
    }

    public boolean isNeutral() {
        switch (this.meType) {
            case 0: {
                return true;
            }
            case 2: {
                return this.moLength == null || this.moLength.value() == 0;
            }
            case 1: {
                return this.mdPercentage == 0.0;
            }
        }
        return this.mnLevel == 0;
    }

    public boolean isDownShift() {
        switch (this.meType) {
            case 2: {
                return this.moLength.value() > 0;
            }
            case 1: {
                return this.mdPercentage > 0.0;
            }
            case 3: {
                return this.mnLevel != 0;
            }
        }
        return false;
    }

    public TextBaselineShift copyFrom(TextBaselineShift oSource) {
        this.copy(oSource);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        TextBaselineShift cmp = (TextBaselineShift)object;
        if (this.isNeutral() && cmp.isNeutral()) {
            return true;
        }
        if (this.meType != cmp.meType) {
            return false;
        }
        switch (this.meType) {
            case 0: {
                return true;
            }
            case 1: {
                return this.mdPercentage == cmp.mdPercentage;
            }
            case 2: {
                return this.moLength == cmp.moLength;
            }
        }
        return this.mnLevel == cmp.mnLevel;
    }

    public int hashCode() {
        int hash = 43;
        hash = hash * 31 ^ Boolean.valueOf(this.isNeutral()).hashCode();
        hash = hash * 31 ^ this.meType;
        switch (this.meType) {
            case 0: {
                hash = hash * 31 ^ 1;
                break;
            }
            case 1: {
                long bits = Double.doubleToLongBits(this.mdPercentage);
                hash = hash * 31 ^ (int)(bits ^ bits >>> 32);
                break;
            }
            case 2: {
                hash = hash * 31 ^ this.moLength.hashCode();
                break;
            }
            default: {
                hash = hash * 31 ^ this.mnLevel;
            }
        }
        return hash;
    }

    public boolean notEqual(TextBaselineShift oCompare) {
        return !this.equals(oCompare);
    }

    private void copy(TextBaselineShift oSrc) {
        this.meType = oSrc.meType;
        this.mdPercentage = oSrc.mdPercentage;
        this.moLength = oSrc.moLength;
        this.mnLevel = oSrc.mnLevel;
    }
}

