/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.FrameLineHelper;
import com.adobe.xfa.text.TextSparseStream;
import com.adobe.xfa.ut.UnitSpan;

abstract class FrameCaret
extends FrameLineHelper {
    private int meCaret = 0;
    private int mnValidFrameIndex = 0;
    private int mnValidLineIndex = 0;
    private UnitSpan moValidOffset = UnitSpan.ZERO;

    FrameCaret(TextSparseStream poStream, int eProcess) {
        super(poStream, eProcess);
    }

    boolean success() {
        return this.meCaret != 0;
    }

    @Override
    protected boolean finish() {
        if (this.meCaret != 0) {
            this.setFrameIndex(this.mnValidFrameIndex);
            this.setLineIndex(this.mnValidLineIndex);
            this.setOffset(this.moValidOffset);
        }
        return true;
    }

    @Override
    protected boolean processOneLine(DispLineWrapped poLine) {
        int eCaret = this.processCaretLine(poLine);
        if (eCaret != 0) {
            this.meCaret = eCaret;
            this.mnValidFrameIndex = this.getFrameIndex();
            this.mnValidLineIndex = this.getLineIndex();
            this.moValidOffset = this.getOffset();
            if (eCaret == 2) {
                return false;
            }
        }
        return true;
    }

    abstract int processCaretLine(DispLineWrapped var1);
}

