/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.gfx;

import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.FontService;
import com.adobe.xfa.gfx.GFXDevPoint;
import com.adobe.xfa.gfx.GFXDevRect;
import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.gfx.GFXFillAttr;
import com.adobe.xfa.gfx.GFXLineAttr;
import com.adobe.xfa.gfx.GFXMappingList;
import com.adobe.xfa.gfx.GFXTextAttr;
import com.adobe.xfa.ut.Angle;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;
import java.util.ArrayList;
import java.util.List;

public abstract class GFXDriver {
    public static final int MODE_OPAQUE = 0;
    public static final int MODE_TRANSPARENT = 1;
    public static final int TYPE_PRINTER = 0;
    public static final int TYPE_SCREEN = 1;
    public static final int CAP_TYPE = 2;
    public static final int CAP_PIX_WIDTH = 3;
    public static final int CAP_PIX_HEIGHT = 4;
    public static final int CAP_REAL_WIDTH = 5;
    public static final int CAP_REAL_HEIGHT = 6;
    public static final int DRAW_2D = 0;
    public static final int DRAW_3D = 1;
    public static final int DRAW_WELL = 2;
    public static final int ACTIVE = 0;
    public static final int INACTIVE = 1;
    public static final int PUSHED = 2;
    public static final int MAPPING_SUPPRESS = 0;
    public static final int MAPPING_FULL = 1;
    public static final int MAPPING_LEGACY = 2;
    private static int FU_PER_INCH = UnitSpan.unitsPerInch(3);
    private GFXEnv mpoEnv;
    private int mlDUInchX;
    private int mlDUInchY;
    private int mlDUOffsetX;
    private int mlDUOffsetY;
    private int mlDUOriginX;
    private int mlDUOriginY;
    private double mdXScale;
    private double mdYScale;
    private double mdScale;
    private CoordPair moOrigin;
    private CoordPair moAbsPosition;
    private boolean mb3dEffects;
    private int meMode;
    private GFXLineAttr mpoLineAttr;
    private GFXFillAttr mpoFillAttr;
    private GFXTextAttr mpoTextAttr;
    private FontInstance moFontInstance;
    public List<CoordPair> moOffsetStack;
    public List<AnglePair> moAngleStack;
    public List<Rect> moClipStack;
    private static final GFXLineAttr moDefaultLineAttr = GFXLineAttr.BLACK_LINE;
    private static final GFXFillAttr moDefaultFillAttr = GFXFillAttr.WHITE_FILL;
    private static final GFXTextAttr moDefaultTextAttr = GFXTextAttr.defaultTextAttr;
    private int meGlyphOrientation;

    public GFXDriver(GFXEnv env) {
        this.mpoEnv = env;
        this.mdXScale = 1.0;
        this.mdYScale = 1.0;
        this.mdScale = 1.0;
        this.moOrigin = CoordPair.zeroZero();
        this.meMode = 1;
        this.meGlyphOrientation = 0;
    }

    public GFXEnv env() {
        return this.mpoEnv;
    }

    public int devW(UnitSpan oWidth) {
        this.checkInitialized();
        int oWMI = UnitSpan.convertUnit(3, oWidth.units(), oWidth.value());
        return this.devW(oWMI);
    }

    public int devH(UnitSpan oHeight) {
        this.checkInitialized();
        int oHMI = UnitSpan.convertUnit(3, oHeight.units(), oHeight.value());
        return this.devH(oHMI);
    }

    public GFXDevPoint devPoint(CoordPair oPoint) {
        return new GFXDevPoint(this.devX(oPoint.x()), this.devY(oPoint.y()));
    }

    public GFXDevRect devRect(Rect oRect) {
        return new GFXDevRect(this.devX(oRect.left()), this.devY(oRect.top()), this.devX(oRect.right()), this.devY(oRect.bottom()));
    }

    public int devX(UnitSpan oX) {
        this.checkInitialized();
        int oXMI = UnitSpan.convertUnit(3, oX.units(), oX.value());
        return this.devW(oXMI - this.moOrigin.x().value()) + this.mlDUOriginX;
    }

    public int devY(UnitSpan oY) {
        this.checkInitialized();
        int oYMI = UnitSpan.convertUnit(3, oY.units(), oY.value());
        return this.devH(oYMI - this.moOrigin.y().value()) + this.mlDUOriginY;
    }

    public UnitSpan devUnitX() {
        return new UnitSpan(3, FU_PER_INCH / this.mlDUInchX);
    }

    public UnitSpan devUnitY() {
        return new UnitSpan(3, FU_PER_INCH / this.mlDUInchY);
    }

    public void fit(double dScale, CoordPair oOrigin, int nFit) {
        if (dScale != this.mdScale) {
            this.mdScale = dScale > 0.0 ? dScale : 1.0;
            this.mdXScale = dScale;
            this.mdYScale = dScale;
            this.scaleChanged();
        }
        this.moOrigin = new CoordPair(new UnitSpan(3, oOrigin.x().units(), oOrigin.x().value()), new UnitSpan(3, oOrigin.y().units(), oOrigin.y().value()));
        int lWidth = this.width();
        this.mlDUOriginX = (nFit & 2) == 2 ? (lWidth + 2 * this.mlDUOffsetX) / 2 : ((nFit & 3) == 3 ? lWidth + this.mlDUOffsetX : -this.mlDUOffsetX);
        int lHeight = this.height();
        this.mlDUOriginY = (nFit & 8) == 8 ? (lHeight + 2 * this.mlDUOffsetY) / 2 : ((nFit & 0xC) == 12 ? lHeight + this.mlDUOffsetY : -this.mlDUOffsetY);
    }

    public CoordPair rotatePoint(CoordPair oPoint) {
        CoordPair oRP = this.rotationPoint(false);
        int oX = UnitSpan.convertUnit(3, oPoint.x().units(), oPoint.x().value());
        int oY = -UnitSpan.convertUnit(3, oPoint.y().units(), oPoint.y().value());
        int oRPX = UnitSpan.convertUnit(3, oRP.x().units(), oRP.x().value());
        int oRPY = -UnitSpan.convertUnit(3, oRP.y().units(), oRP.y().value());
        int lX = oX;
        int lY = -oY;
        int lXR = oRPX;
        int lYR = -oRPY;
        Angle oAngle = this.angle(false);
        switch (oAngle.degrees()) {
            case 0: {
                break;
            }
            case 90: {
                oX = lXR - (lY - lYR);
                oY = -(lYR + (lX - lXR));
                break;
            }
            case 180: {
                oX = lXR - (lX - lXR);
                oY = -(lYR - (lY - lYR));
                break;
            }
            case 270: {
                oX = lXR + (lY - lYR);
                oY = -(lYR - (lX - lXR));
                break;
            }
            default: {
                double dRadians = (double)oAngle.degrees() * (Math.PI / 180);
                double dCosAngle = Math.cos(dRadians);
                double dSinAngle = Math.sin(dRadians);
                oX = (int)Math.round((double)lXR + (double)(lX - lXR) * dCosAngle - (double)(lY - lYR) * dSinAngle);
                oY = (int)Math.round((double)lYR + (double)(lY - lYR) * dCosAngle + (double)(lX - lXR) * dSinAngle);
            }
        }
        return new CoordPair(new UnitSpan(3, oX), new UnitSpan(3, oY));
    }

    public CoordPair offsetPoint(CoordPair oPoint) {
        return oPoint.add(this.offset(false));
    }

    public double scale() {
        return this.mdScale;
    }

    public UnitSpan unitW(int lWidth) {
        this.checkInitialized();
        int lWMI = (int)Math.round((double)lWidth / this.mdXScale);
        return new UnitSpan(UnitSpan.defaultUnits(), 3, lWMI);
    }

    public UnitSpan unitH(int lHeight) {
        this.checkInitialized();
        int lHMI = (int)Math.round((double)lHeight / this.mdYScale);
        return new UnitSpan(UnitSpan.defaultUnits(), 3, lHMI);
    }

    public CoordPair unitPoint(int lX, int lY) {
        return new CoordPair(this.unitX(lX), this.unitY(lY));
    }

    public Rect unitRect(int lLeft, int lTop, int lRight, int lBottom) {
        return new Rect(this.unitX(lLeft), this.unitY(lTop), this.unitX(lRight), this.unitY(lBottom));
    }

    public UnitSpan unitX(int lX) {
        this.checkInitialized();
        int lXMI = (int)Math.round((double)(lX - this.mlDUOriginX) / this.mdXScale) + this.moOrigin.x().value();
        return new UnitSpan(UnitSpan.defaultUnits(), 3, lXMI);
    }

    public UnitSpan unitY(int lY) {
        this.checkInitialized();
        int lYMI = (int)Math.round((double)(lY - this.mlDUOriginY) / this.mdYScale) + this.moOrigin.y().value();
        return new UnitSpan(UnitSpan.defaultUnits(), 3, lYMI);
    }

    public int mode() {
        return this.meMode;
    }

    public void mode(int eNewMode) {
        this.meMode = eNewMode;
    }

    public GFXLineAttr lineAttr() {
        return this.mpoLineAttr;
    }

    public void lineAttr(GFXLineAttr poNewAttr) {
        this.mpoLineAttr = poNewAttr == null ? moDefaultLineAttr : new GFXLineAttr(poNewAttr);
    }

    public GFXFillAttr fillAttr() {
        return this.mpoFillAttr;
    }

    public void fillAttr(GFXFillAttr poNewAttr) {
        this.mpoFillAttr = poNewAttr == null ? moDefaultFillAttr : new GFXFillAttr(poNewAttr);
    }

    public GFXTextAttr textAttr() {
        return this.mpoTextAttr;
    }

    public void textAttr(GFXTextAttr poNewAttr) {
        this.mpoTextAttr = poNewAttr == null ? moDefaultTextAttr : new GFXTextAttr(poNewAttr);
    }

    public FontInstance fontInstance() {
        if (this.moFontInstance == null) {
            this.fontInstance(null);
        }
        return this.moFontInstance;
    }

    public void fontInstance(FontInstance poNewFont) {
        if (poNewFont == null) {
            FontService pFontService;
            GFXEnv pEnv = this.env();
            if (pEnv != null && (pFontService = pEnv.fontService()) != null) {
                this.moFontInstance = pFontService.getDefaultFontInstance();
            }
            assert (this.moFontInstance != null);
        } else {
            this.moFontInstance = poNewFont;
        }
    }

    public int glyphOrientation() {
        return this.meGlyphOrientation;
    }

    public void glyphOrientation(int eNewGlyphOrientation) {
        this.meGlyphOrientation = eNewGlyphOrientation;
    }

    public UnitSpan charSpacing() {
        return UnitSpan.ZERO;
    }

    public void charSpacing(UnitSpan oNewSpacing) {
    }

    public boolean charSpacingSupported() {
        return false;
    }

    public UnitSpan wordSpacing() {
        return UnitSpan.ZERO;
    }

    public void wordSpacing(UnitSpan oNewSpacing) {
    }

    public boolean wordSpacingSupported() {
        return false;
    }

    public void pushOffset(boolean bRelative, CoordPair oOffset) {
        if (this.moOffsetStack == null) {
            this.moOffsetStack = new ArrayList<CoordPair>();
        }
        if (bRelative) {
            oOffset = oOffset.add(this.offset());
        }
        this.moOffsetStack.add(oOffset);
    }

    public void popOffset() {
        this.moOffsetStack.remove(this.moOffsetStack.size() - 1);
    }

    public CoordPair offset(boolean bRelative) {
        if (this.moOffsetStack == null || this.moOffsetStack.size() == 0) {
            return CoordPair.zeroZero();
        }
        CoordPair last = this.moOffsetStack.get(this.moOffsetStack.size() - 1);
        if (!bRelative || this.moOffsetStack.size() == 1) {
            return last;
        }
        return last.subtract(this.moOffsetStack.get(this.moOffsetStack.size() - 2));
    }

    public CoordPair offset() {
        return this.offset(false);
    }

    public void pushAngle(boolean bRelative, Angle oAngle, boolean bOffsetPoint, CoordPair oRotationPoint) {
        if (this.moAngleStack == null) {
            this.moAngleStack = new ArrayList<AnglePair>();
        }
        if (bOffsetPoint) {
            oRotationPoint = oRotationPoint.add(this.offset(false));
        }
        AnglePair pair = new AnglePair(bRelative && this.moAngleStack.size() > 0 ? oAngle.add(oAngle) : oAngle, oRotationPoint);
        this.moAngleStack.add(pair);
    }

    public void popAngle() {
        this.moAngleStack.remove(this.moAngleStack.size() - 1);
    }

    public Angle angle(boolean bRelative) {
        if (this.moAngleStack == null || this.moAngleStack.size() == 0) {
            return Angle.ZERO;
        }
        AnglePair last = this.getAngle(this.moAngleStack.size() - 1);
        if (!bRelative || this.moAngleStack.size() == 1) {
            return last.angle;
        }
        AnglePair secondLast = this.getAngle(this.moAngleStack.size() - 2);
        Angle result = last.angle;
        return result.subtract(secondLast.angle);
    }

    public Angle angle() {
        return this.angle(false);
    }

    public CoordPair rotationPoint(boolean bRelative) {
        if (this.moAngleStack == null || this.moAngleStack.size() == 0) {
            return CoordPair.zeroZero();
        }
        AnglePair last = this.getAngle(this.moAngleStack.size() - 1);
        if (!bRelative || this.moAngleStack.size() == 1) {
            return last.point;
        }
        return last.point.subtract(this.offset());
    }

    public void pushClipRect(boolean bRelative, Rect oClipRect) {
        if (this.moClipStack == null) {
            this.moClipStack = new ArrayList<Rect>();
        }
        if (bRelative) {
            oClipRect = oClipRect.add(this.offset(false));
        }
        if (this.moClipStack.size() > 0) {
            oClipRect = oClipRect.intersection(this.clipRect());
        }
        this.moClipStack.add(oClipRect);
        this.setClipRect(this.clipRect(false));
    }

    public void popClipRect() {
        this.moClipStack.remove(this.moClipStack.size() - 1);
        this.setClipRect(this.clipRect(false));
    }

    public Rect clipRect(boolean bRelative) {
        if (this.moClipStack == null || this.moClipStack.size() == 0) {
            return this.visibleArea();
        }
        Rect last = this.moClipStack.get(this.moClipStack.size() - 1);
        if (!bRelative || this.moOffsetStack.size() == 0) {
            return last;
        }
        return last.subtract(this.offset());
    }

    public Rect clipRect() {
        return this.clipRect(false);
    }

    public void clearStacks() {
        this.moOffsetStack = null;
        this.moAngleStack = null;
        this.moClipStack = null;
        this.setClipRect(this.visibleArea());
    }

    public CoordPair relPosition() {
        return this.absPosition().subtract(this.offset(false));
    }

    public void relPosition(CoordPair oStart) {
        this.absPosition(oStart.add(this.offset(false)));
    }

    public void relLine(CoordPair oEnd, int eDrawMode) {
        this.absLine(oEnd.add(this.offset(false)), eDrawMode);
    }

    public void relLine(CoordPair oStart, CoordPair oEnd, int eDrawMode) {
        CoordPair oOffset = this.offset(false);
        this.absLine(oStart.add(oOffset), oEnd.add(oOffset), eDrawMode);
    }

    public void relLine(CoordPair oStart, CoordPair oEnd) {
        CoordPair oOffset = this.offset(false);
        this.absLine(oStart.add(oOffset), oEnd.add(oOffset), 0);
    }

    public void relFillRect(Rect oRect, int eDrawMode) {
        this.absFillRect(oRect.add(this.offset(false)), eDrawMode);
    }

    public void relFillRect(Rect oRect) {
        this.absFillRect(oRect.add(this.offset(false)), 0);
    }

    public void relText(String oText, int eDrawMode) {
        this.absText(oText, eDrawMode);
    }

    public void relText(String oText) {
        this.absText(oText, 0);
    }

    public void relGlyphs(int[] pnGlyphs, int length) {
        this.absGlyphs(pnGlyphs, length);
    }

    public CoordPair absPosition() {
        return this.getAbsPosition();
    }

    public void absPosition(CoordPair oStart) {
        this.setAbsPosition(oStart);
    }

    public abstract void absLine(CoordPair var1, int var2);

    public void absLine(CoordPair oStart, CoordPair oEnd, int eDrawMode) {
        CoordPair oTemp = this.absPosition();
        this.absPosition(oStart);
        this.absLine(oEnd, eDrawMode);
        this.absPosition(oTemp);
    }

    public abstract void absFillRect(Rect var1, int var2);

    public abstract void absText(String var1, int var2);

    public void absGlyphs(int[] pnGlyphs, int length) {
    }

    public void setUnicodeChars(int[] text) {
    }

    public void pushRenderContext(int[] pcText, int pnCharIndex) {
    }

    public void popRenderContext() {
    }

    public void mapChars(int nIndex, int nLength) {
    }

    public void mapGlyphs(GFXMappingList oMappings, boolean bIsRTL) {
    }

    public int getMappingLevel() {
        return 2;
    }

    public int dotsPerInch() {
        this.checkInitialized();
        return this.mlDUInchX;
    }

    public abstract int height();

    public abstract int width();

    public abstract boolean interactive();

    public Rect visibleArea() {
        return this.unitRect(0, 0, this.width(), this.height());
    }

    public CoordPair nonPrintOffset() {
        return this.unitPoint(this.mlDUOffsetX, this.mlDUOffsetY);
    }

    public void paraHint() {
    }

    public void resolutionChanged() {
    }

    public UnitSpan heightInUnits() {
        this.checkInitialized();
        int lHMI = this.height() * (FU_PER_INCH / this.mlDUInchY);
        return new UnitSpan(UnitSpan.defaultUnits(), 3, lHMI);
    }

    public UnitSpan widthInUnits() {
        this.checkInitialized();
        int lWMI = this.width() * (FU_PER_INCH / this.mlDUInchX);
        return new UnitSpan(UnitSpan.defaultUnits(), 3, lWMI);
    }

    public boolean draw3dEffects() {
        return this.mb3dEffects;
    }

    public void draw3dEffects(boolean b3dEffects) {
        this.mb3dEffects = b3dEffects;
    }

    protected CoordPair getAbsPosition() {
        return this.moAbsPosition;
    }

    protected void setAbsPosition(CoordPair oAbsPosition) {
        this.moAbsPosition = oAbsPosition;
    }

    protected void initDeviceUnitsPerInch(double dUnits) {
        this.mdXScale = dUnits;
        this.mdYScale = dUnits;
        this.mlDUInchY = this.mlDUInchX = (int)Math.round(dUnits);
        this.mdScale = dUnits / (double)this.mlDUInchX;
    }

    protected void initDeviceUnitsPerInch(int lX, int lY) {
        this.mlDUInchX = lX;
        this.mlDUInchY = lY;
    }

    protected void initDeviceOffsets(int lX, int lY) {
        this.mlDUOffsetX = lX;
        this.mlDUOffsetY = lY;
    }

    protected void scaleChanged() {
    }

    protected abstract void setClipRect(Rect var1);

    protected boolean angleIsRight() {
        if (this.moAngleStack != null && this.moAngleStack.size() > 0) {
            int lDegrees = this.getAngle((int)(this.moAngleStack.size() - 1)).angle.degrees();
            return lDegrees == 0 || lDegrees == 90 || lDegrees == 180 || lDegrees == 270;
        }
        return true;
    }

    private void checkInitialized() {
        if (this.mlDUInchX <= 0 || this.mlDUInchY <= 0) {
            // empty if block
        }
    }

    private int devW(int pts1000) {
        return (int)Math.round((double)pts1000 * this.mdXScale);
    }

    private int devH(int pts1000) {
        return (int)Math.round((double)pts1000 * this.mdYScale);
    }

    private AnglePair getAngle(int index) {
        if (this.moAngleStack == null || this.moAngleStack.size() == 0) {
            return null;
        }
        return this.moAngleStack.get(index);
    }

    private static class AnglePair {
        final Angle angle;
        final CoordPair point;

        public AnglePair(Angle angle, CoordPair point) {
            this.angle = angle;
            this.point = point;
        }
    }
}

