/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.Frame;
import com.adobe.xfa.formcalc.Stack;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;

public final class FrameTable {
    static final int SIZE = 128;
    private int mnFrameTableSize;
    private Frame[] mpFrameTableBase;
    private int mpFrameTablePtr;

    FrameTable() {
    }

    int create(int nTableSize) {
        this.mnFrameTableSize = nTableSize;
        this.mpFrameTableBase = new Frame[this.mnFrameTableSize];
        this.mpFrameTablePtr = 0;
        return 1;
    }

    void init() {
        for (int i = 0; i < this.mnFrameTableSize; ++i) {
            this.mpFrameTableBase[i] = null;
        }
        this.mpFrameTablePtr = 0;
    }

    int getSize() {
        return this.mnFrameTableSize;
    }

    public int getDepth() {
        return this.mpFrameTablePtr;
    }

    Frame pop() {
        assert (this.mpFrameTablePtr > 0);
        return this.mpFrameTableBase[--this.mpFrameTablePtr];
    }

    void push(Frame oFrame) {
        if (this.mpFrameTablePtr >= this.mnFrameTableSize) {
            this.mnFrameTableSize <<= 1;
            Frame[] oNewBase = new Frame[this.mnFrameTableSize];
            System.arraycopy(this.mpFrameTableBase, 0, oNewBase, 0, this.mnFrameTableSize >> 1);
            this.mpFrameTableBase = oNewBase;
            this.mpFrameTablePtr = this.mnFrameTableSize >> 1;
        }
        this.mpFrameTableBase[this.mpFrameTablePtr++] = oFrame;
    }

    public Frame peek() {
        assert (this.mpFrameTablePtr > 0);
        return this.mpFrameTableBase[this.mpFrameTablePtr - 1];
    }

    public String getStackTrace(Stack oStack) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "FrameTable#getStackTrace");
    }
}

