/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.document;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFUtils;
import com.adobe.internal.pdftoolkit.xpdf.model.XPDFCosObject;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFFileSpecification
extends XPDFCosObject {
    private PDFFileSpecification pdfFileSpecification;
    StringBuilder desc = null;

    public XPDFFileSpecification(PDFFileSpecification pdfFileSpecification) {
        this.pdfFileSpecification = pdfFileSpecification;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        ASString name;
        String[] x;
        AttributesImpl att = new AttributesImpl();
        ASName fsType = this.pdfFileSpecification.getFSType();
        if (fsType != null) {
            x = XPDFUtils.asNameToXPDF(fsType);
            if (!"ASCII".equals(x[1]) && !"PDFDocEncoding".equals(x[1])) {
                att.addAttribute("", "FSType_enc", "FSType_enc", "CDATA", x[1]);
            }
            att.addAttribute("", "FSType", "FSType", "CDATA", x[0]);
        }
        if ((name = this.pdfFileSpecification.getFilename()) != null) {
            x = XPDFUtils.asStringToXPDF(name);
            if (!"ASCII".equals(x[1]) && !"PDFDocEncoding".equals(x[1])) {
                att.addAttribute("", "Name_enc", "Name_enc", "CDATA", x[1]);
            }
        } else {
            throw new PDFInvalidDocumentException("Missing /F in FileSpecification");
        }
        att.addAttribute("", "Name", "Name", "CDATA", x[0]);
        ch.startElement(parentName, att);
        String desc = this.pdfFileSpecification.getDescription();
        if (desc != null) {
            ch.startElement("Desc");
            ch.characters(desc);
            ch.endElement("Desc");
        }
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String name;
        String fsType = att.getValue("FSType");
        if (fsType != null) {
            this.pdfFileSpecification.setFSType(XPDFUtils.asNameFromXPDF(fsType, att.getValue("FSType_enc"), eh));
        }
        if ((name = att.getValue("Name")) != null) {
            ASString fileName = XPDFUtils.asStringFromXPDF(name, att.getValue("Name_enc"), eh);
            this.pdfFileSpecification.setFileName(fileName);
            this.pdfFileSpecification.setUnicodeName(name);
        } else {
            eh.XPDFError("Missing 'Name' attribute");
        }
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("Desc".equals(lName)) {
            this.desc = new StringBuilder();
            return null;
        }
        return eh.XPDFInvalidElement(lName);
    }

    @Override
    public void fromXPDFCharacters(char[] chars, int start, int length, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (this.desc != null) {
            this.desc.append(chars, start, length);
            return;
        }
        eh.XPDFErrorIfNotWhitespace(chars, start, length);
    }

    @Override
    public void fromXPDFEndElement(String lName, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ("Desc".equals(lName)) {
            this.pdfFileSpecification.setDescription(this.desc.toString());
            this.desc = null;
        }
    }
}

