/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationInk;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFInk;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFInkList;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationInk
extends XFDFAnnotation {
    static final String ELEM_INK = "ink";
    static final String ELEM_INKLIST = "inklist";
    static final String ELEM_GESTURE = "gesture";
    static final String GESTTURE_PAIR = ",";
    static final String GESTTURE_END = ";";
    static final int GESTURE_LEN = 32;

    XFDFAnnotationInk(PDFAnnotationInk pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationInk(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addBorderStyleXFDFAttributes(annotsAtts, false);
        try {
            handler.startElement("", ELEM_INK, ELEM_INK, annotsAtts);
            if (this.pdfAnnot.dictionaryContains(ASName.k_InkList)) {
                handler.characters(END_ELEM, 0, 1);
                handler.startElement("", ELEM_INKLIST, ELEM_INKLIST, nullAttrs);
                PDFInkList inks = ((PDFAnnotationInk)this.pdfAnnot).getInkList();
                for (int inksInd = 0; inksInd < inks.size(); ++inksInd) {
                    PDFInk curInk = (PDFInk)inks.get(inksInd);
                    String inkContent = this.createPairedList(curInk, GESTTURE_PAIR, GESTTURE_END);
                    this.createGesture(handler, inkContent);
                }
                handler.endElement("", ELEM_INKLIST, ELEM_INKLIST);
            }
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.createXFDFPopupElement(handler, pageNum);
            handler.endElement("", ELEM_INK, ELEM_INK);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationInk inkAnnot = PDFAnnotationInk.newInstance(this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes(inkAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            this.fillCommonAttributes(inkAnnot, elemAttrs);
            this.fillMarkupAttributes(inkAnnot, elemAttrs);
            this.fillBorderStyleAttributes(inkAnnot, elemAttrs);
            int attrInd = XFDFAnnotationInk.findAttribute("rotation", elemAttrs);
            if (attrInd != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                inkAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    inkAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if (this.setAnnotation(inkAnnot, gotPage)) {
                this.pdfAnnot = inkAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }

    void createInk(String inkListString) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (!(this.pdfAnnot instanceof PDFAnnotationInk)) {
            return;
        }
        PDFAnnotationInk inkAnnot = (PDFAnnotationInk)this.pdfAnnot;
        PDFInkList inkList = inkAnnot.procureInkList();
        List vertices = this.parsePairedList(inkListString, GESTTURE_PAIR, GESTTURE_END, false);
        inkList.addPath(vertices);
        inkAnnot.setInkList(inkList);
    }

    void createGesture(ContentHandler handler, String content) {
        if (content.length() > 0) {
            try {
                handler.startElement("", ELEM_GESTURE, ELEM_GESTURE, nullAttrs);
                handler.characters(content.toCharArray(), 0, content.length());
                handler.endElement("", ELEM_GESTURE, ELEM_GESTURE);
            }
            catch (SAXException e) {
                throw new RuntimeException("Unable to create XFDF element", e);
            }
        }
    }
}

