/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.PDFDocEncoding;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFDestination;

public final class XFDFActions
extends PDFCosDictionary {
    private CosDictionary actionDict;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_LAUNCH = 1;
    public static final int ACTION_GOTO = 2;
    public static final int ACTION_GOTOR = 3;
    public static final int ACTION_NAMED = 4;
    public static final int ACTION_URI = 5;

    private XFDFActions(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    static XFDFActions create(CosObject cosObject) throws PDFInvalidDocumentException {
        XFDFActions actions = new XFDFActions(cosObject);
        actions.actionDict = (CosDictionary)cosObject;
        return actions;
    }

    public static XFDFActions create(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary action = PDFCosObject.newCosDictionary(pdfDoc);
        action.put(ASName.k_Type, ASName.k_Action);
        return XFDFActions.create(action);
    }

    public static XFDFActions getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return new XFDFActions(cosObject);
    }

    public int getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int type = 0;
        ASName actionType = this.actionDict.getName(ASName.k_S);
        if (actionType != null) {
            type = actionType.equals(ASName.k_GoTo) ? 2 : (actionType.equals(ASName.k_GoToR) ? 3 : (actionType.equals(ASName.k_Named) ? 4 : (actionType.equals(ASName.k_Launch) ? 1 : (actionType.equals(ASName.k_URI) ? 5 : 0))));
        }
        return type;
    }

    public String getTypeAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getType() == 0) {
            return null;
        }
        return this.actionDict.getName(ASName.k_S).asString(true);
    }

    public void setType(String type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_S, type);
    }

    public boolean hasNewWindow() {
        return this.actionDict.containsKey(ASName.k_NewWindow);
    }

    public String getNewWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getType() == 1 && this.hasNewWindow()) {
            return Boolean.toString(this.actionDict.getBoolean(ASName.k_NewWindow));
        }
        return null;
    }

    public void setNewWindow(String newWindow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_NewWindow, newWindow);
    }

    public String getURI() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getType() == 5) {
            PDFText uri = PDFText.getInstance(this.actionDict.getCosString(ASName.k_URI));
            return uri != null ? uri.stringValue() : "";
        }
        return null;
    }

    public void setURI(String uri) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_URI, uri);
    }

    public void setURI(String uri, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_URI, uri, unicode);
    }

    public boolean hasIsMap() {
        return this.actionDict.containsKey(ASName.k_IsMap);
    }

    public boolean getIsMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasIsMap() ? this.actionDict.getBoolean(ASName.k_IsMap) : false;
    }

    public void setIsMap(String isMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_IsMap, isMap);
    }

    public void setIsMap(boolean isMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_IsMap, isMap);
    }

    public boolean hasNamed() {
        return this.actionDict.containsKey(ASName.k_N);
    }

    public ASName getNamed() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasNamed() ? this.actionDict.getName(ASName.k_N) : null;
    }

    public void setNamed(String named) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_N, named);
    }

    public void setNamed(ASName named) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_N, named);
    }

    public XFDFDestination getDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getType() == 2 && this.actionDict.containsKey(ASName.k_D)) {
            return XFDFDestination.getInstance(this.actionDict.get(ASName.k_D));
        }
        return null;
    }

    public void setDestination(XFDFDestination dest) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_D, dest);
    }

    public boolean hasFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }

    public PDFFileSpecification getFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasFileSpecification()) {
            return null;
        }
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    public void setFileSpecification(PDFFileSpecification fileSpec) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_F, fileSpec);
    }

    public String getFilename() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFileSpecification fileSpec = this.getFileSpecification();
        if (fileSpec == null) {
            return null;
        }
        byte[] bytes = fileSpec.getFilename().getBytes();
        return PDFDocEncoding.toEscapeString(bytes, 0, bytes.length);
    }
}

