/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.impl;

import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class PDFXFAOutput
extends DefaultHandler
implements XMLReader {
    ContentHandler mOutputHandler;
    private boolean mCopying;
    private boolean mHadData;
    private boolean mMultipleRoot;
    private boolean mCopyElement;
    private boolean mXFAAttributeFound;
    private int mOutputLevel;
    private int mXFALevel;
    private int mNestingLevel;
    private String requestedElement;
    static final String nsu = "";

    public PDFXFAOutput(boolean copyElement, String requestedElement) {
        this.mCopyElement = copyElement;
        this.requestedElement = requestedElement;
    }

    public boolean hasMultipleRoot() {
        return this.mMultipleRoot;
    }

    public boolean hasXFAAttributes() {
        return this.mXFAAttributeFound;
    }

    @Override
    public void parse(InputSource source) throws IOException, SAXException {
        if (this.mOutputHandler == null) {
            throw new SAXException("No content handler");
        }
        this.mOutputHandler.startDocument();
        this.HandleData(source);
        this.mOutputHandler.endDocument();
    }

    public void HandleData(InputSource source) throws SAXException, IOException {
        InputStream xfaStream = source.getByteStream();
        try {
            SAXParser saxParser = XMLUtils.getNonValidatingSaxParser();
            saxParser.parse(xfaStream, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public boolean hadData() {
        return this.mHadData;
    }

    @Override
    public void setDocumentLocator(Locator l) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes elemAttrs) throws SAXException {
        boolean startCopyingAfterThis = false;
        ++this.mNestingLevel;
        if (!this.mCopying) {
            String elemName = sName;
            if (elemName == null || elemName.length() == 0) {
                elemName = qName;
            }
            if (elemName == null || elemName.length() == 0) {
                throw new SAXException(" Wrong XML structure");
            }
            if (this.mNestingLevel <= 2 && elemName.equals(this.requestedElement)) {
                if (this.mCopyElement) {
                    this.mCopying = true;
                } else {
                    startCopyingAfterThis = true;
                }
            }
        }
        if (this.mCopying) {
            if (this.mXFALevel == 0) {
                int attrLength = elemAttrs.getLength();
                boolean alreadyDefined = false;
                for (int i = 0; i < attrLength; ++i) {
                    String aName = elemAttrs.getQName(i);
                    if (aName.indexOf("xfa:") < 0) continue;
                    for (int j = 0; j < attrLength; ++j) {
                        String other = elemAttrs.getQName(j);
                        if (!"xmlns:xfa".equals(other)) continue;
                        alreadyDefined = true;
                        break;
                    }
                    if (!alreadyDefined) {
                        AttributesImpl newAttrs = new AttributesImpl();
                        newAttrs.addAttribute(nsu, nsu, "xmlns:xfa", "CDATA", "http://www.xfa.org/schema/xfa-data/1.0/");
                        for (int j = 0; j < attrLength; ++j) {
                            newAttrs.addAttribute(elemAttrs.getURI(j), elemAttrs.getLocalName(j), elemAttrs.getQName(j), elemAttrs.getType(j), elemAttrs.getValue(j));
                        }
                        elemAttrs = newAttrs;
                        ++this.mXFALevel;
                        this.mXFAAttributeFound = true;
                    }
                    break;
                }
            } else {
                ++this.mXFALevel;
            }
            this.mOutputHandler.startElement(namespaceURI, sName, qName, elemAttrs);
            if (this.mHadData && this.mOutputLevel == 0) {
                this.mMultipleRoot = true;
            }
            this.mHadData = true;
            ++this.mOutputLevel;
        }
        if (startCopyingAfterThis) {
            this.mCopying = true;
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        boolean stopCopyingAfterThis = false;
        if (this.mCopying) {
            String elemName = sName;
            if (elemName == null || elemName.length() == 0) {
                elemName = qName;
            }
            if (elemName == null || elemName.length() == 0) {
                throw new SAXException("xfa: Wrong XML structure");
            }
            if (this.mNestingLevel <= 2 && elemName.equals(this.requestedElement)) {
                if (this.mCopyElement) {
                    stopCopyingAfterThis = true;
                } else {
                    this.mCopying = false;
                }
            }
        }
        if (this.mCopying) {
            this.mOutputHandler.endElement(namespaceURI, sName, qName);
            --this.mOutputLevel;
            if (this.mXFALevel > 0) {
                --this.mXFALevel;
            }
        }
        --this.mNestingLevel;
        if (stopCopyingAfterThis) {
            this.mCopying = false;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.mCopying) {
            this.mOutputHandler.characters(buf, offset, len);
        }
    }

    @Override
    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        if (this.mCopying) {
            this.mOutputHandler.ignorableWhitespace(buf, offset, len);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.mCopying) {
            this.mOutputHandler.processingInstruction(target, data);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    @Override
    public void warning(SAXParseException err) throws SAXParseException {
        throw err;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.mOutputHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.mOutputHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }
}

