/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.javascript.Color;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.ExFull;
import java.util.List;

public final class Utils {
    private static StringBuilder strip(StringBuilder s) {
        while (s.length() > 0 && s.charAt(0) == ' ') {
            s.deleteCharAt(0);
        }
        return s;
    }

    public static boolean scrubFieldName(StringBuilder sFldName) {
        if (sFldName.length() > 0) {
            Utils.strip(sFldName);
            boolean bMore = true;
            while (bMore && sFldName.length() > 0) {
                bMore = false;
                int iLastChar = sFldName.length() - 1;
                if (sFldName.charAt(iLastChar) == '.') {
                    sFldName.deleteCharAt(iLastChar);
                    bMore = true;
                }
                if (sFldName.charAt(0) == '.') {
                    sFldName.deleteCharAt(0);
                    bMore = true;
                }
                Utils.strip(sFldName);
            }
        }
        return sFldName.length() > 0;
    }

    public static int separateFieldNameFromWidgetNum(StringBuilder sFldName, char cSeparator) {
        int iWidget = -1;
        int iPosOfDot = sFldName.indexOf(String.valueOf(cSeparator));
        if (iPosOfDot >= 0) {
            int iTraverse = sFldName.length() - 1;
            boolean bDigits = false;
            iWidget = 0;
            int iExp = 1;
            while (iTraverse > 0 && Character.isDigit(sFldName.charAt(iTraverse))) {
                iWidget += (sFldName.charAt(iTraverse--) - 48) * iExp;
                iExp *= 10;
                bDigits = true;
            }
            if (bDigits && sFldName.charAt(iTraverse) == cSeparator) {
                sFldName.delete(0, iPosOfDot);
            } else {
                iWidget = -1;
            }
        }
        return iWidget;
    }

    public static Color unloadColor(Object[] array) {
        try {
            Color color = new Color();
            color.setValue(array, false);
            return color;
        }
        catch (Exception e) {
            throw new ExFull(e);
        }
    }

    public static Object[] getRGBColorValue(Color color) {
        try {
            Object[] value = ((List)color.getValue()).toArray();
            Object[] rgb = new Object[4];
            rgb[0] = "RGB";
            String colorSpace = (String)value[0];
            if ("G".equals(colorSpace)) {
                rgb[2] = rgb[3] = value[1];
                rgb[1] = rgb[3];
            } else if ("CMYK".equals(colorSpace)) {
                rgb[1] = 1.0 - Math.min(1.0, (Double)value[1] + (Double)value[4]);
                rgb[2] = 1.0 - Math.min(1.0, (Double)value[2] + (Double)value[4]);
                rgb[3] = 1.0 - Math.min(1.0, (Double)value[3] + (Double)value[4]);
            } else if ("RGB".equals(colorSpace)) {
                rgb = value;
            }
            return rgb;
        }
        catch (Exception e) {
            throw new ExFull(e);
        }
    }

    public static Object getRGBColorObject(int red, int green, int blue) throws Exception {
        double[] rgb = new double[]{(double)red * 1.0 / 255.0, (double)green * 1.0 / 255.0, (double)blue * 1.0 / 255.0};
        Color color = new Color();
        color.setValue("RG", rgb);
        return color.getValue();
    }

    static Node getChildNodeByName(Node oParent, String aClassName, String aName) {
        if (aClassName == null || aName == null || oParent == null || "".equals(aClassName)) {
            return null;
        }
        for (Node oChild = oParent.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
            if (!(oChild instanceof Element) || !aClassName.equals(oChild.getName())) continue;
            if (!"".equals(aName)) {
                String aNameAttr = ((Element)oChild).getAttribute(XFA.NAMETAG, true, false).toString();
                if (!aName.equals(aNameAttr)) continue;
                return oChild;
            }
            return oChild;
        }
        return null;
    }

    public static void AlertNote(String message, int severity, PDFDocument pdfDoc) {
        XFAProcessingOptions xfaOptions;
        if (pdfDoc != null && (xfaOptions = XFADOMService.getXFAProcessingOptions(pdfDoc)) != null) {
            xfaOptions.addErrorMessage(message);
        }
    }
}

