/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFCharacter;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.SamePositionCharacterComparator;
import java.util.Comparator;

class VerticalCharacterSorter
implements Comparator {
    VerticalCharacterSorter() {
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        PDFCharacter c1 = (PDFCharacter)o1;
        PDFCharacter c2 = (PDFCharacter)o2;
        ASCoordinate origin1 = c1.getOrigin();
        ASCoordinate origin2 = c2.getOrigin();
        double x1 = origin1.x();
        double y1 = origin1.y();
        double x2 = origin2.x();
        double y2 = origin2.y();
        if (x1 < x2) {
            return -1;
        }
        if (x2 > x1) {
            return 1;
        }
        if (y1 > y2) {
            return -1;
        }
        if (y1 < y2) {
            return 1;
        }
        try {
            return SamePositionCharacterComparator.compareTo(c1, c2);
        }
        catch (Exception e) {
            throw new PDFRuntimeException("Exception occured while comparing unicode strings.", e);
        }
    }
}

