/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rcg.impl;

import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class RichTextRedundantSpaceRemover
extends XMLFilterImpl {
    private boolean newLineStarted;
    private boolean lastCharSpace;
    private Stack<Boolean> insideXfaSpaceRun = new Stack();

    private RichTextRedundantSpaceRemover() {
    }

    public static RichTextRedundantSpaceRemover getInstance() throws SAXException {
        RichTextRedundantSpaceRemover spaceRemover = new RichTextRedundantSpaceRemover();
        spaceRemover.setParent(XMLUtils.getXMLReader());
        return spaceRemover;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            if (!this.insideXfaSpaceRun.peek().booleanValue()) {
                String chStr = new String(ch, start, length);
                chStr = chStr.replaceAll("\\s+", " ");
                if ((this.lastCharSpace || this.newLineStarted) && chStr.startsWith(" ")) {
                    chStr = chStr.substring(1);
                }
                this.lastCharSpace = chStr.endsWith(" ");
                if (chStr.length() > 0) {
                    this.newLineStarted = false;
                }
                super.characters(chStr.toCharArray(), 0, chStr.length());
            } else {
                String chStr = new String(ch, start, length);
                chStr = chStr.replaceAll("\t|\r|\n", "");
                this.lastCharSpace = false;
                super.characters(chStr.toCharArray(), 0, chStr.length());
            }
            return;
        }
        super.characters(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("br".equalsIgnoreCase(localName) || "p".equalsIgnoreCase(localName)) {
            this.newLineStarted = true;
        }
        boolean xfaSpaceRunAttribute = false;
        if (atts != null) {
            int totalAttributes = atts.getLength();
            for (int i = 0; i < totalAttributes; ++i) {
                String attributeValue;
                if (!"style".equalsIgnoreCase(atts.getLocalName(i)) || !(attributeValue = atts.getValue(i)).contains("xfa-spacerun:yes")) continue;
                xfaSpaceRunAttribute = true;
                break;
            }
        }
        this.insideXfaSpaceRun.push(xfaSpaceRunAttribute);
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("br".equalsIgnoreCase(localName)) {
            this.newLineStarted = true;
        }
        this.insideXfaSpaceRun.pop();
        super.endElement(uri, localName, qName);
    }
}

