/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.permissions.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReference;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReferenceList;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureUtils;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersUR;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURAnnots;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURDocument;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFUREmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURForm;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import com.adobe.internal.util.BitwiseExpression;
import com.adobe.internal.util.BitwiseOperandEvaluator;
import com.adobe.internal.util.InvalidOperandException;
import com.adobe.internal.util.MalformedExpressionException;
import java.util.HashMap;
import java.util.Map;

public class PermissionProviderUR
implements PermissionProvider,
BitwiseOperandEvaluator {
    static final String OID_FORMFILLIN_FULLSAVE = "OID.Form_FillIn";
    static final String OID_FORM_IMPORT_EXPORT = "OID.Form_Import_Export";
    static final String OID_FORM_ADD_DELETE = "OID.Form_Add_Delete";
    static final String OID_SUBMIT_STANDALONE = "OID.Submit_Standalone";
    static final String OID_SPAWN_TEMPLATE = "OID.Spwan_Template";
    static final String OID_SIGNING = "OID.Signing";
    static final String OID_ANNOTMODIFY = "OID.Annot_Modify";
    static final String OID_ANNOT_IMPORT_EXPORT = "OID.Annot_Import_Export";
    static final String OID_BARCODE_PLAINTEXT = "OID.Barcode_PlainText";
    static final String OID_ANNOTONLINE = "OID.Annot_Online";
    static final String OID_FORMONLINE = "OID.Form_Online";
    static final String OID_EFMODIFY = "OID.EF_MODIFY";
    static final String DENY = "Deny";
    private static final Map<ObjectOperations, String> m_PermissionData = PermissionProviderUR.initData();
    private PDFDocument m_PDFDoc;

    public PermissionProviderUR(PDFDocument doc) {
        this.m_PDFDoc = doc;
    }

    static Map<ObjectOperations, String> initData() {
        HashMap<ObjectOperations, String> permissionData = new HashMap<ObjectOperations, String>();
        permissionData.put(ObjectOperations.DOC_MODIFY, DENY);
        permissionData.put(ObjectOperations.DOC_SECURE, DENY);
        permissionData.put(ObjectOperations.DOC_IMPORT, DENY);
        permissionData.put(ObjectOperations.PAGE_CREATE, DENY);
        permissionData.put(ObjectOperations.PAGE_COPY, DENY);
        permissionData.put(ObjectOperations.PAGE_DELETE, DENY);
        permissionData.put(ObjectOperations.PAGE_MODIFY, DENY);
        permissionData.put(ObjectOperations.PAGE_ROTATE, DENY);
        permissionData.put(ObjectOperations.PAGE_CROP, DENY);
        permissionData.put(ObjectOperations.PAGE_INSERT, DENY);
        permissionData.put(ObjectOperations.PAGE_REPLACE, DENY);
        permissionData.put(ObjectOperations.PAGE_REORDER, DENY);
        permissionData.put(ObjectOperations.LINK_CREATE, DENY);
        permissionData.put(ObjectOperations.LINK_DELETE, DENY);
        permissionData.put(ObjectOperations.LINK_MODIFY, DENY);
        permissionData.put(ObjectOperations.LINK_IMPORT, DENY);
        permissionData.put(ObjectOperations.BOOKMARK_CREATE, DENY);
        permissionData.put(ObjectOperations.BOOKMARK_DELETE, DENY);
        permissionData.put(ObjectOperations.BOOKMARK_MODIFY, DENY);
        permissionData.put(ObjectOperations.THUMBNAIL_CREATE, DENY);
        permissionData.put(ObjectOperations.THUMBNAIL_DELETE, DENY);
        permissionData.put(ObjectOperations.ANNOT_CREATE, "URAnnots.Create");
        permissionData.put(ObjectOperations.ANNOT_DELETE, "URAnnots.Delete");
        permissionData.put(ObjectOperations.ANNOT_MODIFY, "URAnnots.Modify");
        permissionData.put(ObjectOperations.ANNOT_SUMMARIZE, "URAnnots.Export");
        permissionData.put(ObjectOperations.ANNOT_IMPORT, "URAnnots.Import");
        permissionData.put(ObjectOperations.ANNOT_EXPORT, "URAnnots.Export");
        permissionData.put(ObjectOperations.ANNOT_ONLINE, "URAnnots.Online");
        permissionData.put(ObjectOperations.ANNOT_SUMMARY_VIEW, DENY);
        permissionData.put(ObjectOperations.FORM_CREATE, "URForm.Add");
        permissionData.put(ObjectOperations.FORM_DELETE, "URForm.Delete");
        permissionData.put(ObjectOperations.FORM_MODIFY, DENY);
        permissionData.put(ObjectOperations.FORM_FILLIN, "URForm.FillIn");
        permissionData.put(ObjectOperations.FORM_IMPORT, "URForm.Import");
        permissionData.put(ObjectOperations.FORM_EXPORT, "URForm.Export");
        permissionData.put(ObjectOperations.FORM_SUBMIT_STANDALONE, "URForm.SubmitStandalone");
        permissionData.put(ObjectOperations.FORM_SPAWN_TEMPLATE, "URForm.SpawnTemplate");
        permissionData.put(ObjectOperations.FORM_ONLINE, "URForm.Online");
        permissionData.put(ObjectOperations.FORM_BARCODE_PLAINTEXT, "URForm.BarcodePlaintext");
        permissionData.put(ObjectOperations.SIGNATURE_CREATE, "URForm.Add");
        permissionData.put(ObjectOperations.SIGNATURE_DELETE, "URForm.Delete");
        permissionData.put(ObjectOperations.SIGNATURE_MODIFY, "URForm.Add");
        permissionData.put(ObjectOperations.SIGNATURE_FILLIN, "URSignature.Modify");
        permissionData.put(ObjectOperations.EF_CREATE, "UREmbeddedFiles.Create");
        permissionData.put(ObjectOperations.EF_DELETE, "UREmbeddedFiles.Delete");
        permissionData.put(ObjectOperations.EF_MODIFY, "UREmbeddedFiles.Modify");
        permissionData.put(ObjectOperations.EF_IMPORT, "UREmbeddedFiles.Import");
        return permissionData;
    }

    @Override
    public boolean isPermitted(ObjectOperations objOpr) throws PDFUnableToCompleteOperationException {
        boolean isPermittedEncryption = true;
        boolean isPermittedDocMDP = true;
        try {
            PermissionProvider permProviderSec = PermissionsManager.newInstance(this.m_PDFDoc).getPermissionProvider("Security");
            PermissionProvider permProviderDocMDP = PermissionsManager.newInstance(this.m_PDFDoc).getPermissionProvider("DocMDP");
            if (permProviderSec != null) {
                isPermittedEncryption = permProviderSec.isPermitted(objOpr);
            }
            if (permProviderDocMDP != null) {
                isPermittedDocMDP = permProviderDocMDP.isPermitted(objOpr);
            }
        }
        catch (PDFException e) {
            throw new PDFUnableToCompleteOperationException("Unable to complete permissions query on " + objOpr.toString(), e);
        }
        if (!isPermittedEncryption | !isPermittedDocMDP) {
            return false;
        }
        String permValue = m_PermissionData.get(objOpr);
        if (permValue == null) {
            return true;
        }
        if (permValue.equals(DENY)) {
            return false;
        }
        BitwiseExpression expObj = new BitwiseExpression(this);
        boolean bRet = true;
        try {
            bRet = expObj.evaluateExpression(permValue);
        }
        catch (MalformedExpressionException e) {
            throw new RuntimeException("Gibson Internal error", e);
        }
        catch (InvalidOperandException e) {
            throw new PDFUnableToCompleteOperationException("Unable to complete permissions query on " + objOpr.toString(), e);
        }
        return bRet;
    }

    @Override
    public boolean evaluate(String operandVar) throws InvalidOperandException {
        boolean bRet = false;
        try {
            PDFTransformParametersUR ub1Rights;
            boolean bRetVal;
            if (PDFSignatureUtils.hasUsageRights(this.m_PDFDoc, PDFSignature.k_UB1.asString(true)) && (bRetVal = this.checkUsageRight(ub1Rights = PDFSignatureUtils.getDocumentUsageRights(this.m_PDFDoc, PDFSignature.k_UB1.asString(true)), operandVar))) {
                return true;
            }
            if (PDFSignatureUtils.hasPermissionsSignature(this.m_PDFDoc)) {
                PDFPermissions perms = this.m_PDFDoc.requireCatalog().getPermissions();
                PDFSignature URSig = perms.getUR3();
                if (URSig == null) {
                    URSig = perms.getUR();
                }
                if (URSig == null) {
                    return bRet;
                }
                PDFSignatureReferenceList sigRefs = URSig.getSignatureReferences();
                if (sigRefs != null) {
                    for (PDFSignatureReference sigRef : sigRefs) {
                        PDFTransformParametersUR transformParams;
                        boolean bRetVal2;
                        if (sigRef.getTransformMethodName() != PDFSignature.k_UR && sigRef.getTransformMethodName() != PDFSignature.k_UR3 || !(bRetVal2 = this.checkUsageRight(transformParams = (PDFTransformParametersUR)sigRef.getPDFTransformParameters(), operandVar))) continue;
                        return true;
                    }
                }
            }
        }
        catch (PDFException e) {
            throw new InvalidOperandException("Unable to query permissions from UR Permission provider" + e);
        }
        return bRet;
    }

    private boolean checkUsageRight(PDFTransformParametersUR transformParametersUR, String usageRightsName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int i;
        Enum ur;
        Enum[] rights;
        String object = usageRightsName.substring(0, usageRightsName.indexOf(46));
        ASName operation = ASName.create(usageRightsName.substring(usageRightsName.indexOf(46) + 1));
        if ("URDocument".equals(object)) {
            rights = transformParametersUR.getDocumentUsageRights();
            ur = PDFURDocument.getInstance(operation);
            if (rights == null) {
                return false;
            }
            for (i = 0; i < rights.length; ++i) {
                if (ur != rights[i]) continue;
                return true;
            }
        }
        if ("URAnnots".equals(object)) {
            rights = transformParametersUR.getAnnotationUsageRights();
            ur = PDFURAnnots.getInstance(operation);
            if (rights == null) {
                return false;
            }
            for (i = 0; i < rights.length; ++i) {
                if (ur != rights[i]) continue;
                return true;
            }
        }
        if ("URForm".equals(object)) {
            rights = transformParametersUR.getFormUsageRights();
            ur = PDFURForm.getInstance(operation);
            if (rights == null) {
                return false;
            }
            for (i = 0; i < rights.length; ++i) {
                if (ur != rights[i]) continue;
                return true;
            }
        }
        if ("URSignature".equals(object)) {
            rights = transformParametersUR.getSignatureUsageRights();
            ur = PDFURSignature.getInstance(operation);
            if (rights == null) {
                return false;
            }
            for (i = 0; i < rights.length; ++i) {
                if (ur != rights[i]) continue;
                return true;
            }
        }
        if ("UREmbeddedFiles".equals(object)) {
            rights = transformParametersUR.getEFUsageRights();
            ur = PDFUREmbeddedFiles.getInstance(operation);
            if (rights == null) {
                return false;
            }
            for (i = 0; i < rights.length; ++i) {
                if (ur != rights[i]) continue;
                return true;
            }
        }
        return false;
    }
}

