/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFGroupAttributes;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsPage;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFNavNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntent;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntentsList;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;
import com.adobe.internal.pdftoolkit.pdf.utils.ContentUtil;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2XMPErrorCollector;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractPageErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorAFEntryInPageNotValid;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorAdditionalActionsNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorArtBoxHasHeightGreaterThan14400;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorArtBoxHasHeightLessThan3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorArtBoxHasWidthGreaterThan14400;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorArtBoxHasWidthLessThan3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorBleedBoxHasHeightGreaterThan14400;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorBleedBoxHasHeightLessThan3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorBleedBoxHasWidthGreaterThan14400;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorBleedBoxHasWidthLessThan3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorCSKeyNotPresentInGroupKeyWithTransparency;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorCropBoxHasHeightGreaterThan14400;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorCropBoxHasHeightLessThan3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorCropBoxHasWidthGreaterThan14400;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorCropBoxHasWidthLessThan3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorGroupKeyNotPresentWithTransparency;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorMediaBoxHasHeightGreaterThan14400;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorMediaBoxHasHeightLessThan3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorMediaBoxHasWidthGreaterThan14400;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorMediaBoxHasWidthLessThan3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorPrestepsPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorTrimBoxHasHeightGreaterThan14400;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorTrimBoxHasHeightLessThan3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorTrimBoxHasWidthGreaterThan14400;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorTrimBoxHasWidthLessThan3;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.AnnotationProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ColorSpaceProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ContentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.MetadataProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TransparencyState;
import java.util.Iterator;

class PageProcessor {
    private static final int MIN_PAGE_BOUNDARY_ALLOWED = 3;
    private static final int MAX_PAGE_BOUNDARY_ALLOWED = 14400;

    PageProcessor() {
    }

    static boolean process(PDFPageTreeNode pages, DocumentProcessor docProcessor, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pages == null) {
            return true;
        }
        if (!validationHandler.beginPageTreeScan()) {
            return false;
        }
        int index = 1;
        Iterator<PDFPage> iter = pages.iterator();
        while (iter.hasNext()) {
            PDFPage page = iter.next();
            if (PageProcessor.process(page, index++, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) continue;
            return false;
        }
        return validationHandler.endPageTreeScan();
    }

    static boolean process(PDFPage page, int index, DocumentProcessor docProcessor, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFA2ErrorSet<PDFA2AbstractPageErrorCode> errorCodes;
        block29: {
            if (page == null) {
                return true;
            }
            if (!validationHandler.beginPageScan(page, index)) {
                return false;
            }
            errorCodes = new PDFA2ErrorSet<PDFA2AbstractPageErrorCode>();
            if (conformance == PDFA2ConformanceLevel.Level_3b && !docProcessor.checkAndAddToAssociatedFileSet(page.getAssociatedFiles())) {
                errorCodes.addErrorCode(new PDFA2PageErrorAFEntryInPageNotValid(page.getCosObject().getObjNum(), page.getCosObject().getObjGen()));
            }
            TransparencyState transparencyState = new TransparencyState();
            try {
                PDFNavNode navNode = page.getPresSteps();
                if (navNode != null) {
                    if (conversionHandler != null && conversionOptions.isRemovePresStepsFromPage()) {
                        page.removeValue(ASName.k_PresSteps);
                        if (!conversionHandler.presStepsRemoved(page)) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(new PDFA2PageErrorPrestepsPresent(navNode.getCosObject().getObjNum(), navNode.getCosObject().getObjGen()));
                    }
                }
                PageProcessor.validatePageBoundaries(page, errorCodes);
                PDFAdditionalActionsPage additionalActions = page.getAdditionalActions();
                if (additionalActions != null) {
                    if (conversionHandler != null && conversionOptions.getRemoveIllegalAdditionalActions()) {
                        page.removeValue(ASName.k_AA);
                        conversionHandler.illegalAdditionalActionsRemoved(additionalActions);
                    } else {
                        errorCodes.addErrorCode(new PDFA2PageErrorAdditionalActionsNotAllowed(additionalActions.getCosObject().getObjNum(), additionalActions.getCosObject().getObjGen()));
                    }
                }
            }
            catch (PDFInvalidDocumentException e) {
                errorCodes.addErrorCode(new PDFA2PageErrorPDFGeneralFailure(page.getCosObject().getObjNum(), page.getCosObject().getObjGen()));
            }
            try {
                Content content = ContentUtil.getContent(conversionHandler != null, page);
                if (content != null) {
                    PDFResources resources;
                    if (!ContentProcessor.process(content, page, null, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, null, transparencyState)) {
                        return false;
                    }
                    if (conversionHandler != null && content.resourcesDetached() && !(resources = content.getResources()).isEmpty()) {
                        page.setResources(content.getResources());
                    }
                }
                if (page.hasAnnotations() && !AnnotationProcessor.process(page, docProcessor, page.getResources(), conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, transparencyState)) {
                    return false;
                }
                if (transparencyState.isDetected()) {
                    PDFOutputIntent outputIntent;
                    if (!ColorSpaceProcessor.hasPDFAOutputIntent(page.getPDFDocument())) {
                        PDFGroupAttributes groupAttr = page.getGroup();
                        if (groupAttr == null) {
                            errorCodes.addErrorCode(new PDFA2PageErrorGroupKeyNotPresentWithTransparency(page.getCosObject().getObjNum(), page.getCosObject().getObjGen()));
                        } else if (groupAttr.getDictionaryCosObjectValue(ASName.k_CS) == null) {
                            errorCodes.addErrorCode(new PDFA2PageErrorCSKeyNotPresentInGroupKeyWithTransparency(groupAttr.getCosObject().getObjNum(), groupAttr.getCosObject().getObjGen()));
                        }
                    }
                    if (conversionHandler != null && errorCodes.errorCodeSet(PDFA2PageErrorGroupKeyNotPresentWithTransparency.class) && (outputIntent = conversionOptions.getPDFAOutputIntent()) != null) {
                        PDFOutputIntentsList outputIntentsList = PDFOutputIntentsList.newInstance(docProcessor.document);
                        outputIntentsList.add(outputIntent);
                        docProcessor.document.requireCatalog().setOutputIntents(outputIntentsList);
                        conversionHandler.pdfaOutputIntentSet(outputIntent);
                        boolean continueProcessing = docProcessor.processOutputIntent(outputIntent, validationHandler, validationOptions, conversionHandler, conversionOptions, true);
                        if (continueProcessing) {
                            errorCodes.unSetErrorCode(PDFA2PageErrorGroupKeyNotPresentWithTransparency.class);
                        }
                        return continueProcessing;
                    }
                }
            }
            catch (PDFInvalidDocumentException e) {
                errorCodes.addErrorCode(new PDFA2PageErrorPDFGeneralFailure(0, 0));
                if (!validationHandler.pageError(errorCodes)) {
                    return false;
                }
            }
            catch (PDFRuntimeException e) {
                errorCodes.addErrorCode(new PDFA2PageErrorPDFGeneralFailure(0, 0));
                if (validationHandler.pageError(errorCodes)) break block29;
                return false;
            }
        }
        if (!PageProcessor.processPageXMP(docProcessor, page, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
            return false;
        }
        if (errorCodes.hasErrors() && !validationHandler.pageError(errorCodes)) {
            return false;
        }
        return validationHandler.endPageScan();
    }

    static boolean processPageXMP(DocumentProcessor docProcessor, PDFPage page, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFMetadata metadata = page.getMetadata();
        if (metadata == null || metadata.getType() != ASName.k_Metadata || metadata.getSubtype() != ASName.k_XML) {
            return true;
        }
        PDFA2XMPErrorCollector errorCodes = new PDFA2XMPErrorCollector();
        if (!MetadataProcessor.processXMP(docProcessor, docProcessor.document, page, conformance, conversionHandler, conversionOptions, validationHandler, validationOptions, errorCodes)) {
            return false;
        }
        return !errorCodes.hasErrors() || validationHandler.pageXMPError(errorCodes);
    }

    private static void validatePageBoundaries(PDFPage page, PDFA2ErrorSet<PDFA2AbstractPageErrorCode> errorCodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle pageBoundary = page.getArtBox();
        ASRectangle rectangle = pageBoundary != null ? pageBoundary.getRectangle() : null;
        int objectNumber = page.getCosObject().getObjNum();
        int genNumber = page.getCosObject().getObjGen();
        if (rectangle != null) {
            if (rectangle.width() < 3.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorArtBoxHasWidthLessThan3(rectangle.width(), objectNumber, genNumber));
            }
            if (rectangle.width() > 14400.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorArtBoxHasWidthGreaterThan14400(rectangle.width(), objectNumber, genNumber));
            }
            if (rectangle.height() < 3.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorArtBoxHasHeightLessThan3(rectangle.height(), objectNumber, genNumber));
            }
            if (rectangle.height() > 14400.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorArtBoxHasHeightGreaterThan14400(rectangle.height(), objectNumber, genNumber));
            }
        }
        ASRectangle aSRectangle = rectangle = (pageBoundary = page.getBleedBox()) != null ? pageBoundary.getRectangle() : null;
        if (rectangle != null) {
            if (rectangle.width() < 3.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorBleedBoxHasWidthLessThan3(rectangle.width(), objectNumber, genNumber));
            }
            if (rectangle.width() > 14400.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorBleedBoxHasWidthGreaterThan14400(rectangle.width(), objectNumber, genNumber));
            }
            if (rectangle.height() < 3.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorBleedBoxHasHeightLessThan3(rectangle.height(), objectNumber, genNumber));
            }
            if (rectangle.height() > 14400.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorBleedBoxHasHeightGreaterThan14400(rectangle.height(), objectNumber, genNumber));
            }
        }
        ASRectangle aSRectangle2 = rectangle = (pageBoundary = page.getCropBox()) != null ? pageBoundary.getRectangle() : null;
        if (rectangle != null) {
            if (rectangle.width() < 3.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorCropBoxHasWidthLessThan3(rectangle.width(), objectNumber, genNumber));
            }
            if (rectangle.width() > 14400.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorCropBoxHasWidthGreaterThan14400(rectangle.width(), objectNumber, genNumber));
            }
            if (rectangle.height() < 3.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorCropBoxHasHeightLessThan3(rectangle.height(), objectNumber, genNumber));
            }
            if (rectangle.height() > 14400.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorCropBoxHasHeightGreaterThan14400(rectangle.height(), objectNumber, genNumber));
            }
        }
        ASRectangle aSRectangle3 = rectangle = (pageBoundary = page.getMediaBox()) != null ? pageBoundary.getRectangle() : null;
        if (rectangle != null) {
            if (rectangle.width() < 3.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorMediaBoxHasWidthLessThan3(rectangle.width(), objectNumber, genNumber));
            }
            if (rectangle.width() > 14400.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorMediaBoxHasWidthGreaterThan14400(rectangle.width(), objectNumber, genNumber));
            }
            if (rectangle.height() < 3.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorMediaBoxHasHeightLessThan3(rectangle.height(), objectNumber, genNumber));
            }
            if (rectangle.height() > 14400.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorMediaBoxHasHeightGreaterThan14400(rectangle.height(), objectNumber, genNumber));
            }
        }
        ASRectangle aSRectangle4 = rectangle = (pageBoundary = page.getTrimBox()) != null ? pageBoundary.getRectangle() : null;
        if (rectangle != null) {
            if (rectangle.width() < 3.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorTrimBoxHasWidthLessThan3(rectangle.width(), objectNumber, genNumber));
            }
            if (rectangle.width() > 14400.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorTrimBoxHasWidthGreaterThan14400(rectangle.width(), objectNumber, genNumber));
            }
            if (rectangle.height() < 3.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorTrimBoxHasHeightLessThan3(rectangle.height(), objectNumber, genNumber));
            }
            if (rectangle.height() > 14400.0) {
                errorCodes.addErrorCode(new PDFA2PageErrorTrimBoxHasHeightGreaterThan14400(rectangle.height(), objectNumber, genNumber));
            }
        }
    }
}

