/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2;

import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2XMPSchema;
import com.adobe.internal.pdftoolkit.xml.XMLNamespaceUsage;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class PDFA2InvalidNamespaceUsage
extends XMLNamespaceUsage {
    private DefinitionLocation definitionLocation = DefinitionLocation.NONE;
    private boolean prefixError = false;
    private Set<String> originalPrefixes;

    public PDFA2InvalidNamespaceUsage(XMLNamespaceUsage otherNamespaceUsage) {
        super(otherNamespaceUsage);
        super.removeAttributes();
        this.originalPrefixes = new HashSet<String>(otherNamespaceUsage.getPrefixes());
    }

    PDFA2InvalidNamespaceUsage(PDFA2InvalidNamespaceUsage otherInvalidUsage) {
        this((XMLNamespaceUsage)otherInvalidUsage);
        this.originalPrefixes = new HashSet<String>(otherInvalidUsage.originalPrefixes);
    }

    void setNamespaceDefinitionLocation(DefinitionLocation definitionLocation) {
        this.definitionLocation = definitionLocation;
    }

    public void addNamespaceDefinitionLocation(DefinitionLocation definitionLocation) {
        this.definitionLocation = this.definitionLocation.addLocation(definitionLocation);
    }

    public DefinitionLocation getNamespaceDefinitionLocation() {
        return this.definitionLocation;
    }

    public boolean removeSchema(PDFA2XMPSchema schema) {
        String currentNamespace;
        Set<PDFA2XMPSchema.PDFA2XMPType> typeSet;
        boolean namespaceChanged = false;
        if (XMLUtils.matchNamespaces(this.getURI(), schema.getURI())) {
            String schemaPrefix = schema.getPrefix();
            super.removePrefix(schemaPrefix);
            Map<String, PDFA2XMPSchema.PDFA2XMPProperty> properties = schema.getProperties();
            if (properties != null && !properties.isEmpty()) {
                namespaceChanged |= super.removeElements(properties.keySet());
            }
            if (schema.getPrefixIsRequired() && schemaPrefix != null) {
                if (this.originalPrefixes.size() != 1) {
                    this.prefixError = true;
                } else if (!this.originalPrefixes.contains(schemaPrefix)) {
                    this.prefixError = true;
                }
            }
        }
        if ((typeSet = schema.getTypeByURI(this.getURI())) == null && !this.getURI().isEmpty() && (currentNamespace = this.getURI()).endsWith("#")) {
            currentNamespace = currentNamespace.substring(0, currentNamespace.length() - 1) + "/";
            typeSet = schema.getTypeByURI(currentNamespace);
        }
        if (typeSet != null && !typeSet.isEmpty()) {
            for (PDFA2XMPSchema.PDFA2XMPType type : typeSet) {
                boolean typeChanged = false;
                String typePrefix = type.getPrefix();
                super.removePrefix(typePrefix);
                typeChanged |= super.removeElement(type.getType());
                Map<String, PDFA2XMPSchema.PDFA2XMPField> fieldMap = type.getFields();
                if (fieldMap != null && !fieldMap.isEmpty()) {
                    for (PDFA2XMPSchema.PDFA2XMPField field : fieldMap.values()) {
                        typeChanged |= super.removeElement(field.getName());
                    }
                }
                if (typeChanged) {
                    namespaceChanged = true;
                }
                if (!type.getPrefixIsRequired() || typePrefix == null) continue;
                if (this.originalPrefixes.size() != 1) {
                    this.prefixError = true;
                    continue;
                }
                if (this.originalPrefixes.contains(typePrefix)) continue;
                this.prefixError = true;
            }
        }
        return namespaceChanged;
    }

    public boolean prefixError() {
        return this.prefixError;
    }

    public boolean areErrorsCleared() {
        if (!super.isEmpty(true)) {
            return false;
        }
        return !this.prefixError();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("\t");
        builder.append("definition location = ");
        builder.append((Object)this.definitionLocation);
        builder.append("\n\t");
        builder.append("original prefixes = ");
        builder.append(this.originalPrefixes);
        return builder.toString();
    }

    public void removeQualifiers(Map<String, Set<String>> namespaceQualifierSet) {
        String nsURI = this.getURI();
        if (namespaceQualifierSet.containsKey(nsURI)) {
            super.removeElements(namespaceQualifierSet.get(nsURI));
        }
    }

    public static enum DefinitionLocation {
        NONE("no definition"),
        PDFA2_SPECIFICATON("defined in the PDF/A specification"),
        PDFA2_SCHEMA("defined in a PDF/A schema in the XMP"),
        PDFA2_SPECIFICATION_AND_SCHEMA("defined in both the PDF/A specification and an embedded schema in the XMP");

        private final String description;

        private DefinitionLocation(String description) {
            this.description = description;
        }

        DefinitionLocation addLocation(DefinitionLocation other) {
            if (other == NONE) {
                return this;
            }
            if (this == NONE) {
                return other;
            }
            if (this == other) {
                return this;
            }
            return PDFA2_SPECIFICATION_AND_SCHEMA;
        }

        public String toString() {
            return "namespace definition = " + this.description;
        }
    }
}

