/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.xmp;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetMetadata;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAXMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAMetadataErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPBasicTypeValidator;
import com.adobe.internal.pdftoolkit.services.xmp.XMPMetaFactoryMonitor;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPSchemaRegistry;
import com.adobe.internal.xmp.options.PropertyOptions;
import com.adobe.internal.xmp.properties.XMPAliasInfo;
import com.adobe.internal.xmp.properties.XMPProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMPSchemaUsageValidator
extends XMLFilterImpl {
    private STATE currentState;
    private MetadataUsageTreeNode metadataUsageTreeNode;
    private Map<String, PDFAXMPSchema> referenceSchemas;
    private XMPMeta xmpMeta;
    private HashMap<XMLElement, PropertyOptions> invalidUsage;
    private XMPSchemaRegistry schemaRegistry;
    public static Map<String, Set<String>> qualifierMap;
    private static final int optionFilter = 7936;
    private Map<String, String> prefixNSMapping = new HashMap<String, String>();
    private boolean onlyFixableIssuesFound = true;
    private PDFAErrorSet errorCodes;
    private static final String RDF_DESCRIPTION = "rdf:Description";
    private static final String RDF_ABOUT = "rdf:about";
    private static final String XML_LANG = "xml:lang";
    public static final String RDF_ALT = "rdf:alt";
    public static final String RDF_BAG = "rdf:bag";
    public static final String RDF_SEQ = "rdf:seq";
    public static final String RDF_LI = "rdf:li";
    private StringBuilder fieldValueCollector = null;
    private Attributes rdfAtts;
    private boolean parsingExtensionSchemaDecl = false;
    private static final String PDFAEXTENSION_URI = "http://www.aiim.org/pdfa/ns/extension/";
    private int xmlDepth = -1;
    private Stack<Integer> elementsToSkipDepths = new Stack();

    public static Map<String, Set<String>> getQualifierMap() {
        return qualifierMap;
    }

    public static void setQualifierMap(Map<String, Set<String>> qualifierMap) {
        XMPSchemaUsageValidator.qualifierMap = qualifierMap;
    }

    public XMPSchemaUsageValidator(Map<String, PDFAXMPSchema> referenceExtensionSchemas, XMPMeta xmpMeta, HashMap<XMLElement, PropertyOptions> invalidUsage, PDFDocument document) {
        this.referenceSchemas = referenceExtensionSchemas;
        this.xmpMeta = xmpMeta;
        this.invalidUsage = invalidUsage;
        this.errorCodes = new PDFAErrorSetMetadata();
        this.schemaRegistry = XMPMetaFactoryMonitor.getSchemaRegistry(document);
    }

    public PDFAErrorSet getErrorCodes() {
        return this.errorCodes;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fieldValueCollector != null) {
            this.fieldValueCollector.append(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        --this.xmlDepth;
        if (uri.equals(PDFAEXTENSION_URI)) {
            this.parsingExtensionSchemaDecl = false;
            super.endElement(uri, localName, name);
            return;
        }
        if (this.parsingExtensionSchemaDecl) {
            super.endElement(uri, localName, name);
            return;
        }
        if (!this.elementsToSkipDepths.isEmpty() && this.elementsToSkipDepths.peek() == this.xmlDepth + 1) {
            this.elementsToSkipDepths.pop();
            super.endElement(uri, localName, name);
            return;
        }
        if (name.equals(RDF_DESCRIPTION)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                if (this.metadataUsageTreeNode.getNodes() == null && this.rdfAtts != null) {
                    for (int i = 0; i < this.rdfAtts.getLength(); ++i) {
                        String nsURI = this.rdfAtts.getURI(i);
                        String prefix = this.prefixNSMapping.get(nsURI);
                        if (prefix == null || prefix.equals("rdf")) continue;
                        MetadataUsageTreeNode node = this.metadataUsageTreeNode.startElement(nsURI, this.rdfAtts.getLocalName(i), prefix);
                        node.setValue(this.rdfAtts.getValue(i));
                        break;
                    }
                    this.rdfAtts = null;
                }
                MetadataUsageTreeNode node = this.metadataUsageTreeNode;
                this.metadataUsageTreeNode = this.metadataUsageTreeNode.endElement();
                if (this.metadataUsageTreeNode == null) {
                    this.currentState = STATE.XML_ELEMENT_PROCESSING;
                    if (!this.validatePropertyTree(node)) {
                        this.errorCodes.addErrorCode(PDFAMetadataErrorCode.schemaUsageNotValid);
                    }
                } else {
                    this.currentState = STATE.PROPERTY_PROCESSING;
                }
            }
        } else if (this.isRDFArray(name)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                this.metadataUsageTreeNode.endArray();
            }
        } else if (name.equals(RDF_LI)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                if (this.metadataUsageTreeNode.getNodes() == null && this.fieldValueCollector != null) {
                    this.metadataUsageTreeNode.setValue(this.fieldValueCollector.toString().trim());
                    this.fieldValueCollector = null;
                }
                this.metadataUsageTreeNode = this.metadataUsageTreeNode.endLI();
            }
        } else if (this.currentState == STATE.PROPERTY_PROCESSING) {
            if (this.fieldValueCollector != null) {
                this.metadataUsageTreeNode.setValue(this.fieldValueCollector.toString().trim());
                this.fieldValueCollector = null;
            }
            this.metadataUsageTreeNode = this.metadataUsageTreeNode.endElement();
        }
        super.endElement(uri, localName, name);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        ++this.xmlDepth;
        if (this.parsingExtensionSchemaDecl) {
            super.startElement(uri, localName, name, atts);
            return;
        }
        if (uri.equals(PDFAEXTENSION_URI)) {
            this.parsingExtensionSchemaDecl = true;
            super.startElement(uri, localName, name, atts);
            return;
        }
        if (name.equals(RDF_DESCRIPTION)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                this.elementsToSkipDepths.push(this.xmlDepth);
            } else if (atts.getIndex(RDF_ABOUT) != -1) {
                this.rdfAtts = atts;
                this.currentState = STATE.PROPERTY_PROCESSING;
                this.metadataUsageTreeNode = new MetadataUsageTreeNode(null);
                this.metadataUsageTreeNode.setName(name);
            }
        } else if (this.isRDFArray(name)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                this.metadataUsageTreeNode.startArray(name);
            }
        } else if (name.equals(RDF_LI)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                if (this.fieldValueCollector == null) {
                    this.fieldValueCollector = new StringBuilder();
                }
                this.metadataUsageTreeNode = this.metadataUsageTreeNode.startLI();
                for (int i = 0; i < atts.getLength(); ++i) {
                    int index;
                    int n = index = atts.getQName(i) != null ? atts.getQName(i).indexOf(58) : 0;
                    if (atts.getLocalName(i).equalsIgnoreCase("parseType") && atts.getQName(i).indexOf("rdf:parseType") != -1 || atts.getIndex(XML_LANG) != -1) continue;
                    MetadataUsageTreeNode childnode = this.metadataUsageTreeNode.startElement(atts.getURI(i), atts.getLocalName(i), atts.getQName(i).substring(0, index));
                    if (atts.getValue(i) == null) continue;
                    childnode.setValue(atts.getValue(i));
                }
                int index = atts.getIndex(XML_LANG);
                if (index != -1) {
                    this.metadataUsageTreeNode.setLanguageQualifier(atts.getValue(index));
                }
            }
        } else if (this.currentState == STATE.PROPERTY_PROCESSING) {
            this.metadataUsageTreeNode = this.metadataUsageTreeNode.startElement(uri, localName, this.prefixNSMapping.get(uri));
            this.fieldValueCollector = new StringBuilder();
        }
        super.startElement(uri, localName, name, atts);
    }

    private boolean isRDFArray(String name) {
        return name != null && (name.equalsIgnoreCase(RDF_ALT) || name.equalsIgnoreCase(RDF_SEQ) || name.equalsIgnoreCase(RDF_BAG));
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixNSMapping.put(uri, prefix);
        super.startPrefixMapping(prefix, uri);
    }

    private boolean validatePropertyTree(MetadataUsageTreeNode propertyTree) {
        if (propertyTree == null) {
            return false;
        }
        if (propertyTree.getParentNode() == null) {
            if (!propertyTree.getName().equals(RDF_DESCRIPTION)) {
                this.onlyFixableIssuesFound = false;
                return false;
            }
            if (!propertyTree.isNodeArray()) {
                if (propertyTree.getNodes() == null) {
                    return true;
                }
                boolean isTreeValid = true;
                for (MetadataUsageTreeNode node : propertyTree.getNodes()) {
                    String uri = node.getNameSpaceURI();
                    PDFAXMPSchema xmpSchema = this.referenceSchemas.get(uri);
                    if (xmpSchema == null) {
                        this.addToInvalidUsageMap(uri, node.getName());
                        isTreeValid = false;
                        continue;
                    }
                    String name = node.getName();
                    PDFAXMPSchema.PDFAXMPProperty prop = xmpSchema.getProperty(name);
                    if (prop == null) {
                        this.addToInvalidUsageMap(uri, node.getName());
                        isTreeValid = false;
                        continue;
                    }
                    String valueType = prop.getType();
                    String arrayType = null;
                    if (valueType.toLowerCase().startsWith("alt ") || valueType.toLowerCase().startsWith("bag ") || valueType.toLowerCase().startsWith("seq ")) {
                        arrayType = valueType.substring(0, 3);
                    }
                    if (arrayType != null && !arrayType.equalsIgnoreCase(node.getArrayType().toString())) {
                        this.addToInvalidUsageMap(uri, node.getName());
                        isTreeValid = false;
                        continue;
                    }
                    if (XMPBasicTypeValidator.isPropertyUsageValid(valueType, node, this.referenceSchemas, false, prop, xmpSchema)) continue;
                    this.addToInvalidUsageMap(uri, node.getName());
                    isTreeValid = false;
                }
                return isTreeValid;
            }
            this.onlyFixableIssuesFound = false;
            return false;
        }
        this.onlyFixableIssuesFound = false;
        return false;
    }

    private void addToInvalidUsageMap(String uri, String localName) {
        block4: {
            XMLElement element = new XMLElement(uri, localName);
            XMPProperty prop = null;
            try {
                prop = this.xmpMeta.getProperty(element.getNamespace(), element.getElementName());
                if (prop != null) {
                    int type = prop.getOptions().getOptions() & 0x1F00;
                    this.invalidUsage.put(element, new PropertyOptions(type));
                }
            }
            catch (XMPException e) {
                XMPAliasInfo alias = this.schemaRegistry.resolveAlias(uri, localName);
                if (alias != null) {
                    this.addToInvalidUsageMap(alias.getNamespace(), alias.getPropName());
                }
                if (e.getErrorCode() == 101) break block4;
                throw new PDFRuntimeException("Exception occured in XMP toolkit", e);
            }
        }
    }

    public boolean isOnlyFixableIssuesFound() {
        return this.onlyFixableIssuesFound;
    }

    private static enum STATE {
        XML_ELEMENT_PROCESSING,
        PROPERTY_PROCESSING;

    }
}

