/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCosFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.TrueTypeFontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.UnembeddedFontInfo;
import java.io.IOException;
import java.util.HashSet;

class Type1FontProcessor {
    Type1FontProcessor() {
    }

    static PDFAErrorSetFont embedType1Font(PDFFontSimple font, UnembeddedFontInfo ufInfo, PDFAConversionHandler conversionHandler, FontContext fontContext) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        boolean success;
        if (ufInfo == null) {
            return new PDFAErrorSetFont();
        }
        PDFAErrorSetFont errorCodes = ufInfo.getError();
        if (font == null) {
            return errorCodes;
        }
        if (font.getSubtype() == ASName.k_TrueType) {
            errorCodes.mergeErrorSet(TrueTypeFontProcessor.processTrueTypeFontErrors(font, conversionHandler));
        }
        if (!(success = FontProcessorUtils.embedType1Font(font, ufInfo))) {
            return errorCodes;
        }
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.fontNotEmbedded)) {
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.fontNotEmbedded);
            if (!conversionHandler.fontEmbedded(font)) {
                return null;
            }
        }
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed)) {
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed);
            if (!conversionHandler.openTypeFontReEmbedded(font)) {
                return null;
            }
        }
        FontProcessorUtils.embedCharSet(font, ufInfo);
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteCharSet)) {
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteCharSet);
            if (!conversionHandler.charSetUpdatedInType1Font(font)) {
                return null;
            }
        }
        FontProcessorUtils.embedWidthsArray(font, ufInfo, fontContext, null);
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedWidthsInfo) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteWidthsArray)) {
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedWidthsInfo);
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteWidthsArray);
            if (!conversionHandler.widthsMetricsUpdated(font)) {
                return null;
            }
        }
        return errorCodes;
    }

    static PDFAErrorSetFont processType1FontErrors(PDFFont font, PDFAConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontEngineException {
        PDFCosFontDescriptor desc;
        PDFFontDescriptor fDesc;
        PDFAErrorSetFont errorCodes = new PDFAErrorSetFont();
        if (font == null) {
            return errorCodes;
        }
        if (!font.getSubtype().equals(ASName.k_Type1)) {
            return errorCodes;
        }
        FontProcessor.setTypeErrorCodes(font.getCosDictionary(), ASName.k_Font, conversionHandler, errorCodes, PDFAFontErrorCode.typeIncorrectInFont, PDFAFontErrorCode.typeAbsentInFont);
        PDFFontSimple type1Font = (PDFFontSimple)font;
        if (PDFFontUtils.isSubsetFont(font) && (fDesc = type1Font.getFontDescriptor()) != null && (desc = fDesc.getPDFCosDescriptor()) != null) {
            Type1FontProcessor.validateFontFile(desc, errorCodes);
            FontProcessor.setTypeErrorCodes(desc.getCosDictionary(), ASName.k_FontDescriptor, conversionHandler, errorCodes, PDFAFontErrorCode.typeIncorrectInFontDescriptor, PDFAFontErrorCode.typeAbsentInFontDescriptor);
        }
        return errorCodes;
    }

    private static void validateFontFile(PDFCosFontDescriptor desc, PDFAErrorSetFont errorCodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontFile fontFile = desc.getFontFile();
        int QUESTION_MARK = 37;
        int EXCLAMETION_MARK = 33;
        if (fontFile != null) {
            long len1 = fontFile.getLength1();
            long len2 = fontFile.getLength2();
            long len3 = fontFile.getLength3();
            long len = 0L;
            try {
                InputByteStream stream = fontFile.getStream();
                int streamLen = 0;
                int streamData1 = stream.read();
                int streamData2 = stream.read();
                while (streamData1 != QUESTION_MARK || streamData2 != EXCLAMETION_MARK) {
                    streamData1 = streamData2;
                    streamData2 = stream.read();
                    ++streamLen;
                }
                len = fontFile.getStream().length();
                len -= (long)streamLen;
            }
            catch (IOException stream) {
                // empty catch block
            }
            long sumLen = len1 + len2 + len3;
            if (Math.abs(sumLen - len) > 2L) {
                errorCodes.addErrorCode(PDFAFontErrorCode.incorrectLengthEntriesInEmbeddedType1Font);
            }
        }
    }

    static void addReferencedCharsetErrors(HashSet<Integer> charCodes, PDFAErrorSetFont errorCodes, PDFFontSimple type1Font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        PDFFontDescriptor fDesc = type1Font.getFontDescriptor();
        ASString charSet = fDesc.getCharSet();
        if (charSet == null) {
            errorCodes.addErrorCode(PDFAFontErrorCode.missingOrIncompleteCharSet);
        } else {
            try {
                Font afeFont = type1Font.getAFEFont();
                if (afeFont == null) {
                    return;
                }
                PDFFontDescription fontDesc = afeFont.getPDFFontDescription();
                if (fontDesc == null) {
                    return;
                }
                HashSet<String> referencedGlyphNames = new HashSet<String>();
                for (Integer charCode : charCodes) {
                    referencedGlyphNames.add(type1Font.charCode2glyphName(charCode));
                }
                String charSetStr = charSet.asString();
                int numGlyphsInFont = fontDesc.getNumGlyphs();
                String[] charSetNames = charSetStr.split("/");
                for (int i = 0; i <= numGlyphsInFont - 1; ++i) {
                    String glyphName = fontDesc.getGlyphName(i);
                    if (!referencedGlyphNames.contains(glyphName) || ".notdef".equalsIgnoreCase(glyphName)) continue;
                    boolean found = false;
                    for (int j = 0; j < charSetNames.length; ++j) {
                        if (!charSetNames[j].equals(glyphName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    errorCodes.addErrorCode(PDFAFontErrorCode.missingOrIncompleteCharSet);
                    break;
                }
            }
            catch (FontEngineException e3) {
                errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
            }
        }
    }
}

