/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamTransformer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerProperties;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontGroupListener;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.CharcodeRewriter;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.ContentRewriteInfo;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.EmbeddedFontDetails;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.EmbeddedFontDetailsCollector;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.EmbeddedFontGroup;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.EmbeddedFontGrouper;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.FontReEmbedder;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.FontSuperSetCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class EmbeddedFontOptimizer
implements DocumentListener {
    private static Object KEY = EmbeddedFontOptimizer.class;
    static final boolean print_debug_trace = true;
    private PDFDocument pdfDocument;
    private PDFFontSet fontSet;
    private HashMap<CosDictionary, ContentRewriteInfo> rewriteInfoMap;
    private HashSet<CosDictionary> simpleTypeFonts;

    public EmbeddedFontOptimizer(PDFDocument pdfDocument, PDFFontSet fontSet) {
        if (fontSet == null && (fontSet = pdfDocument.getCosDocument().getOptions().getFontSet()) == null) {
            throw new IllegalArgumentException("PDFFontset used to construct object of class PDFEmbeddedFontOptimizer should not be null.");
        }
        if (pdfDocument == null) {
            throw new IllegalArgumentException("PDFDocument used to construct object of class PDFEmbeddedFontOptimizer should not be null.");
        }
        this.pdfDocument = pdfDocument;
        this.fontSet = fontSet;
        this.rewriteInfoMap = new HashMap();
        this.simpleTypeFonts = new HashSet();
    }

    public static EmbeddedFontOptimizer procureEmbeddedFontOptimizer(PDFDocument pdfDoc, PDFFontSet fontSet) {
        PDFFontGroupListener gFontListener = PDFFontGroupListener.getFontGroupListener(pdfDoc);
        EmbeddedFontOptimizer emFontOptimizer = (EmbeddedFontOptimizer)gFontListener.getListener(KEY);
        if (emFontOptimizer == null) {
            emFontOptimizer = new EmbeddedFontOptimizer(pdfDoc, fontSet);
            gFontListener.registerListener(Integer.MAX_VALUE, KEY, emFontOptimizer);
            gFontListener.holdStrongly(KEY, true);
        }
        return emFontOptimizer;
    }

    public void optimize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        Locale docLocale = this.pdfDocument.getCosDocument().getOptions().getDocLocale();
        EmbeddedFontDetailsCollector dc = new EmbeddedFontDetailsCollector(this.pdfDocument);
        Collection<EmbeddedFontDetails> list = dc.getEmbeddedFontDetails();
        System.out.println("List init size " + list.size());
        EmbeddedFontGrouper grouper = new EmbeddedFontGrouper(list);
        Collection<EmbeddedFontGroup> groups = grouper.getEmbeddedFontGroups();
        boolean anyFontReembedded = false;
        for (EmbeddedFontGroup group : groups) {
            if (!group.groupContainsDistinctFontFiles()) continue;
            ArrayList<EmbeddedFontDetails> detailsList = group.getEmbeddedFontDetailList();
            Font systemFont = null;
            if (detailsList.isEmpty()) continue;
            PDFFont pdfFont = detailsList.get(0).getPdfFont();
            String psName = null;
            if (pdfFont instanceof PDFFontType0) {
                psName = ((PDFFontType0)pdfFont).getDescendantFont().getBaseFont().asString(true);
            } else {
                ASName baseFont = pdfFont.getBaseFont();
                if (baseFont != null) {
                    psName = baseFont.asString(true);
                }
            }
            if (psName != null) {
                if (PDFFontUtils.isSubsetFontName(psName)) {
                    psName = psName.substring(7);
                }
                systemFont = ((PDFFontSetImpl)this.fontSet).getPSFont(new PostscriptFontDescription(psName), docLocale, false);
            }
            if (systemFont == null) {
                System.out.println("Could not load system font for " + pdfFont);
                continue;
            }
            boolean firsAttempt = this.processAndRembed(detailsList, systemFont);
            anyFontReembedded |= firsAttempt;
            System.out.println("First Attempt to embed using system font " + firsAttempt);
        }
        System.out.println(groups);
        if (anyFontReembedded) {
            this.updateContentStreams(this.rewriteInfoMap, this.simpleTypeFonts);
        }
    }

    private void updateContentStreams(HashMap<CosDictionary, ContentRewriteInfo> rewriteInfoMap, HashSet<CosDictionary> simpleTypeFonts) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        Iterator<PDFPage> iter = this.pdfDocument.requirePages().iterator();
        while (iter.hasNext()) {
            PDFPatternMap patternmap;
            PDFPage page = iter.next();
            Content content = Content.newInstance(page);
            ContentStreamTransformer.transformContent(content, new CharcodeRewriter(rewriteInfoMap, simpleTypeFonts, content));
            PDFXObjectMap pdfxObjectMap = page.getResources().getXObjectMap();
            if (pdfxObjectMap != null) {
                for (Map.Entry entry : pdfxObjectMap.entrySet()) {
                    PDFXObject xobj = (PDFXObject)entry.getValue();
                    if (!(xobj instanceof PDFXObjectForm)) continue;
                    Content xContent = Content.newInstance((PDFXObjectForm)xobj);
                    ContentStreamTransformer.transformContent(xContent, new CharcodeRewriter(rewriteInfoMap, simpleTypeFonts, xContent));
                }
            }
            if ((patternmap = page.getResources().getPatternMap()) == null) continue;
            Iterator pIter = patternmap.entrySet().iterator();
            while (pIter.hasNext()) {
                PDFPattern pattern = (PDFPattern)((Map.Entry)pIter.next()).getValue();
                if (!(pattern instanceof PDFPatternTiling)) continue;
                Content pContent = Content.newInstance(((PDFPatternTiling)pattern).getContents(), ((PDFPatternTiling)pattern).getResources());
                ContentStreamTransformer.transformContent(pContent, new CharcodeRewriter(rewriteInfoMap, simpleTypeFonts, pContent));
            }
        }
    }

    private boolean processAndRembed(ArrayList<EmbeddedFontDetails> detailsList, Font systemFont) throws PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        FontSuperSetCheck fcheck = new FontSuperSetCheck(systemFont);
        FontReEmbedder fontReEmbedder = new FontReEmbedder(systemFont);
        int countFontsPickedToReembed = 0;
        for (EmbeddedFontDetails embeddedFontDetail : detailsList) {
            boolean check = fcheck.isFontSuperSet(embeddedFontDetail);
            if (check) {
                ++countFontsPickedToReembed;
                fontReEmbedder.addPDFFont(embeddedFontDetail.getPdfFont(), embeddedFontDetail.getCharCodeToGlyphIdMap(), embeddedFontDetail.getCharCodeToUnicodeMap());
            }
            System.out.println("Checking equality against given systemfont resulted in " + check + " for " + embeddedFontDetail.getPdfFont());
        }
        if (countFontsPickedToReembed > 1) {
            fontReEmbedder.rembed(fcheck);
            this.rewriteInfoMap.putAll(fontReEmbedder.getRewriteInfoMap());
            this.simpleTypeFonts.addAll(fontReEmbedder.getSimpleTypeFonts());
            return true;
        }
        return false;
    }

    @Override
    public void message(DocumentMessage message) throws PDFUnableToCompleteOperationException {
        DocumentMessage.MessageType type = message.getMessageType();
        if (type == DocumentMessage.FINISH || type == DocumentMessage.SAVE || type == DocumentMessage.FLUSH_FONTS) {
            try {
                this.optimize();
            }
            catch (PDFException e) {
                throw new PDFUnableToCompleteOperationException(e);
            }
        }
    }

    @Override
    public DocumentListenerProperties getProperties() {
        return null;
    }
}

