/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript.model;

import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import java.lang.reflect.Method;

public final class Function {
    private final String msName;
    private final Param.Type meRetType;
    private final Param.Type[] meParamTypes;
    private final Param[] meParams;
    private final int mnMinParam;
    private final Method mMethod;
    private final boolean isUnsupported;
    private final boolean isGUIError;
    private boolean isSecurityRestricted;

    public Function(Class<?> clazz, String sFunc, Param.Type eRetType, Param[] params, int minParams, boolean isUnsupported, boolean isGUIError) {
        this.msName = sFunc;
        this.meRetType = eRetType;
        this.meParams = params;
        this.mnMinParam = minParams;
        this.isUnsupported = isUnsupported;
        this.isGUIError = isGUIError;
        this.meParamTypes = null;
        Method m = null;
        if (!isUnsupported) {
            Class[] clParams = Param.getClassArray(params);
            try {
                m = clazz.getMethod(sFunc, clParams);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Could not find method for name " + sFunc, e);
            }
        }
        this.mMethod = m;
        m = null;
    }

    public Function(Class<?> clazz, String sFunc, Param.Type eRetType, Param[] params, int minParams, boolean isUnsupported, boolean isGUIError, boolean isSecurityRestricted) {
        this(clazz, sFunc, eRetType, params, minParams, isUnsupported, isGUIError);
        this.isSecurityRestricted = isSecurityRestricted;
    }

    public int getMinParam() {
        return this.mnMinParam;
    }

    public Param.Type[] getParamTypes() {
        return this.meParamTypes;
    }

    public String getName() {
        return this.msName;
    }

    public Param.Type getRetType() {
        return this.meRetType;
    }

    public Method getMMethod() {
        return this.mMethod;
    }

    public boolean getIsUnsupported() {
        return this.isUnsupported;
    }

    public boolean getIsGUIError() {
        return this.isGUIError;
    }

    public Param[] getParams() {
        return this.meParams;
    }

    public boolean isSecurityRestricted() {
        return this.isSecurityRestricted;
    }
}

