/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldAction;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldLock;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.services.digsig.SigFieldLock;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureFieldLockInterface;
import com.adobe.internal.pdftoolkit.services.xfa.impl.SOMExpressionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SignatureFieldLockPDF
implements SignatureFieldLockInterface {
    private PDFFieldLock pdfFieldLock;

    public SignatureFieldLockPDF(PDFFieldLock pdfFieldLock) throws PDFInvalidParameterException {
        if (pdfFieldLock == null) {
            throw new PDFInvalidParameterException("Field Lock provided is null");
        }
        this.pdfFieldLock = pdfFieldLock;
    }

    @Override
    public PDFFieldAction getFieldAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfFieldLock.getPDFFieldAction();
    }

    @Override
    public List<String> getFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] fieldNames = this.pdfFieldLock.getPDFFieldNames();
        if (fieldNames == null || fieldNames.length == 0) {
            return null;
        }
        return Arrays.asList(fieldNames);
    }

    @Override
    public void setFieldAction(PDFFieldAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.pdfFieldLock.setPDFFieldAction(action);
    }

    @Override
    public void setFields(List<String> fieldNames) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fieldNames == null || fieldNames.isEmpty()) {
            this.pdfFieldLock.setPDFFieldNames(null);
        } else {
            this.pdfFieldLock.setPDFFieldNames(fieldNames.toArray(new String[fieldNames.size()]));
        }
    }

    @Override
    public void setFieldLock(SigFieldLock fieldLock) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fieldLock != null) {
            if (this.getFieldAction() != fieldLock.getFieldAction()) {
                this.setFieldAction(fieldLock.getFieldAction());
            }
            if (fieldLock.getFieldAction() == PDFFieldAction.All) {
                fieldLock.setFieldList(null);
            }
            if (fieldLock.getFieldList() != null && fieldLock.getFieldList().size() > 0) {
                List<String> fieldList = fieldLock.getFieldList();
                List<Object> fields = new ArrayList<String>(fieldList.size());
                for (int i = 0; i < fieldList.size(); ++i) {
                    fields.add(SOMExpressionUtils.trimSomExpression(fieldList.get(i)));
                }
                PDFFieldNode[] fieldNodes = PDFFieldUtils.searchFields(fields.toArray(new String[fields.size()]), this.pdfFieldLock.getPDFDocument());
                fields = this.getFields();
                ArrayList<String> resolvedFields = null;
                if (fieldNodes != null) {
                    resolvedFields = new ArrayList<String>();
                    for (PDFFieldNode node : fieldNodes) {
                        resolvedFields.add(node.getQualifiedName());
                    }
                    if (fields != null && !fields.isEmpty()) {
                        Collections.sort(fields);
                        Collections.sort(resolvedFields);
                        if (!fields.equals(resolvedFields)) {
                            this.setFields(resolvedFields);
                        }
                    } else {
                        this.setFields(resolvedFields);
                    }
                } else if (fields != null) {
                    this.setFields(null);
                }
            } else if (this.getFields() != null) {
                this.setFields(null);
            }
            if (this.getFieldPermissions() != fieldLock.getFieldPermission()) {
                this.setFieldPermissions(fieldLock.getFieldPermission());
            }
        } else {
            if (this.getFieldAction() != null) {
                this.setFieldAction(null);
            }
            if (this.getFields() != null) {
                this.setFields(null);
            }
        }
    }

    @Override
    public SigFieldLock getFieldLock() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            PDFFieldAction fieldAction = this.getFieldAction();
            PDFDocMDPPermissions perms = this.getFieldPermissions();
            if (fieldAction == PDFFieldAction.All) {
                return new SigFieldLock(fieldAction, null, perms);
            }
            List<String> fieldList = this.getFields();
            if (fieldList == null || fieldList.isEmpty()) {
                return null;
            }
            return new SigFieldLock(fieldAction, fieldList, perms);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    PDFFieldLock getPDFFieldLock() {
        return this.pdfFieldLock;
    }

    @Override
    public PDFDocMDPPermissions getFieldPermissions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfFieldLock.getLockPermissions();
    }

    @Override
    public void setFieldPermissions(PDFDocMDPPermissions perms) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (perms == null) {
            if (this.pdfFieldLock.getLockPermissions() != null) {
                this.pdfFieldLock.setLockPermissions(null);
            }
        } else if (perms != this.pdfFieldLock.getLockPermissions()) {
            this.pdfFieldLock.setLockPermissions(SignatureUtils.getPossiblePermissionsAllowed(this.pdfFieldLock.getPDFDocument(), perms));
        }
    }
}

