/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.credentials.impl.HSMCredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.securityframework.CryptoMode;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsCADES;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.AbstractDigester;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAHSMCustomDBProvider;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAPKCS7SignedDataBuilder;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSARevInfoUtil;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSATimeStampingUtil;
import com.adobe.internal.pdftoolkit.services.digsig.spi.RevocationInfoProvider;
import com.adobe.internal.pdftoolkit.services.digsig.spi.TimeStampProvider;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.InvalidUseException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.attributes.ContentType;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.pkcs7.SignerInfo;
import com.rsa.certj.provider.db.MemoryDB;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_PKCS11SessionSpec;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.cert.CertificateEncodingException;
import java.util.Date;

public final class RSASigningUtils {
    private RSASigningUtils() {
    }

    public static SignedData buildRSASignedDataWithMemoryDB(RSACredentials credentials, CryptoMode mode) throws CertificateEncodingException, CertificateException, JSAFE_UnimplementedException, InvalidParameterException, ProviderManagementException, InvalidUseException, PKCS7Exception, JSAFE_InvalidUseException {
        CertJ certj = null;
        try {
            Class<?> pkcs7Utils = Class.forName("com.adobe.internal.pdftoolkit.core.encryption.impl.PKCS7Utils");
            Method createCertJContext = pkcs7Utils.getDeclaredMethod("createCertJContext", RSACredentials[].class, CryptoMode.class);
            certj = (CertJ)createCertJContext.invoke(null, new Object[]{new RSACredentials[]{credentials}, mode});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidUseException("can not create certj context without encryption jar");
        }
        DatabaseService dbService = (DatabaseService)certj.bindServices(1);
        CertPathCtx certPathCtx = new CertPathCtx(4, credentials.getRSAX509CertChain(), (byte[][])null, new Date(), dbService);
        return (SignedData)ContentInfo.getInstance((int)2, (CertJ)certj, (CertPathCtx)certPathCtx);
    }

    public static SignedData buildRSASignedDataForHSM(HSMCredentials credentials) throws Exception {
        Certificate[] trustCerts;
        CertJ certJ = new CertJ();
        certJ.setDevice("PKCS11/Java");
        JSAFE_Session[] sessions = credentials.getSession();
        JSAFE_Session p11Session = null;
        JSAFE_PKCS11SessionSpec p11Spec = null;
        if (sessions == null) {
            throw new Exception("There are no available JSAFE Sessions");
        }
        p11Session = sessions[0];
        p11Spec = (JSAFE_PKCS11SessionSpec)p11Session.getSessionSpec();
        certJ.setPKCS11Sessions(sessions);
        Provider p11Provider = RSASigningUtils.createP11Provider(credentials, p11Spec);
        certJ.registerService(p11Provider);
        Certificate[] certChain = credentials.getRSAX509CertChain() == null ? (trustCerts = new Certificate[]{credentials.getRSAX509Cert()}) : (trustCerts = credentials.getRSAX509CertChain());
        DatabaseService dbService = (DatabaseService)certJ.bindService(1, "PKCS 11 Database");
        CertPathCtx pathCtx = new CertPathCtx(4, certChain, (byte[][])null, new Date(), dbService);
        return (SignedData)ContentInfo.getInstance((int)2, (CertJ)certJ, (CertPathCtx)pathCtx);
    }

    private static Provider createP11Provider(HSMCredentials credentials, JSAFE_PKCS11SessionSpec p11Spec) throws InvalidParameterException {
        RSAHSMCustomDBProvider p11Provider = null;
        if (credentials.getCustomDBPref()) {
            p11Provider = new RSAHSMCustomDBProvider("PKCS 11 Database");
            p11Provider.setCredentials(credentials);
            return p11Provider;
        }
        try {
            Class<?> pkcs11db = Class.forName("com.rsa.certj.provider.db.pkcs11.PKCS11DB");
            Constructor<?> constructor = pkcs11db.getConstructor(String.class, JSAFE_PKCS11SessionSpec.class);
            return (Provider)constructor.newInstance("PKCS 11 Database", p11Spec);
        }
        catch (Throwable e) {
            return new MemoryDB("memory Database");
        }
    }

    public static int estimatePacketSizeUsingRSA(RSACredentials credentials, CryptoContext cryptoContext, AbstractDigester msgDigester, boolean isDetached) throws PDFSignatureException {
        int size = 1024;
        try {
            TimeStampProvider tsp;
            X501Attributes attrs;
            RevocationInfoProvider rip;
            X509Certificate rsaCert = credentials.getRSAX509Cert();
            Certificate[] rsaCerts = credentials.getRSAX509CertChain();
            JSAFE_PublicKey pubKey = rsaCert.getSubjectPublicKey("Java");
            int keySize = RSASigningUtils.computeJSAFEPublicKeySize(pubKey);
            size += ASN1.derEncode((ASN1Container[])new ASN1Container[]{new OctetStringContainer(0, true, 0, new byte[keySize], 0, keySize)}).length;
            if (!isDetached) {
                size += msgDigester.getSize();
            }
            size += rsaCert.getIssuerAndSerialNumber().length;
            if (rsaCerts != null) {
                for (int i = 0; i < rsaCerts.length; ++i) {
                    size += ((X509Certificate)rsaCerts[i]).getDERLen(0);
                }
            }
            if ((rip = cryptoContext.getRevocationInfoProvider()) != null && (attrs = RSARevInfoUtil.createAdobeRevocationInfo(rip)) != null) {
                size += attrs.getDERLen(0);
            }
            if ((tsp = cryptoContext.getTimeStampProvider()) != null) {
                byte[] dummySignedData = new byte[msgDigester.getSize()];
                X501Attributes attrs2 = RSATimeStampingUtil.createTSAttribute(dummySignedData, tsp, true);
                size += attrs2.getDERLen(0);
            }
        }
        catch (CertificateException e) {
            throw new PDFSignatureException("Unable to estimate PKCS7 packet size", e);
        }
        catch (ASN_Exception e) {
            throw new PDFSignatureException("Unable to estimate PKCS7 packet size", e);
        }
        return size;
    }

    private static int computeJSAFEPublicKeySize(JSAFE_PublicKey publicKey) {
        byte[][] keyData = publicKey.getKeyData();
        return keyData[0].length * 8;
    }

    public static int estimatePacketSizeUsingRSAForCADES(RSACredentials credentials, CryptoContext cryptoContext, AbstractDigester msgDigester, SignatureOptionsCADES sigOptions) throws PDFSignatureException {
        X501Attribute policyIdentifierAttribute;
        int size = RSASigningUtils.estimatePacketSizeUsingRSA(credentials, cryptoContext, msgDigester, true);
        X501Attribute signingCertificateAttribute = RSAPKCS7SignedDataBuilder.createSigningCertificateAttribute(sigOptions.getCertificateHashAlgorithmName(), credentials.getRSAX509Cert(), sigOptions.isPolicyInformationInSigningCertificateAttributeEnabled());
        if (signingCertificateAttribute != null) {
            size += signingCertificateAttribute.getDERLen(0);
        }
        if (sigOptions.isSignaturePolicyIdentifierAttributeEnabled() && (policyIdentifierAttribute = RSAPKCS7SignedDataBuilder.createPolicyIdentifierAttribute(sigOptions.getPolicyHashAlgorithmName(), credentials.getRSAX509Cert(), sigOptions.getPolicyID())) != null) {
            size += policyIdentifierAttribute.getDERLen(0);
        }
        return size;
    }

    static void addAuthenticatedAttribute(SignerInfo sigInfo, X501Attribute attribute) throws PKCS7Exception {
        X501Attributes signedAttributes = sigInfo.getAuthenticatedAttrs();
        if (signedAttributes == null) {
            signedAttributes = new X501Attributes();
        }
        signedAttributes.addAttribute(attribute);
        sigInfo.setAuthenticatedAttrs(signedAttributes);
    }

    static byte[] getContentTypeAttributeValue(SignerInfo sigInfo) throws PKCS7Exception {
        X501Attributes signedAttributes = sigInfo.getAuthenticatedAttrs();
        if (signedAttributes == null) {
            return null;
        }
        ContentType attribute = (ContentType)signedAttributes.getAttributeByType(14);
        if (attribute == null) {
            return null;
        }
        return attribute.getContentType();
    }

    public static byte[][] buildDERCertChainFromRSA(RSACredentials credentials) throws PDFInvalidParameterException {
        try {
            Certificate[] certChain = credentials.getRSAX509CertChain();
            if (certChain != null) {
                byte[][] derCertChain = new byte[certChain.length][];
                byte[] certHolder = null;
                for (int i = 0; i < certChain.length; ++i) {
                    certHolder = new byte[((X509Certificate)certChain[i]).getDERLen(0)];
                    ((X509Certificate)certChain[i]).getDEREncoding(certHolder, 0, 0);
                    derCertChain[i] = certHolder;
                }
                return derCertChain;
            }
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException(e);
        }
        return null;
    }

    public static byte[] createDERCertFromRSA(RSACredentials credentials) throws PDFInvalidParameterException {
        X509Certificate x509Cert = credentials.getRSAX509Cert();
        try {
            int derLen = x509Cert.getDERLen(0);
            byte[] derCert = new byte[derLen];
            x509Cert.getDEREncoding(derCert, 0, 0);
            return derCert;
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("Cannot get encoded certificate", e);
        }
    }

    public static String getKeyAlgorithm(X509Certificate certificate) throws PDFInvalidParameterException {
        try {
            return certificate.getSubjectPublicKey("Java").getAlgorithm();
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("Cannot obtain key algorithm from the RSA X509 Certificate", e);
        }
    }
}

