/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.FragmentListBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class CrossReferenceBox
extends Jpeg2000Box {
    private long referencedBoxType;
    private FragmentListBox fragmentListBox;

    CrossReferenceBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public long getReferenceBoxType() throws IOException {
        this.lazilyPopulateFields();
        return this.referencedBoxType;
    }

    public FragmentListBox getFragmentListBox() throws IOException {
        this.lazilyPopulateFields();
        return this.fragmentListBox;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.referencedBoxType = Jpeg2000Utils.bytesToLong(boxContents, 4);
            Jpeg2000BoxInfo innerBoxInfo = new Jpeg2000BoxInfo(boxContents);
            if (innerBoxInfo.getType() == Jpeg2000BoxType.fragmentListBox) {
                this.fragmentListBox = new FragmentListBox(innerBoxInfo);
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        try {
            if (this.fragmentListBox != null) {
                this.fragmentListBox.close();
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

