/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.pdftoolkit.core.types.ASName;

public enum PDFPageLabelStyle {
    Decimal(ASName.create("D")),
    UppercaseRoman(ASName.create("R")),
    LowercaseRoman(ASName.create("r")),
    UppercaseLetter(ASName.create("A")),
    LowercaseLetter(ASName.create("a"));

    private final ASName value;

    private PDFPageLabelStyle(ASName style) {
        this.value = style;
    }

    static PDFPageLabelStyle getInstance(ASName style) {
        if (style == Decimal.getValue()) {
            return Decimal;
        }
        if (style == UppercaseRoman.getValue()) {
            return UppercaseRoman;
        }
        if (style == LowercaseRoman.getValue()) {
            return LowercaseRoman;
        }
        if (style == UppercaseLetter.getValue()) {
            return UppercaseLetter;
        }
        if (style == LowercaseLetter.getValue()) {
            return LowercaseLetter;
        }
        return null;
    }

    ASName getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.asString(true);
    }
}

