/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageBoxColor;

public class PDFPageBoxColorInfo
extends PDFCosDictionary {
    private PDFPageBoxColorInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPageBoxColorInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPageBoxColorInfo pdfObject = (PDFPageBoxColorInfo)PDFCosObject.getCachedInstance(cosObject, PDFPageBoxColorInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFPageBoxColorInfo(cosObject);
        }
        return pdfObject;
    }

    public boolean hasCropBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CropBox);
    }

    public PDFPageBoxColor getCropBoxColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageBoxColor.getInstance(this.getDictionaryDictionaryValue(ASName.k_CropBox));
    }

    public boolean hasBleedBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BleedBox);
    }

    public PDFPageBoxColor getBleedBoxColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageBoxColor.getInstance(this.getDictionaryDictionaryValue(ASName.k_BleedBox));
    }

    public boolean hasTrimBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TrimBox);
    }

    public PDFPageBoxColor getTrimBoxColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageBoxColor.getInstance(this.getDictionaryDictionaryValue(ASName.k_TrimBox));
    }

    public boolean hasArtBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ArtBox);
    }

    public PDFPageBoxColor getArtBoxColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageBoxColor.getInstance(this.getDictionaryDictionaryValue(ASName.k_ArtBox));
    }

    public void setArtBoxColor(PDFPageBoxColor boxColor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ArtBox, boxColor);
    }

    public void setBleedBoxColor(PDFPageBoxColor boxColor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_BleedBox, boxColor);
    }

    public void setCropBoxColor(PDFPageBoxColor boxColor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_CropBox, boxColor);
    }

    public void setTrimBoxColor(PDFPageBoxColor boxColor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_TrimBox, boxColor);
    }
}

