/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFCuePointList;

public class PDFRichMediaParams
extends PDFCosDictionary {
    public static final ASName k_Foreground = ASName.create("Foreground");
    public static final ASName k_Background = ASName.create("Background");
    public static final ASName k_Material = ASName.create("Material");

    private PDFRichMediaParams(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaParams newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaParams pdfObject = new PDFRichMediaParams(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaParams getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaParams pdfObject = (PDFRichMediaParams)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaParams.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaParams(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.k_RichMediaParams)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Type value is not valid. " + ASName.k_RichMediaParams + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFText getFlashVarsAsTextString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(ASName.k_FlashVars));
    }

    public void setFlashVars(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryTextValue(ASName.k_FlashVars, value);
    }

    public PDFStream getFlashVarsAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStream.getInstance(this.getDictionaryCosObjectValue(ASName.k_FlashVars));
    }

    public void setFlashVarsAsStream(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_FlashVars, value);
    }

    public boolean hasFlashVars() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_FlashVars);
    }

    public ASName getBinding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Binding);
    }

    public void setBinding(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Binding);
        } else if (value.equals(k_Foreground) || value.equals(k_Background) || value.equals(k_Material)) {
            this.setDictionaryNameValue(ASName.k_Binding, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Binding.");
        }
    }

    public boolean hasBinding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Binding);
    }

    public PDFText getBindingMaterialName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(ASName.k_BindingMaterialName));
    }

    public void setBindingMaterialName(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            if (this.hasBinding() && this.getBinding() == k_Material) {
                throw new PDFInvalidParameterException("BindingMaterialName is a required key therefore cannot be removed.");
            }
            this.removeValue(ASName.k_BindingMaterialName);
        } else {
            this.setDictionaryTextValue(ASName.k_BindingMaterialName, value);
        }
    }

    public boolean hasBindingMaterialName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BindingMaterialName);
    }

    public PDFCuePointList getCuePoints() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(ASName.k_CuePoints);
        return PDFCuePointList.getInstance(cosObject);
    }

    public void setCuePoints(PDFCuePointList value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_CuePoints, value);
    }

    public boolean hasCuePoints() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CuePoints);
    }

    public PDFText getSettingsAsTextString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(ASName.k_Settings));
    }

    public void setSettingsAsTextString(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryTextValue(ASName.k_Settings, value);
    }

    public PDFStream getSettingsAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStream.getInstance(this.getDictionaryCosObjectValue(ASName.k_Settings));
    }

    public void setSettingsAsStream(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Settings, value);
    }

    public boolean hasSettings() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Settings);
    }
}

