/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;

public class PDFMovie
extends PDFCosDictionary {
    private PDFMovie(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMovie newInstance(PDFDocument pdfDocument, PDFFileSpecification key_F) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_F == null) {
            throw new PDFInvalidParameterException("F is required when creating newInstance of PDFMovie.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMovie pdfObject = new PDFMovie(cosObject);
        pdfObject.setFileSpecification(key_F);
        return pdfObject;
    }

    public static PDFMovie getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMovie pdfObject = (PDFMovie)PDFCosObject.getCachedInstance(cosObject, PDFMovie.class);
        if (pdfObject == null) {
            pdfObject = new PDFMovie(cosObject);
        }
        return pdfObject;
    }

    public PDFXObjectImage getPosterAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXObjectImage.getInstance(this.getDictionaryCosObjectValue(ASName.k_Poster));
    }

    public void setPoster(PDFXObjectImage value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Poster, value);
    }

    public boolean getPosterAsBool() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Poster);
    }

    public void setPoster(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Poster, value);
    }

    public boolean hasPoster() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Poster);
    }

    public CosArray getAspect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Aspect);
    }

    public void setAspect(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Aspect, value);
    }

    public boolean hasAspect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Aspect);
    }

    public PDFFileSpecification getFileSpecificationAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    public void setFileSpecification(PDFFileSpecification value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_F, value);
    }

    public ASString getFileSpecificationAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_F);
    }

    public void setFileSpecification(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_F, value);
    }

    public void setFileSpecification(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_F, value);
    }

    public boolean hasFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }

    public int getRotate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Rotate);
    }

    public void setRotate(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Rotate, value);
    }

    public boolean hasRotate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Rotate);
    }
}

