/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRichMedia;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFExData;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVDict;

public class PDFExDataRichMedia
extends PDFExData {
    private PDFExDataRichMedia(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFExDataRichMedia newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFExDataRichMedia pdfObject = new PDFExDataRichMedia(PDFCosObject.newCosDictionary(pdfDocument));
        pdfObject.setSubtype();
        return pdfObject;
    }

    private void setSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Subtype, PDFExData.k_RichMedia);
    }

    public static PDFExDataRichMedia getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFExDataRichMedia pdfObject = (PDFExDataRichMedia)PDFCosObject.getCachedInstance(cosObject, PDFExDataRichMedia.class);
        if (pdfObject == null) {
            pdfObject = new PDFExDataRichMedia(cosObject);
        }
        return pdfObject;
    }

    public PDFAnnotationRichMedia getRichMediaAnnot() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationRichMedia.getInstance(this.getDictionaryCosObjectValue(ASName.k_Annot));
    }

    public void setRichMediaAnnot(PDFAnnotationRichMedia value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Annot is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Annot, value);
    }

    public PDF3DVDict getRichMediaViewDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DVDict.getInstance(this.getDictionaryCosObjectValue(ASName.k_View));
    }

    public void setRichMediaViewDict(PDF3DVDict value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("View is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_View, value);
    }

    public ASString getMD5() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_MD5);
    }

    public void setMD5(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_MD5, value);
    }

    public boolean hasMD5() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MD5);
    }
}

